/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexPattern {
    @NotNull
    private String myPatternString;
    private Pattern myOptimizedIndexingPattern;
    private boolean myCaseSensitive;
    private Pattern myPattern;

    public IndexPattern(@NotNull String patternString, boolean caseSensitive) {
        if (patternString == null) {
            IndexPattern.$$$reportNull$$$0(0);
        }
        this.myPatternString = patternString;
        this.myCaseSensitive = caseSensitive;
        this.compilePattern();
    }

    @NotNull
    public String getPatternString() {
        String string = this.myPatternString;
        if (string == null) {
            IndexPattern.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public Pattern getPattern() {
        return this.myPattern;
    }

    @Nullable
    public Pattern getOptimizedIndexingPattern() {
        return this.myOptimizedIndexingPattern;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public void setPatternString(@NotNull String patternString) {
        if (patternString == null) {
            IndexPattern.$$$reportNull$$$0(2);
        }
        this.myPatternString = patternString;
        this.compilePattern();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
        this.compilePattern();
    }

    private void compilePattern() {
        try {
            int flags = 0;
            if (!this.myCaseSensitive) {
                flags = 2;
            }
            this.myPattern = Pattern.compile(this.myPatternString, flags);
            String optimizedPattern = this.myPatternString;
            optimizedPattern = StringUtil.trimStart(optimizedPattern, ".*");
            this.myOptimizedIndexingPattern = Pattern.compile(optimizedPattern, flags);
        }
        catch (PatternSyntaxException e) {
            this.myPattern = null;
            this.myOptimizedIndexingPattern = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexPattern that = (IndexPattern)o;
        if (this.myCaseSensitive != that.myCaseSensitive) {
            return false;
        }
        return this.myPatternString.equals(that.myPatternString);
    }

    public int hashCode() {
        int result = this.myPatternString.hashCode();
        result = 29 * result + (this.myCaseSensitive ? 1 : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/IndexPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/IndexPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPatternString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

