/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlNSDescriptorEx;
import com.intellij.xml.impl.ExternalDocumentValidator;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.RedefinedElementDescriptor;
import com.intellij.xml.impl.schema.SimpleTypeDescriptor;
import com.intellij.xml.impl.schema.StdTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorByType;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XsdNsDescriptor;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNSDescriptorImpl
implements XmlNSDescriptorEx,
Validator<XmlDocument>,
DumbAware,
XsdNsDescriptor {
    @NonNls
    public static final String XSD_PREFIX = "xsd";
    @NonNls
    public static final String SCHEMA_TAG_NAME = "schema";
    @NonNls
    public static final String IMPORT_TAG_NAME = "import";
    @NonNls
    static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    static final String ATTRIBUTE_TAG_NAME = "attribute";
    @NonNls
    static final String COMPLEX_TYPE_TAG_NAME = "complexType";
    @NonNls
    static final String SEQUENCE_TAG_NAME = "sequence";
    private static final Logger LOG = Logger.getInstance("#com.intellij.xml.impl.schema.XmlNSDescriptorImpl");
    @NonNls
    private static final Set<String> STD_TYPES = new HashSet<String>();
    private static final Set<String> UNDECLARED_STD_TYPES = new HashSet<String>();
    @NonNls
    private static final String INCLUDE_TAG_NAME = "include";
    @NonNls
    private static final String REDEFINE_TAG_NAME = "redefine";
    private static final ThreadLocal<Set<PsiFile>> myRedefinedDescriptorsInProcessing = new ThreadLocal();
    private final Map<QNameKey, CachedValue<XmlElementDescriptor>> myDescriptorsMap = Collections.synchronizedMap(new HashMap());
    private final Map<Pair<QNameKey, XmlTag>, CachedValue<TypeDescriptor>> myTypesMap = Collections.synchronizedMap(new HashMap());
    private XmlFile myFile;
    private XmlTag myTag;
    private String myTargetNamespace;
    private volatile Object[] dependencies;
    private MultiMap<String, XmlTag> mySubstitutions;

    public XmlNSDescriptorImpl(XmlFile file) {
        this.init(file.getDocument());
    }

    public XmlNSDescriptorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectDependencies(@Nullable XmlTag myTag, @NotNull XmlFile myFile, @NotNull Set<PsiFile> visited) {
        XmlTag[] tags;
        if (myFile == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(0);
        }
        if (visited == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(1);
        }
        if (visited.contains(myFile)) {
            return;
        }
        visited.add(myFile);
        if (myTag == null) {
            return;
        }
        for (XmlTag tag : tags = myTag.getSubTags()) {
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, IMPORT_TAG_NAME)) {
                String schemaLocation = tag.getAttributeValue("schemaLocation");
                if (schemaLocation == null) continue;
                XmlFile xmlFile = XmlUtil.findNamespace(myFile, schemaLocation);
                XmlNSDescriptorImpl.addDependency(xmlFile, visited);
                continue;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, REDEFINE_TAG_NAME)) continue;
            myRedefinedDescriptorsInProcessing.set(visited);
            try {
                XmlFile file = XmlNSDescriptorImpl.getRedefinedElementDescriptorFile(tag);
                XmlNSDescriptorImpl.addDependency(file, visited);
            }
            finally {
                myRedefinedDescriptorsInProcessing.set(null);
            }
        }
        String schemaLocationDeclaration = myTag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        if (schemaLocationDeclaration != null) {
            StringTokenizer tokenizer = new StringTokenizer(schemaLocationDeclaration);
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                PsiFile resourceLocation = ExternalResourceManager.getInstance().getResourceLocation(tokenizer.nextToken(), myFile, null);
                if (resourceLocation == null) {
                    resourceLocation = ExternalResourceManager.getInstance().getResourceLocation(uri, myFile, null);
                }
                if (!(resourceLocation instanceof XmlFile)) continue;
                XmlNSDescriptorImpl.addDependency((XmlFile)resourceLocation, visited);
            }
        }
    }

    private static void addDependency(XmlFile file, Set<PsiFile> visited) {
        if (file != null) {
            XmlDocument document = file.getDocument();
            XmlNSDescriptorImpl.collectDependencies(document != null ? document.getRootTag() : null, file, visited);
        }
    }

    private static boolean checkSchemaNamespace(String name, XmlTag context) {
        String namespace = context.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(name));
        if (namespace.length() > 0) {
            return XmlNSDescriptorImpl.checkSchemaNamespace(namespace);
        }
        return XSD_PREFIX.equals(XmlUtil.findPrefixByQualifiedName(name));
    }

    public static boolean checkSchemaNamespace(String namespace) {
        return "http://www.w3.org/2001/XMLSchema".equals(namespace) || "http://www.w3.org/1999/XMLSchema".equals(namespace) || "http://www.w3.org/2000/10/XMLSchema".equals(namespace);
    }

    public static boolean checkSchemaNamespace(@NotNull XmlTag context) {
        if (context == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(context.isValid());
        String namespace = context.getNamespace();
        if (namespace.length() > 0) {
            return XmlNSDescriptorImpl.checkSchemaNamespace(namespace);
        }
        return StringUtil.startsWithConcatenation(context.getName(), XSD_PREFIX, ":");
    }

    @NotNull
    static XmlNSDescriptorImpl getNSDescriptorToSearchIn(XmlTag rootTag, String name, XmlNSDescriptorImpl defaultNSDescriptor) {
        String namespace;
        XmlNSDescriptor nsDescriptor;
        if (name == null) {
            XmlNSDescriptorImpl xmlNSDescriptorImpl = defaultNSDescriptor;
            if (xmlNSDescriptorImpl == null) {
                XmlNSDescriptorImpl.$$$reportNull$$$0(3);
            }
            return xmlNSDescriptorImpl;
        }
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(name);
        if (namespacePrefix.length() > 0 && (nsDescriptor = rootTag.getNSDescriptor(namespace = rootTag.getNamespaceByPrefix(namespacePrefix), true)) instanceof XmlNSDescriptorImpl) {
            XmlNSDescriptorImpl xmlNSDescriptorImpl = (XmlNSDescriptorImpl)nsDescriptor;
            if (xmlNSDescriptorImpl == null) {
                XmlNSDescriptorImpl.$$$reportNull$$$0(4);
            }
            return xmlNSDescriptorImpl;
        }
        XmlNSDescriptorImpl xmlNSDescriptorImpl = defaultNSDescriptor;
        if (xmlNSDescriptorImpl == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(5);
        }
        return xmlNSDescriptorImpl;
    }

    @Nullable
    private static XmlElementDescriptor getDescriptorFromParent(XmlTag tag, XmlElementDescriptor elementDescriptor) {
        XmlElementDescriptor descriptor;
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag && (descriptor = ((XmlTag)parent).getDescriptor()) != null) {
            elementDescriptor = descriptor.getElementDescriptor(tag, (XmlTag)parent);
        }
        return elementDescriptor;
    }

    @Override
    public boolean processTagsInNamespace(String[] tagNames, PsiElementProcessor<XmlTag> processor) {
        return XmlNSDescriptorImpl.processTagsInNamespaceInner(this.myTag, tagNames, processor, null);
    }

    private static boolean processTagsInNamespaceInner(@NotNull XmlTag rootTag, String[] tagNames, PsiElementProcessor<XmlTag> processor, Set<XmlTag> visitedTags) {
        XmlTag[] tags;
        if (rootTag == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(6);
        }
        if (visitedTags == null) {
            visitedTags = new HashSet<XmlTag>(3);
        } else if (visitedTags.contains(rootTag)) {
            return true;
        }
        visitedTags.add(rootTag);
        block0: for (XmlTag tag : tags = rootTag.getSubTags()) {
            XmlDocument includedDocument;
            XmlFile xmlFile;
            String schemaLocation;
            for (String tagName : tagNames) {
                if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, tagName)) continue;
                String name = tag.getAttributeValue("name");
                if (name == null || processor.execute(tag)) continue block0;
                return false;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) || (schemaLocation = tag.getAttributeValue("schemaLocation")) == null || (xmlFile = XmlUtil.findNamespace(rootTag.getContainingFile(), schemaLocation)) == null || (includedDocument = xmlFile.getDocument()) == null || XmlNSDescriptorImpl.processTagsInNamespaceInner(includedDocument.getRootTag(), tagNames, processor, visitedTags)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsToSchemaName(@NotNull XmlTag tag, @NonNls String schemaName) {
        if (tag == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(7);
        }
        return schemaName.equals(tag.getLocalName()) && XmlNSDescriptorImpl.checkSchemaNamespace(tag);
    }

    @Nullable
    private static XmlTag findSpecialTag(@NonNls String name, @NonNls String specialName, XmlTag rootTag, XmlNSDescriptorImpl descriptor, HashSet<XmlTag> visited) {
        XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getNSDescriptorToSearchIn(rootTag, name, descriptor);
        if (nsDescriptor != descriptor) {
            XmlDocument document;
            XmlDocument xmlDocument = document = nsDescriptor.getDescriptorFile() != null ? nsDescriptor.getDescriptorFile().getDocument() : null;
            if (document == null) {
                return null;
            }
            return XmlNSDescriptorImpl.findSpecialTag(XmlUtil.findLocalNameByQualifiedName(name), specialName, document.getRootTag(), nsDescriptor, visited);
        }
        if (visited == null) {
            visited = new HashSet(1);
        } else if (visited.contains(rootTag)) {
            return null;
        }
        visited.add(rootTag);
        XmlTag[] tags = rootTag.getSubTags();
        return XmlNSDescriptorImpl.findSpecialTagIn(tags, specialName, name, rootTag, descriptor, visited);
    }

    private static XmlTag findSpecialTagIn(XmlTag[] tags, String specialName, String name, XmlTag rootTag, XmlNSDescriptorImpl descriptor, HashSet<XmlTag> visited) {
        for (XmlTag tag : tags) {
            XmlTag redefinedRootTag;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, specialName)) {
                String attribute = tag.getAttributeValue("name");
                if (!name.equals(attribute) && (!name.contains(":") || !name.substring(name.indexOf(":") + 1).equals(attribute))) continue;
                return tag;
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, IMPORT_TAG_NAME) && rootTag.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(name)).equals(tag.getAttributeValue("namespace"))) {
                XmlTag rTag;
                XmlDocument document;
                XmlFile xmlFile;
                String schemaLocation = tag.getAttributeValue("schemaLocation");
                if (schemaLocation == null || (xmlFile = XmlUtil.findNamespace(rootTag.getContainingFile(), schemaLocation)) == null || (document = xmlFile.getDocument()) == null || (rTag = XmlNSDescriptorImpl.findSpecialTag(name, specialName, document.getRootTag(), descriptor, visited)) == null) continue;
                return rTag;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, REDEFINE_TAG_NAME)) continue;
            XmlTag rTag = XmlNSDescriptorImpl.findSpecialTagIn(tag.getSubTags(), specialName, name, rootTag, descriptor, visited);
            if (rTag != null) {
                return rTag;
            }
            XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getRedefinedElementDescriptor(tag);
            if (nsDescriptor == null || (rTag = XmlNSDescriptorImpl.findSpecialTagIn((redefinedRootTag = ((XmlDocument)nsDescriptor.getDeclaration()).getRootTag()).getSubTags(), specialName, name, redefinedRootTag, nsDescriptor, visited)) == null) continue;
            return rTag;
        }
        return null;
    }

    public static XmlNSDescriptorImpl getRedefinedElementDescriptor(XmlTag parentTag) {
        XmlFile file = XmlNSDescriptorImpl.getRedefinedElementDescriptorFile(parentTag);
        if (file != null) {
            PsiMetaData metaData;
            XmlDocument document = file.getDocument();
            PsiMetaData psiMetaData = metaData = document != null ? document.getMetaData() : null;
            if (metaData instanceof XmlNSDescriptorImpl) {
                return (XmlNSDescriptorImpl)metaData;
            }
        }
        return null;
    }

    public static XmlFile getRedefinedElementDescriptorFile(XmlTag parentTag) {
        PsiElement psiElement;
        PsiReference[] references;
        String schemaL = parentTag.getAttributeValue("schemaLocation");
        if (schemaL != null && (references = parentTag.getAttribute("schemaLocation", null).getValueElement().getReferences()).length > 0 && (psiElement = references[references.length - 1].resolve()) instanceof XmlFile) {
            return (XmlFile)psiElement;
        }
        return null;
    }

    @Override
    public XmlFile getDescriptorFile() {
        return this.myFile;
    }

    public String getDefaultNamespace() {
        return this.myTargetNamespace != null ? this.myTargetNamespace : "";
    }

    @Override
    @Nullable
    public XmlElementDescriptor getElementDescriptor(String localName, String namespace) {
        return this.getElementDescriptor(localName, namespace, new HashSet<XmlNSDescriptorImpl>(), false);
    }

    @Override
    @Nullable
    public XmlElementDescriptor getElementDescriptor(String localName, String namespace, Set<XmlNSDescriptorImpl> visited, boolean reference) {
        XmlElementDescriptor value;
        if (visited.contains(this)) {
            return null;
        }
        QNameKey pair = new QNameKey(namespace, localName);
        CachedValue<XmlElementDescriptor> descriptor = this.myDescriptorsMap.get(pair);
        if (descriptor != null && ((value = descriptor.getValue()) == null || value.getDeclaration().isValid())) {
            return value;
        }
        XmlTag rootTag = this.myTag;
        if (rootTag == null) {
            return null;
        }
        XmlTag[] tags = rootTag.getSubTags();
        visited.add(this);
        LOG.assertTrue(rootTag.isValid());
        for (XmlTag tag : tags) {
            XmlElementDescriptor xmlElementDescriptor;
            XmlNSDescriptorImpl nsDescriptor;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, ELEMENT_TAG_NAME)) {
                String name = tag.getAttributeValue("name");
                if (name == null || !this.checkElementNameEquivalence(localName, namespace, name, tag)) continue;
                CachedValue cachedValue = CachedValuesManager.getManager(tag.getProject()).createCachedValue(() -> {
                    String name1 = tag.getAttributeValue("name");
                    if (name1 != null && !name1.equals(pair.second)) {
                        this.myDescriptorsMap.remove(pair);
                        return new CachedValueProvider.Result<Object>(null, PsiModificationTracker.MODIFICATION_COUNT);
                    }
                    XmlElementDescriptor xmlElementDescriptor = this.createElementDescriptor(tag);
                    return new CachedValueProvider.Result<XmlElementDescriptor>(xmlElementDescriptor, xmlElementDescriptor.getDependences());
                }, false);
                this.myDescriptorsMap.put(pair, cachedValue);
                return (XmlElementDescriptor)cachedValue.getValue();
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) || reference && XmlNSDescriptorImpl.equalsToSchemaName(tag, IMPORT_TAG_NAME) && (namespace.equals(tag.getAttributeValue("namespace")) || namespace.length() == 0 && tag.getAttributeValue("namespace") == null)) {
                XmlElementDescriptor elementDescriptor;
                PsiMetaData data;
                XmlDocument includedDocument;
                XmlFile xmlFile;
                String schemaLocation = tag.getAttributeValue("schemaLocation");
                if (schemaLocation == null || (xmlFile = XmlUtil.findNamespace(rootTag.getContainingFile(), schemaLocation)) == null || (includedDocument = xmlFile.getDocument()) == null || !((data = includedDocument.getMetaData()) instanceof XmlNSDescriptorImpl) || (elementDescriptor = ((XmlNSDescriptorImpl)data).getElementDescriptor(localName, namespace, visited, reference)) == null) continue;
                return elementDescriptor;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, REDEFINE_TAG_NAME) || (nsDescriptor = XmlNSDescriptorImpl.getRedefinedElementDescriptor(tag)) == null || !((xmlElementDescriptor = nsDescriptor.getElementDescriptor(localName, namespace, visited, reference)) instanceof XmlElementDescriptorImpl)) continue;
            return new RedefinedElementDescriptor((XmlElementDescriptorImpl)xmlElementDescriptor, this);
        }
        return null;
    }

    protected XmlElementDescriptor createElementDescriptor(XmlTag tag) {
        return new XmlElementDescriptorImpl(tag);
    }

    private boolean checkElementNameEquivalence(String localName, String namespace, String fqn, XmlTag context) {
        String localAttrName = XmlUtil.findLocalNameByQualifiedName(fqn);
        if (!localAttrName.equals(localName)) {
            return false;
        }
        String attrNamespace = context.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(fqn));
        if (attrNamespace.equals(namespace)) {
            return true;
        }
        if (this.myTargetNamespace == null) {
            return "".equals(attrNamespace);
        }
        if (this.myTargetNamespace.equals(namespace)) {
            return true;
        }
        return context.getNSDescriptor(namespace, true) == this;
    }

    @Override
    @Nullable
    public XmlAttributeDescriptor getAttribute(String localName, String namespace, XmlTag context) {
        return this.getAttributeImpl(localName, namespace, null);
    }

    @Nullable
    private XmlAttributeDescriptor getAttributeImpl(String localName, String namespace, @Nullable Set<XmlTag> visited) {
        XmlTag[] tags;
        if (this.myTag == null) {
            return null;
        }
        XmlNSDescriptor nsDescriptor = this.myTag.getNSDescriptor(namespace, true);
        if (nsDescriptor != this && nsDescriptor instanceof XmlNSDescriptorImpl) {
            return ((XmlNSDescriptorImpl)nsDescriptor).getAttributeImpl(localName, namespace, visited);
        }
        if (visited == null) {
            visited = new HashSet<XmlTag>(1);
        } else if (visited.contains(this.myTag)) {
            return null;
        }
        visited.add(this.myTag);
        for (XmlTag tag : tags = this.myTag.getSubTags()) {
            XmlAttributeDescriptor attributeDescriptor;
            PsiMetaData data;
            XmlDocument includedDocument;
            XmlFile xmlFile;
            String schemaLocation;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, ATTRIBUTE_TAG_NAME)) {
                String name = tag.getAttributeValue("name");
                if (name == null || !this.checkElementNameEquivalence(localName, namespace, name, tag)) continue;
                return this.createAttributeDescriptor(tag);
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) && (!XmlNSDescriptorImpl.equalsToSchemaName(tag, IMPORT_TAG_NAME) || !namespace.equals(tag.getAttributeValue("namespace"))) || (schemaLocation = tag.getAttributeValue("schemaLocation")) == null || (xmlFile = XmlUtil.findNamespace(this.myTag.getContainingFile(), schemaLocation)) == null || (includedDocument = xmlFile.getDocument()) == null || !((data = includedDocument.getMetaData()) instanceof XmlNSDescriptorImpl) || (attributeDescriptor = ((XmlNSDescriptorImpl)data).getAttributeImpl(localName, namespace, visited)) == null) continue;
            CachedValue value = CachedValuesManager.getManager(includedDocument.getProject()).createCachedValue(() -> {
                Object[] deps = attributeDescriptor.getDependences();
                if (deps.length == 0) {
                    LOG.error(attributeDescriptor + " (" + attributeDescriptor.getClass() + ") returned no dependencies");
                }
                return new CachedValueProvider.Result<XmlAttributeDescriptor>(attributeDescriptor, deps);
            }, false);
            return (XmlAttributeDescriptor)value.getValue();
        }
        return null;
    }

    protected XmlAttributeDescriptorImpl createAttributeDescriptor(XmlTag tag) {
        return new XmlAttributeDescriptorImpl(tag);
    }

    @Override
    public TypeDescriptor getTypeDescriptor(XmlTag descriptorTag) {
        String type = descriptorTag.getAttributeValue("type");
        if (type != null) {
            return this.getTypeDescriptor(type, descriptorTag);
        }
        return this.findTypeDescriptorImpl(descriptorTag, null, null);
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String name, XmlTag context) {
        String localNameByQualifiedName;
        if (XmlNSDescriptorImpl.checkSchemaNamespace(name, context) && STD_TYPES.contains(localNameByQualifiedName = XmlUtil.findLocalNameByQualifiedName(name)) && (name.length() == localNameByQualifiedName.length() || UNDECLARED_STD_TYPES.contains(localNameByQualifiedName))) {
            return new StdTypeDescriptor(localNameByQualifiedName);
        }
        return this.findTypeDescriptor(name, context);
    }

    @Nullable
    public XmlElementDescriptor getDescriptorByType(String qName, XmlTag instanceTag) {
        if (this.myTag == null) {
            return null;
        }
        TypeDescriptor typeDescriptor = this.findTypeDescriptor(qName, instanceTag);
        if (!(typeDescriptor instanceof ComplexTypeDescriptor)) {
            return null;
        }
        return new XmlElementDescriptorByType(instanceTag, (ComplexTypeDescriptor)typeDescriptor);
    }

    @Nullable
    protected TypeDescriptor findTypeDescriptor(String qname) {
        return this.findTypeDescriptor(qname, this.myTag);
    }

    @Nullable
    private TypeDescriptor findTypeDescriptor(String qname, XmlTag context) {
        String namespace = context.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(qname));
        String localName = XmlUtil.findLocalNameByQualifiedName(qname);
        return this.findTypeDescriptorImpl(this.myTag, localName, namespace.isEmpty() ? this.getDefaultNamespace() : namespace);
    }

    @Override
    @Nullable
    public TypeDescriptor findTypeDescriptor(String localName, String namespace) {
        return this.findTypeDescriptorImpl(this.myTag, localName, namespace);
    }

    @Nullable
    private TypeDescriptor findTypeDescriptorImpl(@Nullable XmlTag rootTag, String name, String namespace) {
        if (rootTag == null) {
            return null;
        }
        return RecursionManager.createGuard("findDescriptor").doPreventingRecursion(rootTag, true, () -> {
            TypeDescriptor value;
            XmlNSDescriptor nsDescriptor;
            XmlNSDescriptorImpl responsibleDescriptor = this;
            if (namespace != null && namespace.length() != 0 && !namespace.equals(this.getDefaultNamespace()) && (nsDescriptor = rootTag.getNSDescriptor(namespace, true)) instanceof XmlNSDescriptorImpl) {
                responsibleDescriptor = (XmlNSDescriptorImpl)nsDescriptor;
            }
            if (responsibleDescriptor != this) {
                return responsibleDescriptor.findTypeDescriptor(name, namespace);
            }
            Pair<QNameKey, XmlTag> pair = Pair.create(new QNameKey(name, namespace), rootTag);
            CachedValue<TypeDescriptor> descriptor = this.myTypesMap.get(pair);
            if (descriptor != null && ((value = descriptor.getValue()) == null || value instanceof ComplexTypeDescriptor && ((ComplexTypeDescriptor)value).getDeclaration().isValid())) {
                return value;
            }
            XmlTag[] tags = rootTag.getSubTags();
            return this.doFindIn(tags, name, namespace, pair, rootTag);
        });
    }

    private TypeDescriptor doFindIn(XmlTag[] tags, String name, String namespace, Pair<QNameKey, XmlTag> pair, XmlTag rootTag) {
        for (XmlTag tag : tags) {
            XmlTag redefinedRootTag;
            CachedValue<TypeDescriptor> cachedValue;
            String nameAttribute;
            CachedValue<TypeDescriptor> value;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, COMPLEX_TYPE_TAG_NAME)) {
                if (name == null) {
                    value = this.createAndPutTypesCachedValue(tag, pair);
                    return value.getValue();
                }
                nameAttribute = tag.getAttributeValue("name");
                if (!this.isSameName(name, namespace, nameAttribute)) continue;
                cachedValue = this.createAndPutTypesCachedValue(tag, pair);
                return cachedValue.getValue();
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "simpleType")) {
                if (name == null) {
                    value = this.createAndPutTypesCachedValueSimpleType(tag, pair);
                    return value.getValue();
                }
                nameAttribute = tag.getAttributeValue("name");
                if (!this.isSameName(name, namespace, nameAttribute)) continue;
                cachedValue = this.createAndPutTypesCachedValue(tag, pair);
                return cachedValue.getValue();
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, IMPORT_TAG_NAME) && (namespace == null || !namespace.equals(this.getDefaultNamespace()))) {
                CachedValue value2;
                XmlDocument document;
                XmlFile xmlFile;
                String schemaLocation = tag.getAttributeValue("schemaLocation");
                if (schemaLocation == null || (xmlFile = XmlUtil.findNamespace(rootTag.getContainingFile(), schemaLocation)) == null || (document = xmlFile.getDocument()) == null || (value2 = CachedValuesManager.getManager(tag.getProject()).createCachedValue(() -> {
                    String currentName = tag.getAttributeValue("name");
                    if (currentName != null && !currentName.equals(XmlUtil.findLocalNameByQualifiedName(name)) || !xmlFile.isValid() || xmlFile.getDocument() == null) {
                        this.myTypesMap.remove(pair);
                        return new CachedValueProvider.Result<Object>(null, PsiModificationTracker.MODIFICATION_COUNT);
                    }
                    XmlDocument document1 = xmlFile.getDocument();
                    XmlNSDescriptorImpl nsDescriptor = this.findNSDescriptor(tag, document1);
                    if (nsDescriptor == null) {
                        this.myTypesMap.remove(pair);
                        return new CachedValueProvider.Result<Object>(null, PsiModificationTracker.MODIFICATION_COUNT);
                    }
                    XmlTag rTag = document1.getRootTag();
                    TypeDescriptor complexTypeDescriptor = nsDescriptor.findTypeDescriptorImpl(rTag, name, namespace);
                    return new CachedValueProvider.Result<TypeDescriptor>(complexTypeDescriptor, rTag);
                }, false)).getValue() == null) continue;
                this.myTypesMap.put(pair, value2);
                return (TypeDescriptor)value2.getValue();
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, REDEFINE_TAG_NAME)) continue;
            XmlTag[] subTags = tag.getSubTags();
            TypeDescriptor descriptor = this.doFindIn(subTags, name, namespace, pair, rootTag);
            if (descriptor != null) {
                return descriptor;
            }
            XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getRedefinedElementDescriptor(tag);
            if (nsDescriptor == null || (descriptor = this.doFindIn((redefinedRootTag = ((XmlDocument)nsDescriptor.getDeclaration()).getRootTag()).getSubTags(), name, namespace, pair, redefinedRootTag)) == null) continue;
            return descriptor;
        }
        return null;
    }

    private boolean isSameName(@NotNull String name, String namespace, String nameAttribute) {
        if (name == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(8);
        }
        return nameAttribute != null && (nameAttribute.equals(name) || name.contains(":") && nameAttribute.equals(name.substring(name.indexOf(":") + 1))) && (namespace == null || namespace.length() == 0 || namespace.equals(this.getDefaultNamespace()));
    }

    private XmlNSDescriptorImpl findNSDescriptor(XmlTag tag, XmlDocument document) {
        XmlNSDescriptor importedDescriptor;
        XmlNSDescriptorImpl nsDescriptor = IMPORT_TAG_NAME.equals(tag.getLocalName()) ? ((importedDescriptor = (XmlNSDescriptor)document.getMetaData()) instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)importedDescriptor : this) : this;
        return nsDescriptor;
    }

    private CachedValue<TypeDescriptor> createAndPutTypesCachedValueSimpleType(XmlTag tag, Pair<QNameKey, XmlTag> pair) {
        CachedValue<TypeDescriptor> value = CachedValuesManager.getManager(tag.getProject()).createCachedValue(() -> {
            SimpleTypeDescriptor simpleTypeDescriptor = new SimpleTypeDescriptor(tag);
            return new CachedValueProvider.Result<SimpleTypeDescriptor>(simpleTypeDescriptor, tag);
        }, false);
        this.myTypesMap.put(pair, value);
        return value;
    }

    private CachedValue<TypeDescriptor> createAndPutTypesCachedValue(XmlTag tag, Pair<QNameKey, XmlTag> pair) {
        CachedValue<TypeDescriptor> value = CachedValuesManager.getManager(tag.getProject()).createCachedValue(() -> {
            String name = tag.getAttributeValue("name");
            if (name != null && pair.first != null && ((QNameKey)pair.first).first != null && !name.equals(XmlUtil.findLocalNameByQualifiedName((String)((QNameKey)pair.first).first))) {
                this.myTypesMap.remove(pair);
                return new CachedValueProvider.Result<Object>(null, PsiModificationTracker.MODIFICATION_COUNT);
            }
            ComplexTypeDescriptor complexTypeDescriptor = new ComplexTypeDescriptor(this, tag);
            return new CachedValueProvider.Result<ComplexTypeDescriptor>(complexTypeDescriptor, tag);
        }, false);
        this.myTypesMap.put(pair, value);
        return value;
    }

    @Override
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(9);
        }
        PsiElement parent = tag.getParent();
        String namespace = tag.getNamespace();
        while (parent instanceof XmlTag && !namespace.equals(((XmlTag)parent).getNamespace())) {
            parent = parent.getContext();
        }
        if (parent instanceof XmlTag) {
            XmlTag parentTag = (XmlTag)parent;
            XmlElementDescriptor parentDescriptor = parentTag.getDescriptor();
            if (parentDescriptor != null) {
                XmlElementDescriptor elementDescriptor;
                XmlElementDescriptor elementDescriptorFromParent = parentDescriptor.getElementDescriptor(tag, parentTag);
                if (elementDescriptorFromParent == null) {
                    elementDescriptorFromParent = XmlNSDescriptorImpl.getDescriptorFromParent(tag, elementDescriptorFromParent);
                }
                if (elementDescriptorFromParent instanceof AnyXmlElementDescriptor && (elementDescriptor = this.getElementDescriptor(tag.getLocalName(), namespace)) != null) {
                    return elementDescriptor;
                }
                return elementDescriptorFromParent;
            }
            return null;
        }
        XmlElementDescriptor elementDescriptor = this.getElementDescriptor(tag.getLocalName(), tag.getNamespace());
        if (elementDescriptor == null) {
            elementDescriptor = XmlNSDescriptorImpl.getDescriptorFromParent(tag, elementDescriptor);
        }
        return elementDescriptor;
    }

    @Override
    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument doc) {
        class CollectElementsProcessor
        implements PsiElementProcessor<XmlTag> {
            final List<XmlElementDescriptor> result = new ArrayList<XmlElementDescriptor>();

            CollectElementsProcessor() {
            }

            @Override
            public boolean execute(@NotNull XmlTag element) {
                if (element == null) {
                    CollectElementsProcessor.$$$reportNull$$$0(0);
                }
                ContainerUtil.addIfNotNull(this.result, XmlNSDescriptorImpl.this.getElementDescriptor(element.getAttributeValue("name"), XmlNSDescriptorImpl.this.getDefaultNamespace()));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", XmlNSDescriptorImpl.ELEMENT_TAG_NAME, "com/intellij/xml/impl/schema/XmlNSDescriptorImpl$1CollectElementsProcessor", "execute"));
            }
        }
        CollectElementsProcessor processor = new CollectElementsProcessor(){
            {
            }

            @Override
            public boolean execute(@NotNull XmlTag element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!XmlElementDescriptorImpl.isAbstractDeclaration(element).booleanValue()) {
                    return super.execute(element);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", XmlNSDescriptorImpl.ELEMENT_TAG_NAME, "com/intellij/xml/impl/schema/XmlNSDescriptorImpl$1", "execute"));
            }
        };
        this.processTagsInNamespace(new String[]{ELEMENT_TAG_NAME}, processor);
        XmlElementDescriptor[] xmlElementDescriptorArray = processor.result.toArray(new XmlElementDescriptor[processor.result.size()]);
        if (xmlElementDescriptorArray == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(10);
        }
        return xmlElementDescriptorArray;
    }

    public XmlAttributeDescriptor[] getRootAttributeDescriptors(XmlTag context) {
        class CollectAttributesProcessor
        implements PsiElementProcessor<XmlTag> {
            final List<XmlAttributeDescriptor> result = new ArrayList<XmlAttributeDescriptor>();

            CollectAttributesProcessor() {
            }

            @Override
            public boolean execute(@NotNull XmlTag element) {
                if (element == null) {
                    CollectAttributesProcessor.$$$reportNull$$$0(0);
                }
                this.result.add(XmlNSDescriptorImpl.this.createAttributeDescriptor(element));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", XmlNSDescriptorImpl.ELEMENT_TAG_NAME, "com/intellij/xml/impl/schema/XmlNSDescriptorImpl$1CollectAttributesProcessor", "execute"));
            }
        }
        CollectAttributesProcessor processor = new CollectAttributesProcessor();
        this.processTagsInNamespace(new String[]{ATTRIBUTE_TAG_NAME}, processor);
        return processor.result.toArray(new XmlAttributeDescriptor[processor.result.size()]);
    }

    @Override
    @Nullable
    public XmlTag findGroup(String name) {
        return XmlNSDescriptorImpl.findSpecialTag(name, "group", this.myTag, this, null);
    }

    @Override
    @Nullable
    public XmlTag findAttributeGroup(String name) {
        return XmlNSDescriptorImpl.findSpecialTag(name, "attributeGroup", this.myTag, this, null);
    }

    public synchronized XmlElementDescriptor[] getSubstitutes(String localName, String namespace) {
        if (!this.initSubstitutes()) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        Collection<XmlTag> substitutions = this.mySubstitutions.get(localName);
        if (substitutions.isEmpty()) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        SmartList<XmlElementDescriptor> result = new SmartList<XmlElementDescriptor>();
        for (XmlTag tag : substitutions) {
            String substAttr = tag.getAttributeValue("substitutionGroup");
            if (substAttr == null || !this.checkElementNameEquivalence(localName, namespace, substAttr, tag)) continue;
            result.add(this.createElementDescriptor(tag));
        }
        return result.toArray(new XmlElementDescriptor[result.size()]);
    }

    private boolean initSubstitutes() {
        if (this.mySubstitutions == null && this.myTag != null) {
            XmlTag[] tags;
            this.mySubstitutions = new MultiMap();
            if (this.myTag == null) {
                return false;
            }
            for (XmlTag tag : tags = this.myTag.getSubTags()) {
                String substAttr;
                if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, ELEMENT_TAG_NAME) || (substAttr = tag.getAttributeValue("substitutionGroup")) == null) continue;
                String substLocalName = XmlUtil.findLocalNameByQualifiedName(substAttr);
                this.mySubstitutions.putValue(substLocalName, tag);
            }
        }
        return this.mySubstitutions != null;
    }

    @Override
    public PsiElement getDeclaration() {
        return this.myFile.getDocument();
    }

    @Override
    public String getName(PsiElement context) {
        return this.getName();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void init(PsiElement element) {
        this.myFile = (XmlFile)element.getContainingFile();
        if (element instanceof XmlTag) {
            this.myTag = (XmlTag)element;
        } else {
            XmlDocument document = this.myFile.getDocument();
            if (document != null) {
                this.myTag = document.getRootTag();
            }
        }
        if (this.myTag != null) {
            this.myTargetNamespace = this.myTag.getAttributeValue("targetNamespace");
        }
        THashSet dependenciesSet = new THashSet();
        Set<PsiFile> redefineProcessingSet = myRedefinedDescriptorsInProcessing.get();
        if (redefineProcessingSet != null) {
            dependenciesSet.addAll(redefineProcessingSet);
        }
        XmlNSDescriptorImpl.collectDependencies(this.myTag, this.myFile, (Set<PsiFile>)dependenciesSet);
        this.dependencies = ArrayUtil.toObjectArray(dependenciesSet);
    }

    @Override
    @NotNull
    public Object[] getDependences() {
        if (this.dependencies == null) {
            Object[] objectArray;
            if (this.myFile == null) {
                objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.myFile;
            }
            this.dependencies = objectArray;
        }
        if (this.dependencies == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(11);
        }
        return this.dependencies;
    }

    @Override
    public void validate(@NotNull XmlDocument context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(12);
        }
        if (host == null) {
            XmlNSDescriptorImpl.$$$reportNull$$$0(13);
        }
        ExternalDocumentValidator.doValidation(context, host);
    }

    public XmlTag getTag() {
        return this.myTag;
    }

    public synchronized boolean hasSubstitutions() {
        this.initSubstitutes();
        return this.mySubstitutions != null && this.mySubstitutions.size() > 0;
    }

    public boolean isValid() {
        return this.myFile != null && this.getDeclaration().isValid();
    }

    static {
        STD_TYPES.add("string");
        STD_TYPES.add("normalizedString");
        STD_TYPES.add("token");
        STD_TYPES.add("byte");
        STD_TYPES.add("unsignedByte");
        STD_TYPES.add("base64Binary");
        STD_TYPES.add("hexBinary");
        STD_TYPES.add("integer");
        STD_TYPES.add("positiveInteger");
        STD_TYPES.add("negativeInteger");
        STD_TYPES.add("nonNegativeInteger");
        STD_TYPES.add("nonPositiveInteger");
        STD_TYPES.add("int");
        STD_TYPES.add("unsignedInt");
        STD_TYPES.add("long");
        STD_TYPES.add("unsignedLong");
        STD_TYPES.add("short");
        STD_TYPES.add("unsignedShort");
        STD_TYPES.add("decimal");
        STD_TYPES.add("float");
        STD_TYPES.add("double");
        STD_TYPES.add("boolean");
        STD_TYPES.add("time");
        STD_TYPES.add("dateTime");
        STD_TYPES.add("duration");
        STD_TYPES.add("date");
        STD_TYPES.add("gMonth");
        STD_TYPES.add("gYear");
        STD_TYPES.add("gYearMonth");
        STD_TYPES.add("gDay");
        STD_TYPES.add("gMonthDay");
        STD_TYPES.add("Name");
        STD_TYPES.add("QName");
        STD_TYPES.add("NCName");
        STD_TYPES.add("anyURI");
        STD_TYPES.add("language");
        STD_TYPES.add("ID");
        STD_TYPES.add("IDREF");
        STD_TYPES.add("IDREFS");
        STD_TYPES.add("ENTITY");
        STD_TYPES.add("ENTITIES");
        STD_TYPES.add("NOTATION");
        STD_TYPES.add("NMTOKEN");
        STD_TYPES.add("NMTOKENS");
        STD_TYPES.add("anySimpleType");
        UNDECLARED_STD_TYPES.add("anySimpleType");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/impl/schema/XmlNSDescriptorImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/impl/schema/XmlNSDescriptorImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNSDescriptorToSearchIn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElementsDescriptors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkSchemaNamespace";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processTagsInNamespaceInner";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "equalsToSchemaName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSameName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementDescriptor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class QNameKey
    extends Pair<String, String> {
        QNameKey(String name, String namespace) {
            super(name, namespace);
        }
    }
}

