/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.xml.util.IncludedXmlTag;
import com.intellij.xml.util.XmlIncludeHandler;
import com.intellij.xml.util.XmlUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InclusionProvider
implements CachedValueProvider<PsiElement[]> {
    private final XmlTag myXincludeTag;

    public InclusionProvider(XmlTag xincludeTag) {
        this.myXincludeTag = xincludeTag;
    }

    @NotNull
    public static PsiElement[] getIncludedTags(XmlTag xincludeTag) {
        if (XmlUtil.isStubBuilding()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                InclusionProvider.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = CachedValuesManager.getCachedValue(xincludeTag, new InclusionProvider(xincludeTag));
        if (psiElementArray == null) {
            InclusionProvider.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @Override
    public CachedValueProvider.Result<PsiElement[]> compute() {
        PsiElement[] result = RecursionManager.doPreventingRecursion(this.myXincludeTag, true, () -> InclusionProvider.computeInclusion(this.myXincludeTag));
        return CachedValueProvider.Result.create(result == null ? PsiElement.EMPTY_ARRAY : result, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
    }

    private static XmlTag[] extractXpointer(@NotNull XmlTag rootTag, @Nullable String xpointer) {
        String pointer;
        Matcher matcher;
        if (rootTag == null) {
            InclusionProvider.$$$reportNull$$$0(2);
        }
        if (xpointer != null && (matcher = JDOMXIncluder.XPOINTER_PATTERN.matcher(xpointer)).matches() && (matcher = JDOMXIncluder.CHILDREN_PATTERN.matcher(pointer = matcher.group(1))).matches() && matcher.group(1).equals(rootTag.getName())) {
            return rootTag.getSubTags();
        }
        return new XmlTag[]{rootTag};
    }

    @Nullable
    private static PsiElement[] computeInclusion(XmlTag xincludeTag) {
        XmlTag rootTag;
        XmlFile included = XmlIncludeHandler.resolveXIncludeFile(xincludeTag);
        XmlDocument document = included != null ? included.getDocument() : null;
        XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
        if (rootTag != null) {
            String xpointer = xincludeTag.getAttributeValue("xpointer", "http://www.w3.org/2001/XInclude");
            XmlTag[] includeTag = InclusionProvider.extractXpointer(rootTag, xpointer);
            PsiElement[] result = new PsiElement[includeTag.length];
            for (int i = 0; i < includeTag.length; ++i) {
                result[i] = new IncludedXmlTag(includeTag[i], (PsiElement)xincludeTag.getParentTag());
            }
            return result;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/InclusionProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/InclusionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractXpointer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

