/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.UriUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.impl.source.xml.XmlEntityRefImpl;
import com.intellij.psi.scope.processor.FilterElementProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlFileNSInfoProvider;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.XmlCharsetDetector;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlPsiUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlUtil {
    @NonNls
    public static final String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    @NonNls
    public static final String XML_SCHEMA_URI2 = "http://www.w3.org/1999/XMLSchema";
    @NonNls
    public static final String XML_SCHEMA_URI3 = "http://www.w3.org/2000/10/XMLSchema";
    public static final String[] SCHEMA_URIS = new String[]{"http://www.w3.org/2001/XMLSchema", "http://www.w3.org/1999/XMLSchema", "http://www.w3.org/2000/10/XMLSchema"};
    @NonNls
    public static final String XML_SCHEMA_INSTANCE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    @NonNls
    public static final String XML_SCHEMA_VERSIONING_URI = "http://www.w3.org/2007/XMLSchema-versioning";
    @NonNls
    public static final String XSLT_URI = "http://www.w3.org/1999/XSL/Transform";
    @NonNls
    public static final String XINCLUDE_URI = "http://www.w3.org/2001/XInclude";
    @NonNls
    public static final String ANT_URI = "http://ant.apache.org/schema.xsd";
    @NonNls
    public static final String XHTML_URI = "http://www.w3.org/1999/xhtml";
    @NonNls
    public static final String HTML_URI = "http://www.w3.org/1999/html";
    @NonNls
    public static final String EMPTY_URI = "";
    @NonNls
    public static final Key<String> TEST_PATH = Key.create("TEST PATH");
    @NonNls
    public static final String TAGLIB_1_2_URI = "http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd";
    @NonNls
    public static final String JSP_URI = "http://java.sun.com/JSP/Page";
    @NonNls
    public static final String JSTL_CORE_URI = "http://java.sun.com/jsp/jstl/core";
    @NonNls
    public static final String JSTL_CORE_URI2 = "http://java.sun.com/jstl/core";
    @NonNls
    public static final String JSTL_CORE_URI3 = "http://java.sun.com/jstl/core_rt";
    @NonNls
    public static final String JSTL_CORE_URI_JAVAEE_7 = "http://xmlns.jcp.org/jsp/jstl/core";
    @NonNls
    public static final String[] JSTL_CORE_URIS = new String[]{"http://java.sun.com/jsp/jstl/core", "http://java.sun.com/jstl/core", "http://java.sun.com/jstl/core_rt", "http://xmlns.jcp.org/jsp/jstl/core"};
    @NonNls
    public static final String JSF_HTML_URI = "http://java.sun.com/jsf/html";
    @NonNls
    public static final String JSF_HTML_URI_JAVAEE_7 = "http://xmlns.jcp.org/jsf/html";
    @NonNls
    public static final String[] JSF_HTML_URIS = new String[]{"http://java.sun.com/jsf/html", "http://xmlns.jcp.org/jsf/html"};
    @NonNls
    public static final String JSF_CORE_URI = "http://java.sun.com/jsf/core";
    @NonNls
    public static final String JSF_CORE_URI_JAVAEE_7 = "http://xmlns.jcp.org/jsf/core";
    @NonNls
    public static final String[] JSF_CORE_URIS = new String[]{"http://java.sun.com/jsf/core", "http://xmlns.jcp.org/jsf/core"};
    @NonNls
    public static final String JSF_PASS_THROUGH_ATTR_URI_JAVAEE7 = "http://xmlns.jcp.org/jsf";
    @NonNls
    public static final String JSF_PASSTHROUGH_URI = "http://xmlns.jcp.org/jsf/passthrough";
    @NonNls
    public static final String JSTL_FORMAT_URI = "http://java.sun.com/jsp/jstl/fmt";
    @NonNls
    public static final String JSTL_FORMAT_URI2 = "http://java.sun.com/jstl/fmt";
    @NonNls
    public static final String SPRING_URI = "http://www.springframework.org/tags";
    @NonNls
    public static final String SPRING_FORMS_URI = "http://www.springframework.org/tags/form";
    @NonNls
    public static final String STRUTS_BEAN_URI = "http://struts.apache.org/tags-bean";
    @NonNls
    public static final String STRUTS_BEAN_URI2 = "http://jakarta.apache.org/struts/tags-bean";
    @NonNls
    public static final String APACHE_I18N_URI = "http://jakarta.apache.org/taglibs/i18n-1.0";
    @NonNls
    public static final String STRUTS_LOGIC_URI = "http://struts.apache.org/tags-logic";
    @NonNls
    public static final String STRUTS_HTML_URI = "http://struts.apache.org/tags-html";
    @NonNls
    public static final String STRUTS_HTML_URI2 = "http://jakarta.apache.org/struts/tags-html";
    @NonNls
    public static final String APACHE_TRINIDAD_URI = "http://myfaces.apache.org/trinidad";
    @NonNls
    public static final String APACHE_TRINIDAD_HTML_URI = "http://myfaces.apache.org/trinidad/html";
    @NonNls
    public static final String XSD_SIMPLE_CONTENT_TAG = "simpleContent";
    @NonNls
    public static final String NO_NAMESPACE_SCHEMA_LOCATION_ATT = "noNamespaceSchemaLocation";
    @NonNls
    public static final String SCHEMA_LOCATION_ATT = "schemaLocation";
    @NonNls
    public static final String[] WEB_XML_URIS = new String[]{"http://java.sun.com/xml/ns/j2ee", "http://java.sun.com/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee", "http://java.sun.com/dtd/web-app_2_3.dtd", "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd"};
    @NonNls
    public static final String FACELETS_URI = "http://java.sun.com/jsf/facelets";
    @NonNls
    public static final String FACELETS_URI_JAVAEE_7 = "http://xmlns.jcp.org/jsf/facelets";
    @NonNls
    public static final String[] FACELETS_URIS = new String[]{"http://java.sun.com/jsf/facelets", "http://xmlns.jcp.org/jsf/facelets"};
    @NonNls
    public static final String JSTL_FUNCTIONS_URI = "http://java.sun.com/jsp/jstl/functions";
    @NonNls
    public static final String JSTL_FUNCTIONS_URI2 = "http://java.sun.com/jstl/functions";
    @NonNls
    public static final String JSTL_FUNCTIONS_JAVAEE_7 = "http://xmlns.jcp.org/jsp/jstl/functions";
    @NonNls
    public static final String[] JSTL_FUNCTIONS_URIS = new String[]{"http://java.sun.com/jsp/jstl/functions", "http://java.sun.com/jstl/functions"};
    @NonNls
    public static final String JSTL_FN_FACELET_URI = "com.sun.facelets.tag.jstl.fn.JstlFnLibrary";
    @NonNls
    public static final String JSTL_CORE_FACELET_URI = "com.sun.facelets.tag.jstl.core.JstlCoreLibrary";
    @NonNls
    public static final String TARGET_NAMESPACE_ATTR_NAME = "targetNamespace";
    @NonNls
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final List<String> ourSchemaUrisList = Arrays.asList(SCHEMA_URIS);
    public static final Key<Boolean> ANT_FILE_SIGN = new Key("FORCED ANT FILE");
    @NonNls
    public static final String TAG_DIR_NS_PREFIX = "urn:jsptagdir:";
    @NonNls
    public static final String VALUE_ATTR_NAME = "value";
    @NonNls
    public static final String ENUMERATION_TAG_NAME = "enumeration";
    @NonNls
    public static final String HTML4_LOOSE_URI = "http://www.w3.org/TR/html4/loose.dtd";
    @NonNls
    public static final String WSDL_SCHEMA_URI = "http://schemas.xmlsoap.org/wsdl/";
    public static final String XHTML4_SCHEMA_LOCATION;
    public static final ThreadLocal<Boolean> BUILDING_DOM_STUBS;
    private static final Logger LOG;
    @NonNls
    private static final String JSTL_FORMAT_URI3 = "http://java.sun.com/jstl/fmt_rt";
    @NonNls
    public static final String[] JSTL_FORMAT_URIS;
    @NonNls
    private static final String FILE = "file:";
    @NonNls
    private static final String CLASSPATH = "classpath:/";
    @NonNls
    private static final String URN = "urn:";
    private static final Set<String> doNotVisitTags;

    private XmlUtil() {
    }

    @NotNull
    public static String getSchemaLocation(XmlTag tag, String namespace) {
        while (tag != null) {
            String schemaLocation = tag.getAttributeValue(SCHEMA_LOCATION_ATT, XML_SCHEMA_INSTANCE_URI);
            if (schemaLocation != null) {
                StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
                int i = 0;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (i % 2 == 0 && namespace.equals(token) && tokenizer.hasMoreTokens()) {
                        String string = tokenizer.nextToken();
                        if (string == null) {
                            XmlUtil.$$$reportNull$$$0(0);
                        }
                        return string;
                    }
                    ++i;
                }
            }
            tag = tag.getParentTag();
        }
        String string = namespace;
        if (string == null) {
            XmlUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String findNamespacePrefixByURI(XmlFile file, @NotNull @NonNls String uri) {
        XmlTag tag;
        if (uri == null) {
            XmlUtil.$$$reportNull$$$0(2);
        }
        if ((tag = file.getRootTag()) == null) {
            return null;
        }
        for (XmlAttribute attribute : tag.getAttributes()) {
            if (attribute.getName().startsWith("xmlns:") && uri.equals(attribute.getValue())) {
                return attribute.getName().substring("xmlns:".length());
            }
            if (!"xmlns".equals(attribute.getName()) || !uri.equals(attribute.getValue())) continue;
            return EMPTY_URI;
        }
        return null;
    }

    public static String[] findNamespacesByURI(XmlFile file, String uri) {
        if (file == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        XmlDocument document = file.getDocument();
        if (document == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        XmlTag tag = document.getRootTag();
        if (tag == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        XmlAttribute[] attributes = tag.getAttributes();
        ArrayList<String> result = new ArrayList<String>();
        for (XmlAttribute attribute : attributes) {
            if (attribute.getName().startsWith("xmlns:") && attribute.getValue().equals(uri)) {
                result.add(attribute.getName().substring("xmlns:".length()));
            }
            if (!"xmlns".equals(attribute.getName()) || !attribute.getValue().equals(uri)) continue;
            result.add(EMPTY_URI);
        }
        return ArrayUtil.toStringArray(result);
    }

    @Nullable
    public static String getXsiNamespace(XmlFile file) {
        return XmlUtil.findNamespacePrefixByURI(file, XML_SCHEMA_INSTANCE_URI);
    }

    @Nullable
    public static XmlFile findNamespace(@NotNull PsiFile base, @NotNull String nsLocation) {
        String location;
        if (base == null) {
            XmlUtil.$$$reportNull$$$0(3);
        }
        if (nsLocation == null) {
            XmlUtil.$$$reportNull$$$0(4);
        }
        if (!(location = ExternalResourceManager.getInstance().getResourceLocation(nsLocation, base.getProject())).equals(nsLocation)) {
            return XmlUtil.findXmlFile(base, location);
        }
        XmlFile xmlFile = XmlSchemaProvider.findSchema(location, base);
        return xmlFile == null ? XmlUtil.findXmlFile(base, location) : xmlFile;
    }

    @Nullable
    public static XmlFile findNamespaceByLocation(@NotNull PsiFile base, @NotNull String nsLocation) {
        if (base == null) {
            XmlUtil.$$$reportNull$$$0(5);
        }
        if (nsLocation == null) {
            XmlUtil.$$$reportNull$$$0(6);
        }
        String location = ExternalResourceManager.getInstance().getResourceLocation(nsLocation, base.getProject());
        return XmlUtil.findXmlFile(base, location);
    }

    public static Collection<XmlFile> findNSFilesByURI(String namespace, Project project, Module module) {
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = XmlNamespaceIndex.getResourcesByNamespace(namespace, project, module);
        PsiManager psiManager = PsiManager.getInstance(project);
        return ContainerUtil.mapNotNull(resources, resource -> {
            PsiFile file = psiManager.findFile(resource.getFile());
            return file instanceof XmlFile ? (XmlFile)file : null;
        });
    }

    @Nullable
    public static XmlFile findXmlFile(PsiFile base, @NotNull String uri) {
        String data;
        if (uri == null) {
            XmlUtil.$$$reportNull$$$0(7);
        }
        PsiFile result = null;
        if (ApplicationManager.getApplication().isUnitTestMode() && (data = base.getOriginalFile().getUserData(TEST_PATH)) != null) {
            String filePath = data + "/" + uri;
            VirtualFile path = StandardFileSystems.local().findFileByPath(filePath.replace(File.separatorChar, '/'));
            if (path != null) {
                result = base.getManager().findFile(path);
            }
        }
        if (result == null) {
            result = XmlUtil.findRelativeFile(uri, base);
        }
        if (result instanceof XmlFile) {
            return (XmlFile)result;
        }
        return null;
    }

    @Nullable
    public static XmlToken getTokenOfType(PsiElement element, IElementType type) {
        PsiElement[] children;
        if (element == null) {
            return null;
        }
        for (PsiElement child : children = element.getChildren()) {
            XmlToken token;
            if (!(child instanceof XmlToken) || (token = (XmlToken)child).getTokenType() != type) continue;
            return token;
        }
        return null;
    }

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag) {
        return XmlPsiUtil.processXmlElements(element, processor, deepFlag);
    }

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag, boolean wideFlag) {
        return XmlPsiUtil.processXmlElements(element, processor, deepFlag, wideFlag);
    }

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag, boolean wideFlag, PsiFile baseFile) {
        return XmlPsiUtil.processXmlElements(element, processor, deepFlag, wideFlag, baseFile);
    }

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag, boolean wideFlag, PsiFile baseFile, boolean processIncludes) {
        return XmlPsiUtil.processXmlElements(element, processor, deepFlag, wideFlag, baseFile, processIncludes);
    }

    public static boolean processXmlElementChildren(XmlElement element, PsiElementProcessor processor, boolean deepFlag) {
        return XmlPsiUtil.processXmlElementChildren(element, processor, deepFlag);
    }

    public static boolean tagFromTemplateFramework(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlUtil.$$$reportNull$$$0(8);
        }
        String ns = tag.getNamespace();
        return XmlUtil.nsFromTemplateFramework(ns);
    }

    public static boolean nsFromTemplateFramework(String ns) {
        return XSLT_URI.equals(ns) || XINCLUDE_URI.equals(ns);
    }

    public static char getCharFromEntityRef(@NonNls @NotNull String text2) {
        if (text2 == null) {
            XmlUtil.$$$reportNull$$$0(9);
        }
        try {
            if (text2.charAt(1) != '#') {
                text2 = text2.substring(1, text2.length() - 1);
                return XmlTagUtil.getCharacterByEntityName(text2).charValue();
            }
            text2 = text2.substring(2, text2.length() - 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Cannot parse ref: '" + text2 + "'", e);
        }
        try {
            int code;
            if (StringUtil.startsWithChar(text2, 'x')) {
                text2 = text2.substring(1);
                code = Integer.parseInt(text2, 16);
            } else {
                code = Integer.parseInt(text2);
            }
            return (char)code;
        }
        catch (NumberFormatException e) {
            return '\u0000';
        }
    }

    public static boolean attributeFromTemplateFramework(@NonNls String name, XmlTag tag) {
        return "jsfc".equals(name) && XmlUtil.isJsfHtmlScheme(tag);
    }

    @Nullable
    public static String getTargetSchemaNsFromTag(@Nullable XmlTag xmlTag) {
        if (xmlTag == null) {
            return null;
        }
        String targetNamespace = xmlTag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME, XML_SCHEMA_URI);
        if (targetNamespace == null) {
            targetNamespace = xmlTag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME, XML_SCHEMA_URI2);
        }
        if (targetNamespace == null) {
            targetNamespace = xmlTag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME, XML_SCHEMA_URI3);
        }
        return targetNamespace;
    }

    @Nullable
    public static XmlTag getSchemaSimpleContent(@NotNull XmlTag tag) {
        TypeDescriptor type;
        XmlElementDescriptor descriptor;
        if (tag == null) {
            XmlUtil.$$$reportNull$$$0(10);
        }
        if ((descriptor = tag.getDescriptor()) instanceof XmlElementDescriptorImpl && (type = ((XmlElementDescriptorImpl)descriptor).getType(tag)) instanceof ComplexTypeDescriptor) {
            final XmlTag[] simpleContent = new XmlTag[1];
            XmlUtil.processXmlElements(((ComplexTypeDescriptor)type).getDeclaration(), new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (element instanceof XmlTag) {
                        XmlTag tag = (XmlTag)element;
                        String s = ((XmlTag)element).getLocalName();
                        if ((s.equals(XmlUtil.XSD_SIMPLE_CONTENT_TAG) || s.equals("restriction") && "string".equals(XmlUtil.findLocalNameByQualifiedName(tag.getAttributeValue("base")))) && tag.getNamespace().equals(XmlUtil.XML_SCHEMA_URI)) {
                            simpleContent[0] = tag;
                            return false;
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/XmlUtil$2", "execute"));
                }
            }, true);
            return simpleContent[0];
        }
        return null;
    }

    public static <T extends PsiElement> void doDuplicationCheckForElements(T[] elements, Map<String, T> presentNames, DuplicationInfoProvider<T> provider, Validator.ValidationHost host) {
        for (T t : elements) {
            String name = provider.getName((PsiElement)t);
            if (name == null) continue;
            String nameKey = provider.getNameKey((PsiElement)t, name);
            if (presentNames.containsKey(nameKey)) {
                PsiElement psiElement = (PsiElement)presentNames.get(nameKey);
                String message = XmlErrorMessages.message("duplicate.declaration", nameKey);
                if (psiElement != null) {
                    presentNames.put(nameKey, null);
                    host.addMessage(provider.getNodeForMessage(psiElement), message, Validator.ValidationHost.ErrorType.ERROR);
                }
                host.addMessage(provider.getNodeForMessage((PsiElement)t), message, Validator.ValidationHost.ErrorType.ERROR);
                continue;
            }
            presentNames.put(nameKey, t);
        }
    }

    public static String getEntityValue(XmlEntityRef entityRef) {
        String value;
        XmlAttributeValue valueElement;
        XmlEntityDecl decl = entityRef.resolve(entityRef.getContainingFile());
        if (decl != null && (valueElement = decl.getValueElement()) != null && (value = valueElement.getValue()) != null) {
            return value;
        }
        return entityRef.getText();
    }

    public static boolean isAntFile(PsiFile file) {
        XmlTag tag;
        XmlFile xmlFile;
        XmlDocument document;
        if (file instanceof XmlFile && (document = (xmlFile = (XmlFile)file).getDocument()) != null && (tag = document.getRootTag()) != null && "project".equals(tag.getName()) && tag.getContext() instanceof XmlDocument) {
            if (tag.getAttributeValue("default") != null) {
                return true;
            }
            VirtualFile vFile = xmlFile.getOriginalFile().getVirtualFile();
            if (vFile != null && vFile.getUserData(ANT_FILE_SIGN) != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isJsfHtmlScheme(XmlTag tag) {
        for (String jsfHtmlUri : JSF_HTML_URIS) {
            if (tag.getNSDescriptor(jsfHtmlUri, true) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiFile findRelativeFile(String uri, PsiElement base) {
        if (base instanceof PsiFile) {
            PsiFile baseFile = (PsiFile)base;
            VirtualFile file = UriUtil.findRelative(uri, baseFile.getOriginalFile());
            if (file == null) {
                return null;
            }
            return base.getManager().findFile(file);
        }
        if (base instanceof PsiDirectory) {
            PsiDirectory baseDir = (PsiDirectory)base;
            VirtualFile file = UriUtil.findRelative(uri, baseDir);
            if (file == null) {
                return null;
            }
            return base.getManager().findFile(file);
        }
        return null;
    }

    @Nullable
    public static String getCommentText(XmlComment comment) {
        XmlToken token;
        PsiElement nextSibling;
        PsiElement firstChild = comment.getFirstChild();
        if (firstChild != null && (nextSibling = firstChild.getNextSibling()) instanceof XmlToken && (token = (XmlToken)nextSibling).getTokenType() == XmlTokenType.XML_COMMENT_CHARACTERS) {
            return token.getText();
        }
        return null;
    }

    @Nullable
    public static PsiElement findNamespaceDeclaration(XmlElement xmlElement, String nsName) {
        while (!(xmlElement instanceof XmlTag) && xmlElement != null) {
            PsiElement parent = xmlElement.getParent();
            if (!(parent instanceof XmlElement)) {
                return null;
            }
            xmlElement = (XmlElement)parent;
        }
        if (xmlElement != null) {
            for (XmlTag tag = (XmlTag)xmlElement; tag != null; tag = tag.getParentTag()) {
                for (XmlAttribute attribute : tag.getAttributes()) {
                    if (!attribute.isNamespaceDeclaration() || !attribute.getLocalName().equals(nsName)) continue;
                    return attribute;
                }
            }
        }
        return null;
    }

    public static void reformatTagStart(XmlTag tag) {
        ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        if (child == null) {
            CodeStyleManager.getInstance(tag.getProject()).reformat(tag);
        } else {
            CodeStyleManager.getInstance(tag.getProject()).reformatRange(tag, tag.getTextRange().getStartOffset(), child.getTextRange().getEndOffset());
        }
    }

    @Nullable
    public static XmlElementDescriptor getDescriptorFromContext(@NotNull XmlTag tag) {
        XmlTag parentTag;
        XmlElementDescriptor parentDescriptor;
        PsiElement parent;
        if (tag == null) {
            XmlUtil.$$$reportNull$$$0(11);
        }
        if ((parent = tag.getParent()) instanceof XmlTag && (parentDescriptor = (parentTag = (XmlTag)parent).getDescriptor()) != null) {
            return XmlExtension.getExtension(tag.getContainingFile()).getElementDescriptor(tag, parentTag, parentDescriptor);
        }
        return null;
    }

    public static void expandTag(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlUtil.$$$reportNull$$$0(12);
        }
        XmlTag newTag = XmlElementFactory.getInstance(tag.getProject()).createTagFromText('<' + tag.getName() + "></" + tag.getName() + '>');
        ASTNode node = tag.getNode();
        if (!(node instanceof CompositeElement)) {
            return;
        }
        CompositeElement compositeElement = (CompositeElement)node;
        LeafElement emptyTagEnd = (LeafElement)XmlChildRole.EMPTY_TAG_END_FINDER.findChild(compositeElement);
        if (emptyTagEnd == null) {
            return;
        }
        compositeElement.removeChild(emptyTagEnd);
        PsiElement[] children = newTag.getChildren();
        compositeElement.addChildren(children[2].getNode(), null, null);
    }

    public static String getDefaultXhtmlNamespace(Project project) {
        String doctype = ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(project);
        return Html5SchemaProvider.getHtml5SchemaLocation().equals(doctype) ? Html5SchemaProvider.getXhtml5SchemaLocation() : doctype;
    }

    public static CharSequence getLocalName(CharSequence tagName) {
        int pos = StringUtil.indexOf(tagName, ':');
        if (pos == -1) {
            return tagName;
        }
        return tagName.subSequence(pos + 1, tagName.length());
    }

    public static boolean isStubBuilding() {
        return BUILDING_DOM_STUBS.get();
    }

    public static XmlTag addChildTag(XmlTag parent, XmlTag child) throws IncorrectOperationException {
        return XmlUtil.addChildTag(parent, child, -1);
    }

    public static XmlTag addChildTag(XmlTag parent, XmlTag child, int index) throws IncorrectOperationException {
        if (parent.getSubTags().length == 0 && parent.getText().endsWith("/>")) {
            XmlElementFactory factory = XmlElementFactory.getInstance(parent.getProject());
            String name = parent.getName();
            String text2 = parent.getText();
            XmlTag tag = factory.createTagFromText(text2.substring(0, text2.length() - 2) + "></" + name + ">");
            parent = (XmlTag)parent.replace(tag);
        }
        XmlElementDescriptor parentDescriptor = parent.getDescriptor();
        XmlTag[] subTags = parent.getSubTags();
        if (parentDescriptor == null || subTags.length == 0) {
            return (XmlTag)parent.add(child);
        }
        int subTagNum = -1;
        for (XmlElementDescriptor childElementDescriptor : parentDescriptor.getElementsDescriptors(parent)) {
            String childElementName = childElementDescriptor.getName();
            int prevSubTagNum = subTagNum;
            while (subTagNum < subTags.length - 1 && subTags[subTagNum + 1].getName().equals(childElementName)) {
                ++subTagNum;
            }
            if (!childElementName.equals(child.getLocalName())) continue;
            subTagNum = index == -1 || index > subTagNum - prevSubTagNum ? subTagNum : prevSubTagNum + index;
            return (XmlTag)(subTagNum == -1 ? parent.addBefore(child, subTags[0]) : parent.addAfter(child, subTags[subTagNum]));
        }
        return (XmlTag)parent.add(child);
    }

    @Deprecated
    @Nullable
    public static String getAttributeValue(XmlTag tag, String name) {
        for (XmlAttribute attribute : tag.getAttributes()) {
            if (!name.equals(attribute.getName())) continue;
            return attribute.getValue();
        }
        return null;
    }

    @Nullable
    public static XmlTag find(String subTag, String withValue, String forTag, XmlTag insideRoot) {
        XmlTag[] forTags;
        for (XmlTag tag : forTags = insideRoot.findSubTags(forTag)) {
            XmlTag[] allTags;
            for (XmlTag curTag : allTags = tag.findSubTags(subTag)) {
                if (!curTag.getName().equals(subTag) || !curTag.getValue().getTrimmedText().equalsIgnoreCase(withValue)) continue;
                return tag;
            }
        }
        return null;
    }

    @Nullable
    @NonNls
    public static String[][] getDefaultNamespaces(XmlDocument document) {
        Language language;
        String namespace;
        XmlFile file = XmlUtil.getContainingFile(document);
        XmlTag tag = document.getRootTag();
        if (tag == null) {
            return null;
        }
        XmlFileNSInfoProvider[] nsProviders = Extensions.getExtensions(XmlFileNSInfoProvider.EP_NAME);
        if (file != null) {
            block2: for (XmlFileNSInfoProvider nsProvider : nsProviders) {
                String[][] pairs = nsProvider.getDefaultNamespaces(file);
                if (pairs == null || pairs.length <= 0) continue;
                for (String[] nsMapping : pairs) {
                    if (nsMapping != null && nsMapping.length == 2 && nsMapping[0] != null && nsMapping[1] != null) continue;
                    LOG.debug("NSInfoProvider " + nsProvider + " gave wrong info about " + file.getVirtualFile());
                    continue block2;
                }
                return pairs;
            }
        }
        if ((namespace = XmlUtil.getDtdUri(document)) != null) {
            boolean overrideNamespaceFromDocType = false;
            if (file != null) {
                for (XmlFileNSInfoProvider provider : nsProviders) {
                    try {
                        if (!provider.overrideNamespaceFromDocType(file)) continue;
                        overrideNamespaceFromDocType = true;
                        break;
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        // empty catch block
                    }
                }
            }
            if (!overrideNamespaceFromDocType) {
                return new String[][]{{EMPTY_URI, namespace}};
            }
        }
        if ("taglib".equals(tag.getName())) {
            return new String[][]{{EMPTY_URI, TAGLIB_1_2_URI}};
        }
        if (file != null && ((language = file.getLanguage()).isKindOf(HTMLLanguage.INSTANCE) || language == XHTMLLanguage.INSTANCE)) {
            return new String[][]{{EMPTY_URI, XHTML_URI}};
        }
        return null;
    }

    @Nullable
    public static String getDtdUri(XmlDocument document) {
        XmlProlog prolog = document.getProlog();
        if (prolog != null) {
            return XmlUtil.getDtdUri(prolog.getDoctype());
        }
        return null;
    }

    @Nullable
    public static String getDtdUri(XmlDoctype doctype) {
        if (doctype != null) {
            String docType = doctype.getDtdUri();
            if (docType == null) {
                String publicId = doctype.getPublicId();
                if (PsiTreeUtil.getParentOfType((PsiElement)doctype, XmlDocument.class) instanceof HtmlDocumentImpl && publicId != null && publicId.contains("-//W3C//DTD ")) {
                    return XmlUtil.guessDtdByPublicId(publicId);
                }
                if (HtmlUtil.isHtml5Doctype(doctype)) {
                    docType = doctype.getLanguage() instanceof HTMLLanguage ? Html5SchemaProvider.getHtml5SchemaLocation() : Html5SchemaProvider.getXhtml5SchemaLocation();
                }
            }
            return docType;
        }
        return null;
    }

    private static String guessDtdByPublicId(String id) {
        if (id.contains("XHTML")) {
            if (id.contains("1.1")) {
                if (id.contains("Basic")) {
                    return "http://www.w3.org/TR/xhtml-basic/xhtml-basic11.dtd";
                }
                return "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd";
            }
            if (id.contains("Strict")) {
                return "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
            }
            if (id.contains("Frameset")) {
                return "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd";
            }
            if (id.contains("Transitional")) {
                return "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
            }
        } else if (id.contains("HTML")) {
            if (id.contains("Strict")) {
                return "http://www.w3.org/TR/html4/strict.dtd";
            }
            if (id.contains("Frameset")) {
                return "http://www.w3.org/TR/html4/frameset.dtd";
            }
            return HTML4_LOOSE_URI;
        }
        return null;
    }

    private static void computeTag(XmlTag tag, final Map<String, List<String>> tagsMap, final Map<String, List<MyAttributeInfo>> attributesMap, final boolean processIncludes) {
        XmlAttribute[] attributes;
        if (tag == null) {
            return;
        }
        String tagName = tag.getName();
        List<MyAttributeInfo> list = attributesMap.get(tagName);
        if (list == null) {
            list = new ArrayList<MyAttributeInfo>();
            for (XmlAttribute attribute : attributes = tag.getAttributes()) {
                list.add(new MyAttributeInfo(attribute.getName()));
            }
        } else {
            attributes = (XmlAttribute[])tag.getAttributes().clone();
            ContainerUtil.sort(list);
            Arrays.sort(attributes, Comparator.comparing(XmlAttribute::getName));
            Iterator<MyAttributeInfo> iter = list.iterator();
            list = new ArrayList<MyAttributeInfo>();
            int index = 0;
            while (iter.hasNext()) {
                MyAttributeInfo info = iter.next();
                boolean requiredFlag = false;
                while (attributes.length > index) {
                    if (info.compareTo(attributes[index]) != 0) {
                        if (info.compareTo(attributes[index]) < 0) break;
                        if (attributes[index].getValue() != null) {
                            list.add(new MyAttributeInfo(attributes[index].getName(), false));
                        }
                        ++index;
                        continue;
                    }
                    requiredFlag = true;
                    ++index;
                    break;
                }
                info.myRequired &= requiredFlag;
                list.add(info);
            }
            while (attributes.length > index) {
                if (attributes[index].getValue() != null) {
                    list.add(new MyAttributeInfo(attributes[index++].getName(), false));
                    continue;
                }
                ++index;
            }
        }
        attributesMap.put(tagName, list);
        final List<Object> tags = tagsMap.get(tagName) != null ? tagsMap.get(tagName) : new ArrayList();
        tagsMap.put(tagName, tags);
        PsiFile file = tag.isValid() ? tag.getContainingFile() : null;
        XmlUtil.processXmlElements(tag, new FilterElementProcessor(XmlTagFilter.INSTANCE){

            @Override
            public void add(PsiElement element) {
                XmlTag tag = (XmlTag)element;
                if (!tags.contains(tag.getName())) {
                    tags.add(tag.getName());
                }
                XmlUtil.computeTag(tag, tagsMap, attributesMap, processIncludes);
            }
        }, false, false, file, processIncludes);
    }

    @Nullable
    public static XmlElementDescriptor findXmlDescriptorByType(XmlTag xmlTag) {
        return XmlUtil.findXmlDescriptorByType(xmlTag, null);
    }

    @Nullable
    public static XmlElementDescriptor findXmlDescriptorByType(XmlTag xmlTag, @Nullable XmlTag context) {
        String ns;
        String type = xmlTag.getAttributeValue("type", XML_SCHEMA_INSTANCE_URI);
        if (type == null && ourSchemaUrisList.indexOf(ns = xmlTag.getNamespace()) >= 0) {
            type = xmlTag.getAttributeValue("type", null);
        }
        XmlElementDescriptor elementDescriptor = null;
        if (type != null) {
            String namespaceByPrefix = XmlUtil.findNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(type), xmlTag);
            XmlNSDescriptor typeDecr = xmlTag.getNSDescriptor(namespaceByPrefix, true);
            if (typeDecr == null && namespaceByPrefix.isEmpty()) {
                XmlDocument document;
                PsiFile containingFile;
                if (context != null) {
                    typeDecr = context.getNSDescriptor(EMPTY_URI, true);
                }
                if (typeDecr == null && (containingFile = xmlTag.getContainingFile()) instanceof XmlFile && (document = ((XmlFile)containingFile).getDocument()) != null) {
                    typeDecr = (XmlNSDescriptor)document.getMetaData();
                }
            }
            if (typeDecr instanceof XmlNSDescriptorImpl) {
                XmlNSDescriptorImpl schemaDescriptor = (XmlNSDescriptorImpl)typeDecr;
                elementDescriptor = schemaDescriptor.getDescriptorByType(type, xmlTag);
            }
        }
        return elementDescriptor;
    }

    public static boolean collectEnumerationValues(XmlTag element, HashSet<String> variants) {
        return XmlUtil.processEnumerationValues(element, xmlTag -> {
            variants.add(xmlTag.getAttributeValue(VALUE_ATTR_NAME));
            return true;
        });
    }

    public static boolean processEnumerationValues(XmlTag element, Processor<XmlTag> tagProcessor) {
        boolean exhaustiveEnum = true;
        for (XmlTag tag : element.getSubTags()) {
            String localName = tag.getLocalName();
            if (localName.equals(ENUMERATION_TAG_NAME)) {
                String attributeValue = tag.getAttributeValue(VALUE_ATTR_NAME);
                if (attributeValue == null || tagProcessor.process(tag)) continue;
                return exhaustiveEnum;
            }
            if (localName.equals("union")) {
                exhaustiveEnum = false;
                XmlUtil.processEnumerationValues(tag, tagProcessor);
                continue;
            }
            if (doNotVisitTags.contains(localName)) continue;
            exhaustiveEnum &= XmlUtil.processEnumerationValues(tag, tagProcessor);
        }
        return exhaustiveEnum;
    }

    public static XmlTag createChildTag(XmlTag xmlTag, String localName, String namespace, @Nullable String bodyText, boolean enforceNamespacesDeep) {
        final String prefix = xmlTag.getPrefixByNamespace(namespace);
        String qname = prefix != null && !prefix.isEmpty() ? prefix + ":" + localName : localName;
        try {
            XmlTag retTag;
            String tagStart = qname + (!StringUtil.isEmpty(namespace) && xmlTag.getPrefixByNamespace(namespace) == null && (!StringUtil.isEmpty(xmlTag.getNamespacePrefix()) || !namespace.equals(xmlTag.getNamespace())) ? " xmlns=\"" + namespace + "\"" : EMPTY_URI);
            Language language = xmlTag.getLanguage();
            if (!(language instanceof HTMLLanguage)) {
                language = XMLLanguage.INSTANCE;
            }
            if (bodyText != null) {
                retTag = XmlElementFactory.getInstance(xmlTag.getProject()).createTagFromText("<" + tagStart + ">" + bodyText + "</" + qname + ">", language);
                if (enforceNamespacesDeep) {
                    retTag.acceptChildren(new XmlRecursiveElementVisitor(){

                        @Override
                        public void visitXmlTag(XmlTag tag) {
                            String namespacePrefix = tag.getNamespacePrefix();
                            if (namespacePrefix.isEmpty()) {
                                String qname = prefix != null && !prefix.isEmpty() ? prefix + ":" + tag.getLocalName() : tag.getLocalName();
                                try {
                                    tag.setName(qname);
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error(e);
                                }
                            }
                            super.visitXmlTag(tag);
                        }
                    });
                }
            } else {
                retTag = XmlElementFactory.getInstance(xmlTag.getProject()).createTagFromText("<" + tagStart + "/>", language);
            }
            return retTag;
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    public static Pair<XmlTagChild, XmlTagChild> findTagChildrenInRange(PsiFile file, int startOffset, int endOffset) {
        PsiElement elementAt;
        PsiElement elementAt2;
        PsiElement elementAtStart = file.findElementAt(startOffset);
        PsiElement elementAtEnd = file.findElementAt(endOffset - 1);
        if (elementAtStart instanceof PsiWhiteSpace) {
            startOffset = elementAtStart.getTextRange().getEndOffset();
            elementAtStart = file.findElementAt(startOffset);
        }
        if (elementAtEnd instanceof PsiWhiteSpace) {
            endOffset = elementAtEnd.getTextRange().getStartOffset();
            elementAtEnd = file.findElementAt(endOffset - 1);
        }
        if (elementAtStart == null || elementAtEnd == null) {
            return null;
        }
        XmlTagChild first = PsiTreeUtil.getParentOfType(elementAtStart, XmlTagChild.class);
        if (first == null) {
            return null;
        }
        if (!(first.getTextRange().getStartOffset() == startOffset || (elementAt2 = file.findElementAt(first.getTextRange().getStartOffset())) instanceof PsiWhiteSpace && elementAt2.getTextRange().getEndOffset() == startOffset)) {
            return null;
        }
        XmlTagChild last = first;
        while (last != null && last.getTextRange().getEndOffset() < endOffset) {
            last = PsiTreeUtil.getNextSiblingOfType(last, XmlTagChild.class);
        }
        if (last == null) {
            return null;
        }
        if (!(last.getTextRange().getEndOffset() == elementAtEnd.getTextRange().getEndOffset() || (elementAt = file.findElementAt(last.getTextRange().getEndOffset() - 1)) instanceof PsiWhiteSpace && elementAt.getTextRange().getStartOffset() == endOffset)) {
            return null;
        }
        return Pair.create(first, last);
    }

    public static boolean isSimpleValue(@NotNull String unquotedValue, PsiElement context) {
        if (unquotedValue == null) {
            XmlUtil.$$$reportNull$$$0(13);
        }
        for (int i = 0; i < unquotedValue.length(); ++i) {
            XmlFile file;
            char ch = unquotedValue.charAt(i);
            if (Character.isJavaIdentifierPart(ch) || ch == ':' || ch == '-' || (file = PsiTreeUtil.getParentOfType(context, XmlFile.class)) == null) continue;
            XmlTag tag = file.getRootTag();
            return tag != null && !XmlUtil.tagFromTemplateFramework(tag);
        }
        return true;
    }

    public static boolean toCode(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!XmlUtil.toCode(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean toCode(char ch) {
        return "<&>\u00a0".indexOf(ch) >= 0;
    }

    @Nullable
    public static PsiNamedElement findRealNamedElement(final @NotNull PsiNamedElement _element) {
        if (_element == null) {
            XmlUtil.$$$reportNull$$$0(14);
        }
        PsiElement currentElement = _element;
        final XmlEntityRef lastEntityRef = PsiTreeUtil.getParentOfType(currentElement, XmlEntityRef.class);
        while (!(currentElement instanceof XmlFile)) {
            PsiElement dependingElement = currentElement.getUserData(XmlElement.DEPENDING_ELEMENT);
            if (dependingElement == null) {
                dependingElement = currentElement.getContext();
            }
            currentElement = dependingElement;
            if (dependingElement != null) continue;
            break;
        }
        if (currentElement != null) {
            XmlEntityDecl cachedEntity;
            final String name = _element.getName();
            if (_element instanceof XmlEntityDecl && (cachedEntity = XmlEntityCache.getCachedEntity((PsiFile)currentElement, name)) != null) {
                return cachedEntity;
            }
            final PsiNamedElement[] result = new PsiNamedElement[1];
            XmlUtil.processXmlElements((XmlFile)currentElement, new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    String elementName;
                    if (element == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (element instanceof PsiNamedElement && ((elementName = ((PsiNamedElement)element).getName()).equals(name) && _element.getClass().isInstance(element) || lastEntityRef != null && element instanceof XmlEntityDecl && elementName.equals(lastEntityRef.getText().substring(1, lastEntityRef.getTextLength() - 1)))) {
                        result[0] = (PsiNamedElement)element;
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/XmlUtil$5", "execute"));
                }
            }, true);
            return result[0];
        }
        return null;
    }

    public static int getPrefixLength(@NotNull String s) {
        if (s == null) {
            XmlUtil.$$$reportNull$$$0(15);
        }
        if (s.startsWith(TAG_DIR_NS_PREFIX)) {
            return TAG_DIR_NS_PREFIX.length();
        }
        if (s.startsWith(FILE)) {
            return FILE.length();
        }
        if (s.startsWith(CLASSPATH)) {
            return CLASSPATH.length();
        }
        return 0;
    }

    public static boolean isUrlText(String s, Project project) {
        boolean surelyUrl;
        boolean bl = surelyUrl = HtmlUtil.hasHtmlPrefix(s) || s.startsWith(URN);
        if (surelyUrl) {
            return surelyUrl;
        }
        int protocolIndex = s.indexOf(":/");
        if (protocolIndex > 1 && !s.regionMatches(0, "classpath", 0, protocolIndex)) {
            return true;
        }
        return ExternalResourceManager.getInstance().getResourceLocation(s, project) != s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateDocumentDTD(XmlDocument doc, boolean full) {
        LinkedHashMap<String, List<String>> tags = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<MyAttributeInfo>> attributes = new LinkedHashMap<String, List<MyAttributeInfo>>();
        try {
            PsiElement element;
            XmlEntityRefImpl.setNoEntityExpandOutOfDocument(doc, true);
            XmlTag rootTag = doc.getRootTag();
            XmlUtil.computeTag(rootTag, tags, attributes, full);
            PsiElement psiElement = element = rootTag != null ? rootTag.getNextSibling() : null;
            while (element != null) {
                if (element instanceof XmlTag) {
                    XmlUtil.computeTag((XmlTag)element, tags, attributes, full);
                }
                element = element.getNextSibling();
            }
        }
        finally {
            XmlEntityRefImpl.setNoEntityExpandOutOfDocument(doc, false);
        }
        StringBuilder buffer = new StringBuilder();
        for (String tagName : tags.keySet()) {
            buffer.append(XmlUtil.generateElementDTD(tagName, (List)tags.get(tagName), (List)attributes.get(tagName)));
        }
        return buffer.toString();
    }

    public static String generateElementDTD(String name, List<String> tags, List<MyAttributeInfo> attributes) {
        if (name == null || EMPTY_URI.equals(name)) {
            return EMPTY_URI;
        }
        if (name.contains("IntellijIdeaRulezzz")) {
            return EMPTY_URI;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<!ELEMENT ").append(name).append(" ");
        if (tags.isEmpty()) {
            buffer.append("(#PCDATA)>\n");
        } else {
            buffer.append("(");
            Iterator<String> iter = tags.iterator();
            while (iter.hasNext()) {
                String tagName = iter.next();
                buffer.append(tagName);
                if (iter.hasNext()) {
                    buffer.append("|");
                    continue;
                }
                buffer.append(")*");
            }
            buffer.append(">\n");
        }
        if (!attributes.isEmpty()) {
            buffer.append("<!ATTLIST ").append(name);
            for (MyAttributeInfo info : attributes) {
                buffer.append("\n    ").append(XmlUtil.generateAttributeDTD(info));
            }
            buffer.append(">\n");
        }
        return buffer.toString();
    }

    private static String generateAttributeDTD(MyAttributeInfo info) {
        if (info.myName.contains("IntellijIdeaRulezzz")) {
            return EMPTY_URI;
        }
        return info.myName + " CDATA" + (info.myRequired ? " #REQUIRED" : " #IMPLIED");
    }

    @Nullable
    public static String trimLeadingSpacesInMultilineTagValue(@NonNls String tagValue) {
        return tagValue == null ? null : tagValue.replaceAll("\n\\s*", "\n");
    }

    public static String findNamespaceByPrefix(String prefix, XmlTag contextTag) {
        return contextTag.getNamespaceByPrefix(prefix);
    }

    @NotNull
    public static String findPrefixByQualifiedName(@NotNull String name) {
        int prefixEnd;
        if (name == null) {
            XmlUtil.$$$reportNull$$$0(16);
        }
        if ((prefixEnd = name.indexOf(58)) > 0) {
            String string = name.substring(0, prefixEnd);
            if (string == null) {
                XmlUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (EMPTY_URI == null) {
            XmlUtil.$$$reportNull$$$0(18);
        }
        return EMPTY_URI;
    }

    @Nullable
    public static String findLocalNameByQualifiedName(String name) {
        return name == null ? null : name.substring(name.indexOf(58) + 1);
    }

    public static XmlFile getContainingFile(PsiElement element) {
        while (!(element instanceof XmlFile) && element != null) {
            PsiElement context = element.getContext();
            if (context == null) {
                XmlExtension extension = XmlExtension.getExtensionByElement(element);
                if (extension == null) continue;
                element = extension.getContainingFile(element);
                continue;
            }
            if (element == context) {
                LOG.error("Context==element: " + element.getClass());
                return null;
            }
            element = context;
        }
        return (XmlFile)element;
    }

    @Nullable
    public static String getSubTagValue(XmlTag tag, String subTagName) {
        XmlTag subTag = tag.findFirstSubTag(subTagName);
        if (subTag != null) {
            return subTag.getValue().getTrimmedText();
        }
        return null;
    }

    public static int getStartOffsetInFile(XmlTag xmlTag) {
        int off = 0;
        while (true) {
            off += xmlTag.getStartOffsetInParent();
            PsiElement parent = xmlTag.getParent();
            if (!(parent instanceof XmlTag)) break;
            xmlTag = (XmlTag)parent;
        }
        return off;
    }

    public static XmlElement setNewValue(XmlElement tag, String value) throws IncorrectOperationException {
        if (tag instanceof XmlTag) {
            ((XmlTag)tag).getValue().setText(value);
            return tag;
        }
        if (tag instanceof XmlAttribute) {
            XmlAttribute attr = (XmlAttribute)tag;
            attr.setValue(value);
            return attr;
        }
        throw new IncorrectOperationException();
    }

    public static String decode(@NonNls String text2) {
        if (text2.isEmpty()) {
            return text2;
        }
        if (text2.charAt(0) != '&' || text2.length() < 3) {
            if (text2.indexOf(60) < 0 && text2.indexOf(62) < 0) {
                return text2;
            }
            return text2.replaceAll("<!\\[CDATA\\[", EMPTY_URI).replaceAll("\\]\\]>", EMPTY_URI);
        }
        if (text2.equals("&lt;")) {
            return "<";
        }
        if (text2.equals("&gt;")) {
            return ">";
        }
        if (text2.equals("&nbsp;")) {
            return "\u00a0";
        }
        if (text2.equals("&amp;")) {
            return "&";
        }
        if (text2.equals("&apos;")) {
            return "'";
        }
        if (text2.equals("&quot;")) {
            return "\"";
        }
        if (text2.startsWith("&quot;") && text2.endsWith("&quot;")) {
            return "\"" + text2.substring(6, text2.length() - 6) + "\"";
        }
        if (text2.startsWith("&#")) {
            text2 = text2.substring(3, text2.length() - 1);
            try {
                return String.valueOf((char)Integer.parseInt(text2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return text2;
    }

    public static String unescape(String text2) {
        return StringUtil.unescapeXml(text2);
    }

    public static String escape(String text2) {
        return StringUtil.escapeXml(text2);
    }

    public static boolean isValidTagNameChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == ':' || c == '_' || c == '-' || c == '.';
    }

    @Nullable
    public static String extractXmlEncodingFromProlog(@NotNull byte[] content) {
        if (content == null) {
            XmlUtil.$$$reportNull$$$0(19);
        }
        return XmlCharsetDetector.extractXmlEncodingFromProlog(content);
    }

    @Nullable
    public static String extractXmlEncodingFromProlog(@NotNull CharSequence text2) {
        if (text2 == null) {
            XmlUtil.$$$reportNull$$$0(20);
        }
        return XmlCharsetDetector.extractXmlEncodingFromProlog(text2);
    }

    public static void registerXmlAttributeValueReferenceProvider(PsiReferenceRegistrar registrar, @Nullable @NonNls String[] attributeNames, @Nullable ElementFilter elementFilter, @NotNull PsiReferenceProvider provider) {
        if (provider == null) {
            XmlUtil.$$$reportNull$$$0(21);
        }
        XmlUtil.registerXmlAttributeValueReferenceProvider(registrar, attributeNames, elementFilter, true, provider);
    }

    public static void registerXmlAttributeValueReferenceProvider(PsiReferenceRegistrar registrar, @Nullable @NonNls String[] attributeNames, @Nullable ElementFilter elementFilter, boolean caseSensitive, @NotNull PsiReferenceProvider provider) {
        if (provider == null) {
            XmlUtil.$$$reportNull$$$0(22);
        }
        XmlUtil.registerXmlAttributeValueReferenceProvider(registrar, attributeNames, elementFilter, caseSensitive, provider, 0.0);
    }

    public static void registerXmlAttributeValueReferenceProvider(PsiReferenceRegistrar registrar, @Nullable @NonNls String[] attributeNames, @Nullable ElementFilter elementFilter, boolean caseSensitive, @NotNull PsiReferenceProvider provider, double priority) {
        if (provider == null) {
            XmlUtil.$$$reportNull$$$0(23);
        }
        if (attributeNames == null) {
            registrar.registerReferenceProvider(XmlPatterns.xmlAttributeValue().and(new FilterPattern(elementFilter)), provider, priority);
            return;
        }
        StringPattern namePattern = caseSensitive ? StandardPatterns.string().oneOf(attributeNames) : StandardPatterns.string().oneOfIgnoreCase(attributeNames);
        registrar.registerReferenceProvider(XmlPatterns.xmlAttributeValue().withLocalName(namePattern).and(new FilterPattern(elementFilter)), provider, priority);
    }

    public static void registerXmlTagReferenceProvider(PsiReferenceRegistrar registrar, @NonNls String[] names, @Nullable ElementFilter elementFilter, boolean caseSensitive, @NotNull PsiReferenceProvider provider) {
        if (provider == null) {
            XmlUtil.$$$reportNull$$$0(24);
        }
        if (names == null) {
            registrar.registerReferenceProvider(XmlPatterns.xmlTag().and(new FilterPattern(elementFilter)), provider, 0.0);
            return;
        }
        StringPattern namePattern = caseSensitive ? StandardPatterns.string().oneOf(names) : StandardPatterns.string().oneOfIgnoreCase(names);
        registrar.registerReferenceProvider(((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName(namePattern)).and(new FilterPattern(elementFilter)), provider, 0.0);
    }

    public static XmlFile findDescriptorFile(@NotNull XmlTag tag, @NotNull XmlFile containingFile) {
        XmlFile descriptorFile;
        XmlElementDescriptor descriptor;
        XmlNSDescriptor nsDescriptor;
        if (tag == null) {
            XmlUtil.$$$reportNull$$$0(25);
        }
        if (containingFile == null) {
            XmlUtil.$$$reportNull$$$0(26);
        }
        XmlNSDescriptor xmlNSDescriptor = nsDescriptor = (descriptor = tag.getDescriptor()) != null ? descriptor.getNSDescriptor() : null;
        XmlFile xmlFile = nsDescriptor != null ? nsDescriptor.getDescriptorFile() : (descriptorFile = containingFile.getDocument().getProlog().getDoctype() != null ? containingFile : null);
        if (nsDescriptor != null && (descriptorFile == null || descriptorFile.getName().equals(containingFile.getName() + ".dtd"))) {
            descriptorFile = containingFile;
        }
        return descriptorFile;
    }

    static {
        BUILDING_DOM_STUBS = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        LOG = Logger.getInstance("#com.intellij.xml.util.XmlUtil");
        JSTL_FORMAT_URIS = new String[]{JSTL_FORMAT_URI, JSTL_FORMAT_URI2, JSTL_FORMAT_URI3};
        doNotVisitTags = new HashSet<String>(Arrays.asList("annotation", "element", "attribute"));
        URL xhtml4SchemaLocationUrl = XmlUtil.class.getResource("/standardSchemas/xhtml1-transitional.xsd");
        XHTML4_SCHEMA_LOCATION = VfsUtilCore.urlToPath(VfsUtilCore.toIdeaUrl(FileUtil.unquote(xhtml4SchemaLocationUrl.toExternalForm()), false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/XmlUtil";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsLocation";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedValue";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaLocation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/XmlUtil";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findPrefixByQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findNamespacePrefixByURI";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findNamespace";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceByLocation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findXmlFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tagFromTemplateFramework";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCharFromEntityRef";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaSimpleContent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorFromContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "expandTag";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRealNamedElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixLength";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findPrefixByQualifiedName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "extractXmlEncodingFromProlog";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "registerXmlAttributeValueReferenceProvider";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "registerXmlTagReferenceProvider";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptorFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAttributeInfo
    implements Comparable {
        boolean myRequired = true;
        String myName = null;

        MyAttributeInfo(String name) {
            this.myName = name;
        }

        MyAttributeInfo(String name, boolean flag) {
            this.myName = name;
            this.myRequired = flag;
        }

        public int compareTo(Object o) {
            if (o instanceof MyAttributeInfo) {
                return this.myName.compareTo(((MyAttributeInfo)o).myName);
            }
            if (o instanceof XmlAttribute) {
                return this.myName.compareTo(((XmlAttribute)o).getName());
            }
            return -1;
        }
    }

    public static interface DuplicationInfoProvider<T extends PsiElement> {
        @Nullable
        public String getName(@NotNull T var1);

        @NotNull
        public String getNameKey(@NotNull T var1, @NotNull String var2);

        @NotNull
        public PsiElement getNodeForMessage(@NotNull T var1);
    }
}

