/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JUnit5PlatformInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit5.platform.runner.display.name", new Object[0]);
        if (string == null) {
            JUnit5PlatformInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        if (string == null) {
            JUnit5PlatformInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitClass(PsiClass aClass) {
                PsiTypeElement operand;
                PsiClass runnerClass;
                PsiAnnotationMemberValue value;
                PsiAnnotation annotation;
                PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
                if (nameIdentifier != null && PsiClassUtil.isRunnableClass(aClass, true, false) && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, "org.junit.runner.RunWith")) != null && (value = annotation.findAttributeValue("value")) instanceof PsiClassObjectAccessExpression && (runnerClass = PsiUtil.resolveClassInClassTypeOnly((operand = ((PsiClassObjectAccessExpression)value).getOperand()).getType())) != null && "org.junit.platform.runner.JUnitPlatform".equals(runnerClass.getQualifiedName()) && Arrays.stream(aClass.getMethods()).noneMatch(method -> method.hasModifierProperty("public") && method.getParameterList().getParametersCount() == 0 && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "org.junit.Test", false))) {
                    this.registerError((PsiElement)nameIdentifier, "Class #ref annotated @RunWith(JUnitPlatform.class) lacks test methods");
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/JUnit5PlatformInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

