/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageFolding
extends LanguageExtension<FoldingBuilder> {
    public static final LanguageFolding INSTANCE = new LanguageFolding();

    private LanguageFolding() {
        super("com.intellij.lang.foldingBuilder");
    }

    @Override
    public FoldingBuilder forLanguage(@NotNull Language l) {
        FoldingBuilder result;
        FoldingBuilder cached;
        if (l == null) {
            LanguageFolding.$$$reportNull$$$0(0);
        }
        if ((cached = (FoldingBuilder)l.getUserData(this.getLanguageCache())) != null) {
            return cached;
        }
        ArrayList<FoldingBuilder> extensions = new ArrayList<FoldingBuilder>(this.forKey(l));
        MetaLanguage.getAllMatchingMetaLanguages(l).forEach(metaLanguage -> extensions.addAll(this.allForLanguage((Language)metaLanguage)));
        if (extensions.isEmpty()) {
            Language base = l.getBaseLanguage();
            result = base != null ? this.forLanguage(base) : (FoldingBuilder)this.getDefaultImplementation();
        } else {
            return extensions.size() == 1 ? (FoldingBuilder)extensions.get(0) : new CompositeFoldingBuilder(extensions);
        }
        l.putUserData(this.getLanguageCache(), result);
        return result;
    }

    @Override
    @NotNull
    public List<FoldingBuilder> allForLanguage(@NotNull Language l) {
        FoldingBuilder result;
        if (l == null) {
            LanguageFolding.$$$reportNull$$$0(1);
        }
        if ((result = this.forLanguage(l)) == null) {
            List<FoldingBuilder> list = Collections.emptyList();
            if (list == null) {
                LanguageFolding.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<FoldingBuilder> list = result instanceof CompositeFoldingBuilder ? ((CompositeFoldingBuilder)result).getAllBuilders() : Collections.singletonList(result);
        if (list == null) {
            LanguageFolding.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static FoldingDescriptor[] buildFoldingDescriptors(@Nullable FoldingBuilder builder, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            LanguageFolding.$$$reportNull$$$0(4);
        }
        if (document == null) {
            LanguageFolding.$$$reportNull$$$0(5);
        }
        if (!DumbService.isDumbAware(builder) && DumbService.getInstance(root.getProject()).isDumb()) {
            if (FoldingDescriptor.EMPTY == null) {
                LanguageFolding.$$$reportNull$$$0(6);
            }
            return FoldingDescriptor.EMPTY;
        }
        if (builder instanceof FoldingBuilderEx) {
            FoldingDescriptor[] foldingDescriptorArray = ((FoldingBuilderEx)builder).buildFoldRegions(root, document, quick);
            if (foldingDescriptorArray == null) {
                LanguageFolding.$$$reportNull$$$0(7);
            }
            return foldingDescriptorArray;
        }
        ASTNode astNode = root.getNode();
        if (astNode == null || builder == null) {
            if (FoldingDescriptor.EMPTY == null) {
                LanguageFolding.$$$reportNull$$$0(8);
            }
            return FoldingDescriptor.EMPTY;
        }
        FoldingDescriptor[] foldingDescriptorArray = builder.buildFoldRegions(astNode, document);
        if (foldingDescriptorArray == null) {
            LanguageFolding.$$$reportNull$$$0(9);
        }
        return foldingDescriptorArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/folding/LanguageFolding";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/folding/LanguageFolding";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldingDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguage";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldingDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

