/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import gnu.trove.THashSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileWrapper {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.ex.InspectionProfileWrapper");
    public static final Key<Function<InspectionProfileImpl, InspectionProfileWrapper>> CUSTOMIZATION_KEY = Key.create("Inspection Profile Wrapper Customization");
    private static boolean alreadyChecked;
    protected final InspectionProfileImpl myProfile;

    public InspectionProfileWrapper(@NotNull InspectionProfileImpl profile2) {
        if (profile2 == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(0);
        }
        this.myProfile = profile2;
    }

    public static void checkInspectionsDuplicates(@NotNull InspectionToolWrapper[] toolWrappers) {
        if (toolWrappers == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(1);
        }
        if (alreadyChecked) {
            return;
        }
        alreadyChecked = true;
        THashSet uniqueTools = new THashSet(toolWrappers.length);
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            if (uniqueTools.add(toolWrapper.getTool())) continue;
            LOG.error("Inspection " + toolWrapper.getDisplayName() + " (" + toolWrapper.getTool().getClass() + ") already registered");
        }
    }

    public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
        return this.myProfile.isToolEnabled(key, element);
    }

    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element) {
        if (inspectionToolKey == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(2);
        }
        return this.myProfile.getErrorLevel(inspectionToolKey, element);
    }

    public InspectionToolWrapper getInspectionTool(String shortName, PsiElement element) {
        return this.myProfile.getInspectionTool(shortName, element);
    }

    @NotNull
    public InspectionProfileImpl getInspectionProfile() {
        InspectionProfileImpl inspectionProfileImpl = this.myProfile;
        if (inspectionProfileImpl == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(3);
        }
        return inspectionProfileImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionToolKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionProfileWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionProfileWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkInspectionsDuplicates";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getErrorLevel";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

