/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlTokenType;

public class XmlConditionalSectionImpl
extends XmlElementImpl
implements XmlConditionalSection {
    public XmlConditionalSectionImpl() {
        super(XmlElementType.XML_CONDITIONAL_SECTION);
    }

    @Override
    public boolean isIncluded(PsiFile targetFile) {
        ASTNode child = this.findChildByType(XmlTokenType.XML_CONDITIONAL_SECTION_START);
        if (child != null) {
            if ((child = child.getTreeNext()) != null && child.getElementType() == TokenType.WHITE_SPACE) {
                child = child.getTreeNext();
            }
            if (child != null) {
                IElementType elementType = child.getElementType();
                if (elementType == XmlTokenType.XML_CONDITIONAL_INCLUDE) {
                    return true;
                }
                if (elementType == XmlTokenType.XML_CONDITIONAL_IGNORE) {
                    return false;
                }
                if (elementType == XmlElementType.XML_ENTITY_REF) {
                    XmlEntityDecl decl;
                    XmlEntityDecl psiElement;
                    XmlEntityRef xmlEntityRef = (XmlEntityRef)child.getPsi();
                    String text2 = xmlEntityRef.getText();
                    String name = text2.substring(1, text2.length() - 1);
                    XmlEntityDecl xmlEntityDecl = psiElement = targetFile != null ? XmlEntityCache.getCachedEntity(targetFile, name) : null;
                    if (psiElement instanceof XmlEntityDecl && (decl = psiElement).isInternalReference()) {
                        for (ASTNode e = decl.getNode().getFirstChildNode(); e != null; e = e.getTreeNext()) {
                            if (e.getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE) continue;
                            boolean b = StringUtil.stripQuotesAroundValue(e.getText()).equals("INCLUDE");
                            return b;
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public PsiElement getBodyStart() {
        ASTNode child = this.findChildByType(XmlTokenType.XML_MARKUP_START);
        if (child != null) {
            child = child.getTreeNext();
        }
        if (child != null) {
            return child.getPsi();
        }
        return null;
    }
}

