/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquivalenceChecker {
    protected static final Match EXACT_MATCH = new Match(true);
    protected static final Match EXACT_MISMATCH = new Match(false);
    private static final EquivalenceChecker ourCanonicalPsiEquivalence = new EquivalenceChecker();

    public static EquivalenceChecker getCanonicalPsiEquivalence() {
        return ourCanonicalPsiEquivalence;
    }

    public boolean statementsAreEquivalent(@Nullable PsiStatement statement1, @Nullable PsiStatement statement2) {
        return this.statementsMatch(statement1, statement2).isExactMatch();
    }

    public Match statementsMatch(@Nullable PsiStatement statement1, @Nullable PsiStatement statement2) {
        statement1 = ControlFlowUtils.stripBraces(statement1);
        statement2 = ControlFlowUtils.stripBraces(statement2);
        if (statement1 == null) {
            return Match.exact(statement2 == null);
        }
        if (statement2 == null) {
            return EXACT_MISMATCH;
        }
        if (statement1.getClass() != statement2.getClass()) {
            return EXACT_MISMATCH;
        }
        if (statement1 instanceof PsiAssertStatement) {
            return this.assertStatementsMatch((PsiAssertStatement)statement1, (PsiAssertStatement)statement2);
        }
        if (statement1 instanceof PsiBlockStatement) {
            return this.blockStatementsMatch((PsiBlockStatement)statement1, (PsiBlockStatement)statement2);
        }
        if (statement1 instanceof PsiBreakStatement) {
            return this.breakStatementsMatch((PsiBreakStatement)statement1, (PsiBreakStatement)statement2);
        }
        if (statement1 instanceof PsiContinueStatement) {
            return this.continueStatementsMatch((PsiContinueStatement)statement1, (PsiContinueStatement)statement2);
        }
        if (statement1 instanceof PsiDeclarationStatement) {
            return this.declarationStatementsMatch((PsiDeclarationStatement)statement1, (PsiDeclarationStatement)statement2);
        }
        if (statement1 instanceof PsiDoWhileStatement) {
            return this.doWhileStatementsMatch((PsiDoWhileStatement)statement1, (PsiDoWhileStatement)statement2);
        }
        if (statement1 instanceof PsiEmptyStatement) {
            return EXACT_MATCH;
        }
        if (statement1 instanceof PsiExpressionListStatement) {
            return this.expressionListStatementsMatch((PsiExpressionListStatement)statement1, (PsiExpressionListStatement)statement2);
        }
        if (statement1 instanceof PsiExpressionStatement) {
            return this.expressionStatementsMatch((PsiExpressionStatement)statement1, (PsiExpressionStatement)statement2);
        }
        if (statement1 instanceof PsiForStatement) {
            return this.forStatementsMatch((PsiForStatement)statement1, (PsiForStatement)statement2);
        }
        if (statement1 instanceof PsiForeachStatement) {
            return this.forEachStatementsMatch((PsiForeachStatement)statement1, (PsiForeachStatement)statement2);
        }
        if (statement1 instanceof PsiIfStatement) {
            return this.ifStatementsMatch((PsiIfStatement)statement1, (PsiIfStatement)statement2);
        }
        if (statement1 instanceof PsiLabeledStatement) {
            return this.labeledStatementsMatch((PsiLabeledStatement)statement1, (PsiLabeledStatement)statement2);
        }
        if (statement1 instanceof PsiReturnStatement) {
            return this.returnStatementsMatch((PsiReturnStatement)statement1, (PsiReturnStatement)statement2);
        }
        if (statement1 instanceof PsiSwitchStatement) {
            return this.switchStatementsMatch((PsiSwitchStatement)statement1, (PsiSwitchStatement)statement2);
        }
        if (statement1 instanceof PsiSwitchLabelStatement) {
            return this.switchLabelStatementsMatch((PsiSwitchLabelStatement)statement1, (PsiSwitchLabelStatement)statement2);
        }
        if (statement1 instanceof PsiSynchronizedStatement) {
            return this.synchronizedStatementsMatch((PsiSynchronizedStatement)statement1, (PsiSynchronizedStatement)statement2);
        }
        if (statement1 instanceof PsiThrowStatement) {
            return this.throwStatementsMatch((PsiThrowStatement)statement1, (PsiThrowStatement)statement2);
        }
        if (statement1 instanceof PsiTryStatement) {
            return this.tryStatementsMatch((PsiTryStatement)statement1, (PsiTryStatement)statement2);
        }
        if (statement1 instanceof PsiWhileStatement) {
            return this.whileStatementsMatch((PsiWhileStatement)statement1, (PsiWhileStatement)statement2);
        }
        String text1 = statement1.getText();
        String text2 = statement2.getText();
        return Match.exact(text1.equals(text2));
    }

    protected Match declarationStatementsMatch(@NotNull PsiDeclarationStatement statement1, @NotNull PsiDeclarationStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(1);
        }
        PsiElement[] elements1 = statement1.getDeclaredElements();
        ArrayList<PsiLocalVariable> vars1 = new ArrayList<PsiLocalVariable>(elements1.length);
        for (PsiElement anElement : elements1) {
            if (!(anElement instanceof PsiLocalVariable)) continue;
            vars1.add((PsiLocalVariable)anElement);
        }
        PsiElement[] elements2 = statement2.getDeclaredElements();
        ArrayList<PsiLocalVariable> vars2 = new ArrayList<PsiLocalVariable>(elements2.length);
        for (PsiElement anElement : elements2) {
            if (!(anElement instanceof PsiLocalVariable)) continue;
            vars2.add((PsiLocalVariable)anElement);
        }
        int size = vars1.size();
        if (size != vars2.size()) {
            return EXACT_MISMATCH;
        }
        for (int i = 0; i < size; ++i) {
            PsiLocalVariable var2;
            PsiLocalVariable var1 = (PsiLocalVariable)vars1.get(i);
            if (this.localVariablesAreEquivalent(var1, var2 = (PsiLocalVariable)vars2.get(i)).isExactMatch()) continue;
            return EXACT_MISMATCH;
        }
        return EXACT_MATCH;
    }

    protected Match localVariablesAreEquivalent(@NotNull PsiLocalVariable localVariable1, @NotNull PsiLocalVariable localVariable2) {
        PsiType type2;
        PsiType type1;
        if (localVariable1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(2);
        }
        if (localVariable2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(3);
        }
        if (!this.typesAreEquivalent(type1 = localVariable1.getType(), type2 = localVariable2.getType())) {
            return EXACT_MISMATCH;
        }
        String name1 = localVariable1.getName();
        String name2 = localVariable2.getName();
        if (name1 == null) {
            return Match.exact(name2 == null);
        }
        if (!name1.equals(name2)) {
            return EXACT_MISMATCH;
        }
        PsiExpression initializer1 = localVariable1.getInitializer();
        PsiExpression initializer2 = localVariable2.getInitializer();
        return this.expressionsMatch(initializer1, initializer2).partialIfExactMismatch(initializer1, initializer2);
    }

    protected Match tryStatementsMatch(@NotNull PsiTryStatement statement1, @NotNull PsiTryStatement statement2) {
        PsiParameter[] catchParameters2;
        PsiParameter[] catchParameters1;
        int i;
        PsiCodeBlock[] catchBlocks2;
        PsiCodeBlock finallyBlock2;
        PsiCodeBlock tryBlock2;
        PsiCodeBlock tryBlock1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(4);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(5);
        }
        if (!this.codeBlocksMatch(tryBlock1 = statement1.getTryBlock(), tryBlock2 = statement2.getTryBlock()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiCodeBlock finallyBlock1 = statement1.getFinallyBlock();
        if (!this.codeBlocksMatch(finallyBlock1, finallyBlock2 = statement2.getFinallyBlock()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiCodeBlock[] catchBlocks1 = statement1.getCatchBlocks();
        if (catchBlocks1.length != (catchBlocks2 = statement2.getCatchBlocks()).length) {
            return EXACT_MISMATCH;
        }
        for (int i2 = 0; i2 < catchBlocks2.length; ++i2) {
            if (this.codeBlocksMatch(catchBlocks1[i2], catchBlocks2[i2]).isExactMatch()) continue;
            return EXACT_MISMATCH;
        }
        PsiResourceList resourceList1 = statement1.getResourceList();
        PsiResourceList resourceList2 = statement2.getResourceList();
        if (resourceList1 != null) {
            if (resourceList2 == null) {
                return EXACT_MISMATCH;
            }
            if (resourceList1.getResourceVariablesCount() != resourceList2.getResourceVariablesCount()) {
                return EXACT_MISMATCH;
            }
            List<PsiResourceListElement> resources1 = PsiTreeUtil.getChildrenOfTypeAsList(resourceList1, PsiResourceListElement.class);
            List<PsiResourceListElement> resources2 = PsiTreeUtil.getChildrenOfTypeAsList(resourceList2, PsiResourceListElement.class);
            int size = resources1.size();
            for (i = 0; i < size; ++i) {
                PsiResourceListElement resource1 = resources1.get(i);
                PsiResourceListElement resource2 = resources2.get(i);
                if (resource1 instanceof PsiResourceVariable && resource2 instanceof PsiResourceVariable) {
                    if (this.localVariablesAreEquivalent((PsiLocalVariable)((Object)resource1), (PsiLocalVariable)((Object)resource2)).isExactMatch()) continue;
                    return EXACT_MISMATCH;
                }
                if (resource1 instanceof PsiResourceExpression && resource2 instanceof PsiResourceExpression) {
                    if (this.expressionsMatch(((PsiResourceExpression)resource1).getExpression(), ((PsiResourceExpression)resource2).getExpression()).isExactMatch()) continue;
                    return EXACT_MISMATCH;
                }
                return EXACT_MISMATCH;
            }
        } else if (resourceList2 != null) {
            return EXACT_MISMATCH;
        }
        if ((catchParameters1 = statement1.getCatchBlockParameters()).length != (catchParameters2 = statement2.getCatchBlockParameters()).length) {
            return EXACT_MISMATCH;
        }
        for (i = 0; i < catchParameters2.length; ++i) {
            if (this.parametersAreEquivalent(catchParameters2[i], catchParameters1[i]).isExactMatch()) continue;
            return EXACT_MISMATCH;
        }
        return EXACT_MATCH;
    }

    protected Match parametersAreEquivalent(@NotNull PsiParameter parameter1, @NotNull PsiParameter parameter2) {
        PsiType type2;
        PsiType type1;
        if (parameter1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(6);
        }
        if (parameter2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(7);
        }
        if (!this.typesAreEquivalent(type1 = parameter1.getType(), type2 = parameter2.getType())) {
            return EXACT_MISMATCH;
        }
        String name1 = parameter1.getName();
        String name2 = parameter2.getName();
        if (name1 == null) {
            return Match.exact(name2 == null);
        }
        return Match.exact(name1.equals(name2));
    }

    public boolean typesAreEquivalent(@Nullable PsiType type1, @Nullable PsiType type2) {
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        String type1Text = type1.getCanonicalText();
        String type2Text = type2.getCanonicalText();
        return type1Text.equals(type2Text);
    }

    protected Match whileStatementsMatch(@NotNull PsiWhileStatement statement1, @NotNull PsiWhileStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(8);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(9);
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        Match conditionEquivalence = this.expressionsMatch(condition1, condition2);
        Match bodyEquivalence = this.statementsMatch(body1, body2);
        return EquivalenceChecker.getComplexElementDecision(bodyEquivalence, conditionEquivalence, body1, body2, condition1, condition2);
    }

    protected Match forStatementsMatch(@NotNull PsiForStatement statement1, @NotNull PsiForStatement statement2) {
        PsiStatement update2;
        PsiStatement initialization2;
        PsiExpression condition2;
        PsiExpression condition1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(10);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(11);
        }
        if (!this.expressionsMatch(condition1 = statement1.getCondition(), condition2 = statement2.getCondition()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiStatement initialization1 = statement1.getInitialization();
        if (!this.statementsMatch(initialization1, initialization2 = statement2.getInitialization()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiStatement update1 = statement1.getUpdate();
        if (!this.statementsMatch(update1, update2 = statement2.getUpdate()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return this.statementsMatch(body1, body2).partialIfExactMismatch(body1, body2);
    }

    protected Match forEachStatementsMatch(@NotNull PsiForeachStatement statement1, @NotNull PsiForeachStatement statement2) {
        PsiExpression value2;
        PsiExpression value1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(12);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(13);
        }
        if (!this.expressionsMatch(value1 = statement1.getIteratedValue(), value2 = statement2.getIteratedValue()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiParameter parameter1 = statement1.getIterationParameter();
        PsiParameter parameter2 = statement1.getIterationParameter();
        String name1 = parameter1.getName();
        if (name1 == null) {
            return Match.exact(parameter2.getName() == null);
        }
        if (!name1.equals(parameter2.getName())) {
            return EXACT_MISMATCH;
        }
        PsiType type1 = parameter1.getType();
        if (!type1.equals(parameter2.getType())) {
            return EXACT_MISMATCH;
        }
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return this.statementsMatch(body1, body2).partialIfExactMismatch(body1, body2);
    }

    protected Match switchStatementsMatch(@NotNull PsiSwitchStatement statement1, @NotNull PsiSwitchStatement statement2) {
        PsiCodeBlock body2;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(14);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(15);
        }
        PsiExpression switchExpression1 = statement1.getExpression();
        PsiExpression switchExpression2 = statement2.getExpression();
        PsiCodeBlock body1 = statement1.getBody();
        Match bodyEq = this.codeBlocksMatch(body1, body2 = statement2.getBody());
        if (bodyEq != EXACT_MATCH) {
            return EXACT_MISMATCH;
        }
        return this.expressionsMatch(switchExpression1, switchExpression2).partialIfExactMismatch(switchExpression1, switchExpression2);
    }

    protected Match doWhileStatementsMatch(@NotNull PsiDoWhileStatement statement1, @NotNull PsiDoWhileStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(16);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(17);
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        Match conditionEq = this.expressionsMatch(condition1, condition2);
        Match bodyEq = this.statementsMatch(body1, body2);
        return EquivalenceChecker.getComplexElementDecision(bodyEq, conditionEq, body1, body2, condition1, condition2);
    }

    protected Match assertStatementsMatch(@NotNull PsiAssertStatement statement1, @NotNull PsiAssertStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(18);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(19);
        }
        PsiExpression condition1 = statement1.getAssertCondition();
        PsiExpression condition2 = statement2.getAssertCondition();
        PsiExpression description1 = statement1.getAssertDescription();
        PsiExpression description2 = statement2.getAssertDescription();
        Match condEq = this.expressionsMatch(condition1, condition2);
        Match exprEq = this.expressionsMatch(description1, description2);
        return EquivalenceChecker.getComplexElementDecision(condEq, exprEq, condition1, condition2, description1, description2);
    }

    protected Match synchronizedStatementsMatch(@NotNull PsiSynchronizedStatement statement1, @NotNull PsiSynchronizedStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(20);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(21);
        }
        PsiExpression lock1 = statement1.getLockExpression();
        PsiExpression lock2 = statement2.getLockExpression();
        PsiCodeBlock body1 = statement1.getBody();
        PsiCodeBlock body2 = statement2.getBody();
        Match lockEq = this.expressionsMatch(lock1, lock2);
        Match blockEq = this.codeBlocksMatch(body1, body2);
        return EquivalenceChecker.getComplexElementDecision(blockEq, lockEq, body1, body2, lock1, lock2);
    }

    protected Match blockStatementsMatch(@NotNull PsiBlockStatement statement1, @NotNull PsiBlockStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(22);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(23);
        }
        PsiCodeBlock block1 = statement1.getCodeBlock();
        PsiCodeBlock block2 = statement2.getCodeBlock();
        return this.codeBlocksMatch(block1, block2);
    }

    protected Match breakStatementsMatch(@NotNull PsiBreakStatement statement1, @NotNull PsiBreakStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(24);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(25);
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        if (identifier1 == null) {
            return Match.exact(identifier2 == null);
        }
        if (identifier2 == null) {
            return EXACT_MISMATCH;
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return Match.exact(text1.equals(text2));
    }

    protected Match continueStatementsMatch(@NotNull PsiContinueStatement statement1, @NotNull PsiContinueStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(26);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(27);
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        if (identifier1 == null) {
            return Match.exact(identifier2 == null);
        }
        if (identifier2 == null) {
            return EXACT_MISMATCH;
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return Match.exact(text1.equals(text2));
    }

    protected Match switchLabelStatementsMatch(@NotNull PsiSwitchLabelStatement statement1, @NotNull PsiSwitchLabelStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(28);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(29);
        }
        if (statement1.isDefaultCase()) {
            return Match.exact(statement2.isDefaultCase());
        }
        if (statement2.isDefaultCase()) {
            return EXACT_MISMATCH;
        }
        PsiExpression caseExpression1 = statement1.getCaseValue();
        PsiExpression caseExpression2 = statement2.getCaseValue();
        return this.expressionsMatch(caseExpression1, caseExpression2).partialIfExactMismatch(caseExpression1, caseExpression2);
    }

    protected Match labeledStatementsMatch(@NotNull PsiLabeledStatement statement1, @NotNull PsiLabeledStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(30);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(31);
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return Match.exact(text1.equals(text2));
    }

    public boolean codeBlocksAreEquivalent(@Nullable PsiCodeBlock block1, @Nullable PsiCodeBlock block2) {
        return this.codeBlocksMatch(block1, block2).isExactMatch();
    }

    protected Match codeBlocksMatch(@Nullable PsiCodeBlock block1, @Nullable PsiCodeBlock block2) {
        if (block1 == null && block2 == null) {
            return EXACT_MATCH;
        }
        if (block1 == null || block2 == null) {
            return EXACT_MISMATCH;
        }
        PsiStatement[] statements1 = block1.getStatements();
        PsiStatement[] statements2 = block2.getStatements();
        if (statements2.length != statements1.length) {
            return EXACT_MISMATCH;
        }
        for (int i = 0; i < statements2.length; ++i) {
            if (this.statementsMatch(statements2[i], statements1[i]).isExactMatch()) continue;
            return EXACT_MISMATCH;
        }
        return EXACT_MATCH;
    }

    protected Match ifStatementsMatch(@NotNull PsiIfStatement statement1, @NotNull PsiIfStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(32);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(33);
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement thenBranch1 = statement1.getThenBranch();
        PsiStatement thenBranch2 = statement2.getThenBranch();
        PsiStatement elseBranch1 = statement1.getElseBranch();
        PsiStatement elseBranch2 = statement2.getElseBranch();
        Match conditionEq = this.expressionsMatch(condition1, condition2);
        Match thenEq = this.statementsMatch(thenBranch1, thenBranch2);
        Match elseEq = this.statementsMatch(elseBranch1, elseBranch2);
        if (conditionEq == EXACT_MATCH && thenEq == EXACT_MATCH && elseEq == EXACT_MATCH) {
            return EXACT_MATCH;
        }
        return EXACT_MISMATCH;
    }

    protected Match expressionStatementsMatch(@NotNull PsiExpressionStatement statement1, @NotNull PsiExpressionStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(34);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(35);
        }
        PsiExpression expression1 = statement1.getExpression();
        PsiExpression expression2 = statement2.getExpression();
        return this.expressionsMatch(expression1, expression2);
    }

    protected Match returnStatementsMatch(@NotNull PsiReturnStatement statement1, @NotNull PsiReturnStatement statement2) {
        PsiExpression returnValue2;
        PsiExpression returnValue1;
        Match match;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(36);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(37);
        }
        if ((match = this.expressionsMatch(returnValue1 = statement1.getReturnValue(), returnValue2 = statement2.getReturnValue())).isExactMismatch()) {
            return new Match(returnValue1, returnValue2);
        }
        return match;
    }

    protected Match throwStatementsMatch(@NotNull PsiThrowStatement statement1, @NotNull PsiThrowStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(38);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(39);
        }
        PsiExpression exception1 = statement1.getException();
        PsiExpression exception2 = statement2.getException();
        return this.expressionsMatch(exception1, exception2);
    }

    protected Match expressionListStatementsMatch(@NotNull PsiExpressionListStatement statement1, @NotNull PsiExpressionListStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(40);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(41);
        }
        PsiExpressionList expressionList1 = statement1.getExpressionList();
        PsiExpression[] expressions1 = expressionList1.getExpressions();
        PsiExpressionList expressionList2 = statement2.getExpressionList();
        PsiExpression[] expressions2 = expressionList2.getExpressions();
        return this.expressionsAreEquivalent(expressions1, expressions2);
    }

    public boolean expressionsAreEquivalent(@Nullable PsiExpression expression1, @Nullable PsiExpression expression2) {
        return this.expressionsMatch(expression1, expression2).isExactMatch();
    }

    public Match expressionsMatch(@Nullable PsiExpression expression1, @Nullable PsiExpression expression2) {
        expression1 = ParenthesesUtils.stripParentheses(expression1);
        expression2 = ParenthesesUtils.stripParentheses(expression2);
        if (expression1 == null) {
            return Match.exact(expression2 == null);
        }
        if (expression2 == null) {
            return EXACT_MISMATCH;
        }
        if (expression1.getClass() != expression2.getClass()) {
            return EXACT_MISMATCH;
        }
        if (expression1 instanceof PsiThisExpression) {
            return EXACT_MATCH;
        }
        if (expression1 instanceof PsiSuperExpression) {
            return EXACT_MATCH;
        }
        if (expression1 instanceof PsiLiteralExpression) {
            return this.literalExpressionsMatch((PsiLiteralExpression)expression1, (PsiLiteralExpression)expression2);
        }
        if (expression1 instanceof PsiClassObjectAccessExpression) {
            return this.classObjectAccessExpressionsMatch((PsiClassObjectAccessExpression)expression1, (PsiClassObjectAccessExpression)expression2);
        }
        if (expression1 instanceof PsiReferenceExpression) {
            return this.referenceExpressionsMatch((PsiReferenceExpression)expression1, (PsiReferenceExpression)expression2);
        }
        if (expression1 instanceof PsiMethodCallExpression) {
            return this.methodCallExpressionsMatch((PsiMethodCallExpression)expression1, (PsiMethodCallExpression)expression2);
        }
        if (expression1 instanceof PsiNewExpression) {
            return this.newExpressionsMatch((PsiNewExpression)expression1, (PsiNewExpression)expression2);
        }
        if (expression1 instanceof PsiArrayInitializerExpression) {
            return this.arrayInitializerExpressionsMatch((PsiArrayInitializerExpression)expression1, (PsiArrayInitializerExpression)expression2);
        }
        if (expression1 instanceof PsiTypeCastExpression) {
            return this.typeCastExpressionsMatch((PsiTypeCastExpression)expression1, (PsiTypeCastExpression)expression2);
        }
        if (expression1 instanceof PsiArrayAccessExpression) {
            return this.arrayAccessExpressionsMatch((PsiArrayAccessExpression)expression2, (PsiArrayAccessExpression)expression1);
        }
        if (expression1 instanceof PsiPrefixExpression) {
            return this.prefixExpressionsMatch((PsiPrefixExpression)expression1, (PsiPrefixExpression)expression2);
        }
        if (expression1 instanceof PsiPostfixExpression) {
            return this.postfixExpressionsMatch((PsiPostfixExpression)expression1, (PsiPostfixExpression)expression2);
        }
        if (expression1 instanceof PsiBinaryExpression) {
            return this.binaryExpressionsMatch((PsiBinaryExpression)expression1, (PsiBinaryExpression)expression2);
        }
        if (expression1 instanceof PsiPolyadicExpression) {
            return this.polyadicExpressionsMatch((PsiPolyadicExpression)expression1, (PsiPolyadicExpression)expression2);
        }
        if (expression1 instanceof PsiAssignmentExpression) {
            return this.assignmentExpressionsMatch((PsiAssignmentExpression)expression1, (PsiAssignmentExpression)expression2);
        }
        if (expression1 instanceof PsiConditionalExpression) {
            return this.conditionalExpressionsMatch((PsiConditionalExpression)expression1, (PsiConditionalExpression)expression2);
        }
        if (expression1 instanceof PsiInstanceOfExpression) {
            return this.instanceOfExpressionsMatch((PsiInstanceOfExpression)expression1, (PsiInstanceOfExpression)expression2);
        }
        if (expression1 instanceof PsiLambdaExpression) {
            return this.lambdaExpressionsMatch((PsiLambdaExpression)expression1, (PsiLambdaExpression)expression2);
        }
        return EXACT_MISMATCH;
    }

    protected Match lambdaExpressionsMatch(PsiLambdaExpression expression1, PsiLambdaExpression expression2) {
        PsiParameter[] parameters2;
        PsiParameterList parameterList1 = expression1.getParameterList();
        PsiParameterList parameterList2 = expression2.getParameterList();
        PsiParameter[] parameters1 = parameterList1.getParameters();
        if (parameters1.length != (parameters2 = parameterList2.getParameters()).length) {
            return EXACT_MISMATCH;
        }
        int length = parameters1.length;
        for (int i = 0; i < length; ++i) {
            if (this.parametersAreEquivalent(parameters1[i], parameters2[i]).isExactMatch()) continue;
            return EXACT_MISMATCH;
        }
        PsiElement body1 = EquivalenceChecker.unwrapLambdaBody(expression1.getBody());
        PsiElement body2 = EquivalenceChecker.unwrapLambdaBody(expression2.getBody());
        if (body1 instanceof PsiCodeBlock && body2 instanceof PsiCodeBlock) {
            return this.codeBlocksMatch((PsiCodeBlock)body1, (PsiCodeBlock)body2);
        }
        if (body1 instanceof PsiExpression && body2 instanceof PsiExpression) {
            return this.expressionsMatch((PsiExpression)body1, (PsiExpression)body2);
        }
        return EXACT_MISMATCH;
    }

    private static PsiElement unwrapLambdaBody(PsiElement element) {
        PsiCodeBlock codeBlock;
        PsiStatement[] statements;
        while (element instanceof PsiCodeBlock && (statements = (codeBlock = (PsiCodeBlock)element).getStatements()).length == 1) {
            PsiStatement statement = statements[0];
            if (statement instanceof PsiReturnStatement) {
                return ((PsiReturnStatement)statement).getReturnValue();
            }
            if (statement instanceof PsiExpressionStatement) {
                return ((PsiExpressionStatement)statement).getExpression();
            }
            if (!(statement instanceof PsiBlockStatement)) break;
            element = ((PsiBlockStatement)statement).getCodeBlock();
        }
        return element;
    }

    protected Match literalExpressionsMatch(PsiLiteralExpression expression1, PsiLiteralExpression expression2) {
        Object value1 = expression1.getValue();
        Object value2 = expression2.getValue();
        if (value1 == null) {
            return Match.exact(value2 == null);
        }
        if (value2 == null) {
            return EXACT_MISMATCH;
        }
        return Match.exact(value1.equals(value2));
    }

    protected Match classObjectAccessExpressionsMatch(PsiClassObjectAccessExpression expression1, PsiClassObjectAccessExpression expression2) {
        PsiTypeElement operand1 = expression1.getOperand();
        PsiTypeElement operand2 = expression2.getOperand();
        return this.typeElementsAreEquivalent(operand1, operand2);
    }

    protected Match referenceExpressionsMatch(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
        PsiElement element1 = referenceExpression1.resolve();
        PsiElement element2 = referenceExpression2.resolve();
        if (element1 != null) {
            if (!element1.equals(element2)) {
                return EXACT_MISMATCH;
            }
        } else {
            return EXACT_MISMATCH;
        }
        if (element1 instanceof PsiMember) {
            PsiMember member1 = (PsiMember)element1;
            if (member1.hasModifierProperty("static")) {
                return EXACT_MATCH;
            }
            if (member1 instanceof PsiClass) {
                return EXACT_MATCH;
            }
        } else {
            return EXACT_MATCH;
        }
        PsiExpression qualifier1 = ParenthesesUtils.stripParentheses(referenceExpression1.getQualifierExpression());
        PsiExpression qualifier2 = ParenthesesUtils.stripParentheses(referenceExpression2.getQualifierExpression());
        if (qualifier1 != null && !(qualifier1 instanceof PsiThisExpression) && !(qualifier1 instanceof PsiSuperExpression)) {
            if (qualifier2 == null) {
                return EXACT_MISMATCH;
            }
            return this.expressionsMatch(qualifier1, qualifier2);
        }
        if (qualifier2 != null && !(qualifier2 instanceof PsiThisExpression) && !(qualifier2 instanceof PsiSuperExpression)) {
            return EXACT_MISMATCH;
        }
        return EXACT_MATCH;
    }

    protected Match instanceOfExpressionsMatch(PsiInstanceOfExpression instanceOfExpression1, PsiInstanceOfExpression instanceOfExpression2) {
        PsiExpression operand2;
        PsiExpression operand1 = instanceOfExpression1.getOperand();
        if (!this.expressionsMatch(operand1, operand2 = instanceOfExpression2.getOperand()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiTypeElement typeElement1 = instanceOfExpression1.getCheckType();
        PsiTypeElement typeElement2 = instanceOfExpression2.getCheckType();
        return this.typeElementsAreEquivalent(typeElement1, typeElement2);
    }

    protected Match typeElementsAreEquivalent(PsiTypeElement typeElement1, PsiTypeElement typeElement2) {
        if (typeElement1 == null) {
            return Match.exact(typeElement2 == null);
        }
        if (typeElement2 == null) {
            return EXACT_MISMATCH;
        }
        PsiType type1 = typeElement1.getType();
        PsiType type2 = typeElement2.getType();
        return Match.exact(this.typesAreEquivalent(type1, type2));
    }

    protected Match methodCallExpressionsMatch(@NotNull PsiMethodCallExpression methodCallExpression1, @NotNull PsiMethodCallExpression methodCallExpression2) {
        PsiExpression lastArg;
        PsiElement leftDiff;
        PsiReferenceExpression methodExpression2;
        PsiReferenceExpression methodExpression1;
        Match match;
        if (methodCallExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(42);
        }
        if (methodCallExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(43);
        }
        if ((match = this.expressionsMatch(methodExpression1 = methodCallExpression1.getMethodExpression(), methodExpression2 = methodCallExpression2.getMethodExpression())).isExactMismatch()) {
            return EXACT_MISMATCH;
        }
        PsiExpressionList argumentList1 = methodCallExpression1.getArgumentList();
        PsiExpression[] args1 = argumentList1.getExpressions();
        PsiExpressionList argumentList2 = methodCallExpression2.getArgumentList();
        PsiExpression[] args2 = argumentList2.getExpressions();
        match = match.combine(this.expressionsAreEquivalent(args1, args2));
        if (args1.length != 0 && match.isPartialMatch() && Comparing.equal(leftDiff = match.getLeftDiff(), lastArg = args1[args1.length - 1])) {
            PsiType type1 = lastArg.getType();
            PsiType type2 = args2[args2.length - 1].getType();
            if (type2 instanceof PsiArrayType && !(type1 instanceof PsiArrayType)) {
                return EXACT_MISMATCH;
            }
            if (type1 instanceof PsiArrayType && !(type2 instanceof PsiArrayType)) {
                return EXACT_MISMATCH;
            }
        }
        return match;
    }

    protected Match newExpressionsMatch(@NotNull PsiNewExpression newExpression1, @NotNull PsiNewExpression newExpression2) {
        PsiExpression qualifier2;
        PsiMethod constructor2;
        PsiArrayInitializerExpression arrayInitializer2;
        PsiExpression[] arrayDimensions2;
        if (newExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(44);
        }
        if (newExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(45);
        }
        PsiJavaCodeReferenceElement classReference1 = newExpression1.getClassReference();
        PsiJavaCodeReferenceElement classReference2 = newExpression2.getClassReference();
        if (classReference1 == null || classReference2 == null) {
            return EXACT_MISMATCH;
        }
        PsiElement target1 = classReference1.resolve();
        if (target1 == null) {
            return EXACT_MISMATCH;
        }
        PsiElement target2 = classReference2.resolve();
        if (!target1.equals(target2)) {
            return EXACT_MISMATCH;
        }
        PsiExpression[] arrayDimensions1 = newExpression1.getArrayDimensions();
        if (!this.expressionsAreEquivalent(arrayDimensions1, arrayDimensions2 = newExpression2.getArrayDimensions()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiArrayInitializerExpression arrayInitializer1 = newExpression1.getArrayInitializer();
        if (!this.expressionsMatch(arrayInitializer1, arrayInitializer2 = newExpression2.getArrayInitializer()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiMethod constructor1 = newExpression1.resolveConstructor();
        if (!Comparing.equal(constructor1, constructor2 = newExpression2.resolveConstructor())) {
            return EXACT_MISMATCH;
        }
        PsiExpression qualifier1 = newExpression1.getQualifier();
        if (!this.expressionsMatch(qualifier1, qualifier2 = newExpression2.getQualifier()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiExpressionList argumentList1 = newExpression1.getArgumentList();
        PsiExpression[] args1 = argumentList1 == null ? null : argumentList1.getExpressions();
        PsiExpressionList argumentList2 = newExpression2.getArgumentList();
        PsiExpression[] args2 = argumentList2 == null ? null : argumentList2.getExpressions();
        return this.expressionsAreEquivalent(args1, args2);
    }

    protected Match arrayInitializerExpressionsMatch(@NotNull PsiArrayInitializerExpression arrayInitializerExpression1, @NotNull PsiArrayInitializerExpression arrayInitializerExpression2) {
        if (arrayInitializerExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(46);
        }
        if (arrayInitializerExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(47);
        }
        PsiExpression[] initializers1 = arrayInitializerExpression1.getInitializers();
        PsiExpression[] initializers2 = arrayInitializerExpression2.getInitializers();
        return this.expressionsAreEquivalent(initializers1, initializers2);
    }

    protected Match typeCastExpressionsMatch(@NotNull PsiTypeCastExpression typeCastExpression1, @NotNull PsiTypeCastExpression typeCastExpression2) {
        PsiTypeElement typeElement2;
        PsiTypeElement typeElement1;
        if (typeCastExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(48);
        }
        if (typeCastExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(49);
        }
        if (!this.typeElementsAreEquivalent(typeElement1 = typeCastExpression1.getCastType(), typeElement2 = typeCastExpression2.getCastType()).isExactMatch()) {
            return EXACT_MISMATCH;
        }
        PsiExpression operand1 = typeCastExpression1.getOperand();
        PsiExpression operand2 = typeCastExpression2.getOperand();
        if (operand1 instanceof PsiFunctionalExpression || operand2 instanceof PsiFunctionalExpression) {
            return EXACT_MISMATCH;
        }
        return this.expressionsMatch(operand1, operand2).partialIfExactMismatch(operand1, operand2);
    }

    protected Match arrayAccessExpressionsMatch(@NotNull PsiArrayAccessExpression arrayAccessExpression1, @NotNull PsiArrayAccessExpression arrayAccessExpression2) {
        if (arrayAccessExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(50);
        }
        if (arrayAccessExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(51);
        }
        PsiExpression arrayExpression2 = arrayAccessExpression1.getArrayExpression();
        PsiExpression arrayExpression1 = arrayAccessExpression2.getArrayExpression();
        PsiExpression indexExpression2 = arrayAccessExpression1.getIndexExpression();
        PsiExpression indexExpression1 = arrayAccessExpression2.getIndexExpression();
        Match arrayExpressionEq = this.expressionsMatch(arrayExpression2, arrayExpression1);
        if (arrayExpressionEq != EXACT_MATCH) {
            return EXACT_MISMATCH;
        }
        return this.expressionsMatch(indexExpression1, indexExpression2).partialIfExactMismatch(indexExpression1, indexExpression2);
    }

    protected Match prefixExpressionsMatch(@NotNull PsiPrefixExpression prefixExpression1, @NotNull PsiPrefixExpression prefixExpression2) {
        IElementType tokenType1;
        if (prefixExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(52);
        }
        if (prefixExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(53);
        }
        if (!(tokenType1 = prefixExpression1.getOperationTokenType()).equals(prefixExpression2.getOperationTokenType())) {
            return EXACT_MISMATCH;
        }
        PsiExpression operand1 = prefixExpression1.getOperand();
        PsiExpression operand2 = prefixExpression2.getOperand();
        return this.expressionsMatch(operand1, operand2);
    }

    protected Match postfixExpressionsMatch(@NotNull PsiPostfixExpression postfixExpression1, @NotNull PsiPostfixExpression postfixExpression2) {
        IElementType tokenType1;
        if (postfixExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(54);
        }
        if (postfixExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(55);
        }
        if (!(tokenType1 = postfixExpression1.getOperationTokenType()).equals(postfixExpression2.getOperationTokenType())) {
            return EXACT_MISMATCH;
        }
        PsiExpression operand1 = postfixExpression1.getOperand();
        PsiExpression operand2 = postfixExpression2.getOperand();
        return this.expressionsMatch(operand1, operand2);
    }

    protected Match polyadicExpressionsMatch(@NotNull PsiPolyadicExpression polyadicExpression1, @NotNull PsiPolyadicExpression polyadicExpression2) {
        IElementType tokenType2;
        IElementType tokenType1;
        if (polyadicExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(56);
        }
        if (polyadicExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(57);
        }
        if (!(tokenType1 = polyadicExpression1.getOperationTokenType()).equals(tokenType2 = polyadicExpression2.getOperationTokenType())) {
            return EXACT_MISMATCH;
        }
        PsiExpression[] operands1 = polyadicExpression1.getOperands();
        PsiExpression[] operands2 = polyadicExpression2.getOperands();
        return this.expressionsAreEquivalent(operands1, operands2);
    }

    protected Match binaryExpressionsMatch(@NotNull PsiBinaryExpression binaryExpression1, @NotNull PsiBinaryExpression binaryExpression2) {
        if (binaryExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(58);
        }
        if (binaryExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(59);
        }
        IElementType tokenType1 = binaryExpression1.getOperationTokenType();
        IElementType tokenType2 = binaryExpression2.getOperationTokenType();
        PsiExpression left1 = binaryExpression1.getLOperand();
        PsiExpression left2 = binaryExpression2.getLOperand();
        PsiExpression right1 = binaryExpression1.getROperand();
        PsiExpression right2 = binaryExpression2.getROperand();
        if (!tokenType1.equals(tokenType2)) {
            DfaRelationValue.RelationType rel1 = DfaRelationValue.RelationType.fromElementType(tokenType1);
            DfaRelationValue.RelationType rel2 = DfaRelationValue.RelationType.fromElementType(tokenType2);
            if (rel1 != null && rel2 != null && rel1.getFlipped() == rel2) {
                return this.expressionsAreEquivalent(new PsiExpression[]{left1, right1}, new PsiExpression[]{right2, left2});
            }
            return EXACT_MISMATCH;
        }
        Match match = this.expressionsAreEquivalent(new PsiExpression[]{left1, right1}, new PsiExpression[]{left2, right2});
        return match == EXACT_MISMATCH && ParenthesesUtils.isCommutativeOperation(binaryExpression1) ? this.expressionsAreEquivalent(new PsiExpression[]{left1, right1}, new PsiExpression[]{right2, left2}) : match;
    }

    protected Match assignmentExpressionsMatch(@NotNull PsiAssignmentExpression assignmentExpression1, @NotNull PsiAssignmentExpression assignmentExpression2) {
        IElementType tokenType1;
        if (assignmentExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(60);
        }
        if (assignmentExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(61);
        }
        if (!(tokenType1 = assignmentExpression1.getOperationTokenType()).equals(assignmentExpression2.getOperationTokenType())) {
            return EXACT_MISMATCH;
        }
        PsiExpression lhs1 = assignmentExpression1.getLExpression();
        PsiExpression lhs2 = assignmentExpression2.getLExpression();
        PsiExpression rhs1 = assignmentExpression1.getRExpression();
        PsiExpression rhs2 = assignmentExpression2.getRExpression();
        Match leftEq = this.expressionsMatch(lhs1, lhs2);
        Match rightEq = this.expressionsMatch(rhs1, rhs2);
        return EquivalenceChecker.getComplexElementDecision(leftEq, rightEq, lhs1, lhs2, rhs1, rhs2);
    }

    protected Match conditionalExpressionsMatch(@NotNull PsiConditionalExpression conditionalExpression1, @NotNull PsiConditionalExpression conditionalExpression2) {
        if (conditionalExpression1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(62);
        }
        if (conditionalExpression2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(63);
        }
        PsiExpression condition1 = conditionalExpression1.getCondition();
        PsiExpression condition2 = conditionalExpression2.getCondition();
        PsiExpression thenExpression1 = conditionalExpression1.getThenExpression();
        PsiExpression thenExpression2 = conditionalExpression2.getThenExpression();
        PsiExpression elseExpression1 = conditionalExpression1.getElseExpression();
        PsiExpression elseExpression2 = conditionalExpression2.getElseExpression();
        if (this.expressionsMatch(condition1, condition2) == EXACT_MATCH && this.expressionsMatch(thenExpression1, thenExpression2) == EXACT_MATCH && this.expressionsMatch(elseExpression1, elseExpression2) == EXACT_MATCH) {
            return EXACT_MATCH;
        }
        return EXACT_MISMATCH;
    }

    protected Match expressionsAreEquivalent(@Nullable PsiExpression[] expressions1, @Nullable PsiExpression[] expressions2) {
        if (expressions1 == null && expressions2 == null) {
            return EXACT_MATCH;
        }
        if (expressions1 == null || expressions2 == null) {
            return EXACT_MISMATCH;
        }
        if (expressions1.length != expressions2.length) {
            return EXACT_MISMATCH;
        }
        Match incompleteMatch = null;
        for (int i = 0; i < expressions1.length; ++i) {
            Match match = this.expressionsMatch(expressions1[i], expressions2[i]);
            if (incompleteMatch == null && match.isPartialMatch()) {
                incompleteMatch = match;
                continue;
            }
            if (match.isExactMatch()) continue;
            if (incompleteMatch != null) {
                return EXACT_MISMATCH;
            }
            incompleteMatch = match.partialIfExactMismatch(expressions1[i], expressions2[i]);
        }
        return incompleteMatch == null ? EXACT_MATCH : incompleteMatch;
    }

    @NotNull
    private static Match getComplexElementDecision(Match equivalence1, Match equivalence2, PsiElement left1, PsiElement right1, PsiElement left2, PsiElement right2) {
        if (equivalence2 == EXACT_MATCH) {
            if (equivalence1 == EXACT_MATCH) {
                Match match = EXACT_MATCH;
                if (match == null) {
                    EquivalenceChecker.$$$reportNull$$$0(64);
                }
                return match;
            }
            if (equivalence1 == EXACT_MISMATCH) {
                Match match = new Match(left1, right1);
                if (match == null) {
                    EquivalenceChecker.$$$reportNull$$$0(65);
                }
                return match;
            }
        } else if (equivalence2 == EXACT_MISMATCH) {
            if (equivalence1 == EXACT_MISMATCH) {
                Match match = EXACT_MISMATCH;
                if (match == null) {
                    EquivalenceChecker.$$$reportNull$$$0(66);
                }
                return match;
            }
            if (equivalence1 == EXACT_MATCH) {
                Match match = new Match(left2, right2);
                if (match == null) {
                    EquivalenceChecker.$$$reportNull$$$0(67);
                }
                return match;
            }
        }
        Match match = EXACT_MISMATCH;
        if (match == null) {
            EquivalenceChecker.$$$reportNull$$$0(68);
        }
        return match;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localVariable1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localVariable2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter2";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression1";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression2";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression1";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression2";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayInitializerExpression1";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayInitializerExpression2";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCastExpression1";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCastExpression2";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression1";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression2";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExpression1";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExpression2";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExpression1";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExpression2";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "polyadicExpression1";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "polyadicExpression2";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression1";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression2";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression1";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression2";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalExpression1";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalExpression2";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/EquivalenceChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/EquivalenceChecker";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getComplexElementDecision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "declarationStatementsMatch";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "localVariablesAreEquivalent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryStatementsMatch";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parametersAreEquivalent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "whileStatementsMatch";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forStatementsMatch";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forEachStatementsMatch";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "switchStatementsMatch";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doWhileStatementsMatch";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "assertStatementsMatch";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "synchronizedStatementsMatch";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "blockStatementsMatch";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "breakStatementsMatch";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "continueStatementsMatch";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "switchLabelStatementsMatch";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "labeledStatementsMatch";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "ifStatementsMatch";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "expressionStatementsMatch";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "returnStatementsMatch";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "throwStatementsMatch";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "expressionListStatementsMatch";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "methodCallExpressionsMatch";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "newExpressionsMatch";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "arrayInitializerExpressionsMatch";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "typeCastExpressionsMatch";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "arrayAccessExpressionsMatch";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "prefixExpressionsMatch";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "postfixExpressionsMatch";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "polyadicExpressionsMatch";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "binaryExpressionsMatch";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "assignmentExpressionsMatch";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "conditionalExpressionsMatch";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Match {
        private final PsiElement myLeftDiff;
        private final PsiElement myRightDiff;
        private final Boolean myExactlyMatches;

        Match(boolean exactlyMatches) {
            this.myExactlyMatches = exactlyMatches;
            this.myLeftDiff = null;
            this.myRightDiff = null;
        }

        Match(PsiElement leftDiff, PsiElement rightDiff) {
            this.myExactlyMatches = null;
            this.myLeftDiff = leftDiff;
            this.myRightDiff = rightDiff;
        }

        public PsiElement getLeftDiff() {
            return this.myLeftDiff;
        }

        public PsiElement getRightDiff() {
            return this.myRightDiff;
        }

        public boolean isPartialMatch() {
            return this.myExactlyMatches == null;
        }

        public boolean isExactMatch() {
            return this.myExactlyMatches != null && this.myExactlyMatches != false;
        }

        public boolean isExactMismatch() {
            return this.myExactlyMatches != null && this.myExactlyMatches == false;
        }

        Match partialIfExactMismatch(PsiElement left, PsiElement right) {
            return this == EXACT_MISMATCH ? new Match(left, right) : this;
        }

        static Match exact(boolean exactMatches) {
            return exactMatches ? EXACT_MATCH : EXACT_MISMATCH;
        }

        Match combine(Match other) {
            if (other.isExactMismatch() || this.isExactMatch()) {
                return other;
            }
            if (this.isExactMismatch() || other.isExactMatch()) {
                return this;
            }
            return EXACT_MISMATCH;
        }
    }
}

