/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class ReadObjectAndWriteObjectPrivateInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("NonPrivateSerializationMethod" == null) {
            ReadObjectAndWriteObjectPrivateInspection.$$$reportNull$$$0(0);
        }
        return "NonPrivateSerializationMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("readwriteobject.private.display.name", new Object[0]);
        if (string == null) {
            ReadObjectAndWriteObjectPrivateInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("readwriteobject.private.problem.descriptor", new Object[0]);
        if (string == null) {
            ReadObjectAndWriteObjectPrivateInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReadObjectWriteObjectPrivateVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("private");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/ReadObjectAndWriteObjectPrivateInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReadObjectWriteObjectPrivateVisitor
    extends BaseInspectionVisitor {
        private ReadObjectWriteObjectPrivateVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass aClass;
            if (method == null) {
                ReadObjectWriteObjectPrivateVisitor.$$$reportNull$$$0(0);
            }
            if ((aClass = method.getContainingClass()) == null) {
                return;
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (method.hasModifierProperty("private")) {
                return;
            }
            if (!SerializationUtils.isReadObject(method) && !SerializationUtils.isWriteObject(method)) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/serialization/ReadObjectAndWriteObjectPrivateInspection$ReadObjectWriteObjectPrivateVisitor", "visitMethod"));
        }
    }
}

