/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ImportUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessarilyQualifiedInnerClassAccessInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreReferencesNeedingImport = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.inner.class.access.display.name", new Object[0]);
        if (string == null) {
            UnnecessarilyQualifiedInnerClassAccessInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.inner.class.access.problem.descriptor", aClass.getName());
        if (string == null) {
            UnnecessarilyQualifiedInnerClassAccessInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessarily.qualified.inner.class.access.option", new Object[0]), this, "ignoreReferencesNeedingImport");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarilyQualifiedInnerClassAccessFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarilyQualifiedInnerClassAccessVisitor();
    }

    private static boolean isReferenceToTarget(String referenceText, @NotNull PsiClass target, PsiElement context) {
        PsiJavaCodeReferenceElement reference;
        JavaResolveResult[] results;
        if (target == null) {
            UnnecessarilyQualifiedInnerClassAccessInspection.$$$reportNull$$$0(2);
        }
        if ((results = (reference = JavaPsiFacade.getElementFactory(target.getProject()).createReferenceFromText(referenceText, context)).multiResolve(false)).length == 0) {
            return true;
        }
        if (results.length > 1) {
            return false;
        }
        JavaResolveResult result = results[0];
        return result.isAccessible() && target.equals(result.getElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/UnnecessarilyQualifiedInnerClassAccessInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/UnnecessarilyQualifiedInnerClassAccessInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UnnecessarilyQualifiedInnerClassAccessVisitor
    extends BaseInspectionVisitor {
        private UnnecessarilyQualifiedInnerClassAccessVisitor() {
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            PsiElement qualifier = reference.getQualifier();
            if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            if (this.isInImportOrPackage(reference)) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)qualifier;
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList != null && parameterList.getTypeParameterElements().length > 0) {
                return;
            }
            PsiElement qualifierTarget = referenceElement.resolve();
            if (!(qualifierTarget instanceof PsiClass)) {
                return;
            }
            PsiClass referenceClass = PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class);
            if (referenceClass == null) {
                return;
            }
            PsiElement brace = referenceClass.getLBrace();
            if ((!referenceClass.equals(qualifierTarget) || brace != null && brace.getTextOffset() > reference.getTextOffset()) && UnnecessarilyQualifiedInnerClassAccessInspection.this.ignoreReferencesNeedingImport && (PsiTreeUtil.isAncestor(referenceClass, qualifierTarget, true) || !PsiTreeUtil.isAncestor(qualifierTarget, referenceClass, true))) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!containingClass.equals(qualifierTarget)) {
                return;
            }
            String shortName = aClass.getName();
            if (!UnnecessarilyQualifiedInnerClassAccessInspection.isReferenceToTarget(shortName, aClass, reference)) {
                return;
            }
            this.registerError(qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, aClass);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement(expression);
        }

        private boolean isInImportOrPackage(PsiElement element) {
            while (element instanceof PsiJavaCodeReferenceElement) {
                if (!((element = element.getParent()) instanceof PsiImportStatementBase) && !(element instanceof PsiPackageStatement) && !(element instanceof PsiImportStaticReferenceElement)) continue;
                return true;
            }
            return false;
        }
    }

    private static class UnnecessarilyQualifiedInnerClassAccessFix
    extends InspectionGadgetsFix {
        private UnnecessarilyQualifiedInnerClassAccessFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessarily.qualified.inner.class.access.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarilyQualifiedInnerClassAccessFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            ImportUtils.addImportIfNeeded(aClass, element);
            String shortName = aClass.getName();
            if (UnnecessarilyQualifiedInnerClassAccessInspection.isReferenceToTarget(shortName, aClass, parent)) {
                element.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedInnerClassAccessInspection$UnnecessarilyQualifiedInnerClassAccessFix", "getFamilyName"));
        }
    }
}

