/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncPromise$WhenMappings;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.CompoundConsumer;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J\u001f\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0007H\u0016J\u000f\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0017\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\rH\u0016J\u0018\u0010\u001d\u001a\u00020\u00102\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0000H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0007H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0000H\u0016J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0007H\u0016J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tH\u0016J>\u0010$\u001a\u00020\u0010\"\u0004\b\u0001\u0010\u00012\u0016\u0010%\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0000\u0012\u0002H\u0001\u0018\u00010\u00070\u00062\u000e\u0010&\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00010\u00072\u0006\u0010'\u001a\u00020\rH\u0002J\u0015\u0010(\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010)J,\u0010*\u001a\b\u0012\u0004\u0012\u0002H+0\u0002\"\u0004\b\u0001\u0010+2\u0016\u0010,\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H+0-H\u0016J0\u0010.\u001a\b\u0012\u0004\u0012\u0002H+0\u0002\"\u0004\b\u0001\u0010+2\u001a\u0010,\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H+0\u00020-H\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0000\u0012\u00020\t\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/concurrency/AsyncPromise;", "T", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/openapi/util/Getter;", "()V", "doneRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/util/Consumer;", "rejectedRef", "", "result", "", "stateRef", "Lorg/jetbrains/concurrency/Promise$State;", "kotlin.jvm.PlatformType", "addHandlers", "", "done", "rejected", "blockingGet", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(ILjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "cancel", "get", "()Ljava/lang/Object;", "getState", "notify", "child", "processed", "setError", "", "error", "", "setHandler", "ref", "newConsumer", "targetState", "setResult", "(Ljava/lang/Object;)V", "then", "SUB_RESULT", "handler", "Lcom/intellij/util/Function;", "thenAsync", "projectModel-api"})
public class AsyncPromise<T>
implements Promise<T>,
Getter<T> {
    private final AtomicReference<Consumer<? super T>> doneRef = new AtomicReference();
    private final AtomicReference<Consumer<? super Throwable>> rejectedRef = new AtomicReference();
    private final AtomicReference<Promise.State> stateRef = new AtomicReference<Promise.State>(Promise.State.PENDING);
    private volatile Object result;

    @Override
    @NotNull
    public Promise.State getState() {
        Promise.State state = this.stateRef.get();
        if (state == null) {
            Intrinsics.throwNpe();
        }
        return state;
    }

    @Override
    @NotNull
    public Promise<T> done(@NotNull Consumer<? super T> done2) {
        Intrinsics.checkParameterIsNotNull(done2, (String)"done");
        this.setHandler(this.doneRef, done2, Promise.State.FULFILLED);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> rejected2) {
        Intrinsics.checkParameterIsNotNull(rejected2, (String)"rejected");
        this.setHandler(this.rejectedRef, rejected2, Promise.State.REJECTED);
        return this;
    }

    @Override
    @Nullable
    public T get() {
        return (T)(Intrinsics.areEqual((Object)((Object)this.getState()), (Object)((Object)Promise.State.FULFILLED)) ? this.result : null);
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        switch (AsyncPromise$WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                return new DonePromise<SUB_RESULT>(handler.fun(this.result));
            }
            case 3: {
                Object object = this.result;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
                }
                return Promises.rejectedPromise((Throwable)object);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        AsyncPromise<T> promise = new AsyncPromise<T>();
        this.addHandlers(new Consumer<T>(promise, handler){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Function $handler;

            public final void consume(T result) {
                AsyncPromise $receiver$iv = this.$promise;
                try {
                    if (this.$handler instanceof Obsolescent && ((Obsolescent)((Object)this.$handler)).isObsolete()) {
                        this.$promise.cancel();
                    } else {
                        this.$promise.setResult(this.$handler.fun(result));
                    }
                }
                catch (Throwable e$iv) {
                    $receiver$iv.setError(e$iv);
                }
            }
            {
                this.$promise = asyncPromise;
                this.$handler = function;
            }
        }, new Consumer<Throwable>(promise){
            final /* synthetic */ AsyncPromise $promise;

            public final void consume(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                this.$promise.setError(throwable);
            }
            {
                this.$promise = asyncPromise;
            }
        });
        return promise;
    }

    @Override
    public void notify(@NotNull AsyncPromise<? super T> child) {
        Intrinsics.checkParameterIsNotNull(child, (String)"child");
        AsyncPromiseKt.access$getLOG$p().assertTrue(child != this);
        if (Intrinsics.areEqual((Object)((Object)child.getState()), (Object)((Object)Promise.State.PENDING))) {
            this.processed(child);
        }
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, Promise<SUB_RESULT>> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        switch (AsyncPromise$WhenMappings.$EnumSwitchMapping$1[this.getState().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Promise<SUB_RESULT> promise = handler.fun(this.result);
                Intrinsics.checkExpressionValueIsNotNull(promise, (String)"handler.`fun`(result as T?)");
                return promise;
            }
            case 3: {
                Object object = this.result;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
                }
                return Promises.rejectedPromise((Throwable)object);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        AsyncPromise<T> promise = new AsyncPromise<T>();
        Consumer rejectedHandler2 = new Consumer<Throwable>(promise){
            final /* synthetic */ AsyncPromise $promise;

            public final void consume(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                this.$promise.setError(throwable);
            }
            {
                this.$promise = asyncPromise;
            }
        };
        this.addHandlers(new Consumer<T>(promise, handler, rejectedHandler2){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Function $handler;
            final /* synthetic */ Consumer $rejectedHandler;

            public final void consume(T it) {
                AsyncPromise $receiver$iv = this.$promise;
                try {
                    ((Promise)this.$handler.fun(it)).done((Consumer)new Consumer<SUB_RESULT>(this, it){
                        final /* synthetic */ thenAsync.1 this$0;
                        final /* synthetic */ Object $it$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$it$inlined = object;
                        }

                        public final void consume(SUB_RESULT it) {
                            AsyncPromise $receiver$iv = this.this$0.$promise;
                            try {
                                this.this$0.$promise.setResult(it);
                            }
                            catch (Throwable e$iv) {
                                $receiver$iv.setError(e$iv);
                            }
                        }
                    }).rejected(this.$rejectedHandler);
                }
                catch (Throwable e$iv) {
                    $receiver$iv.setError(e$iv);
                }
            }
            {
                this.$promise = asyncPromise;
                this.$handler = function;
                this.$rejectedHandler = consumer;
            }
        }, rejectedHandler2);
        return promise;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull AsyncPromise<? super T> child) {
        Intrinsics.checkParameterIsNotNull(child, (String)"child");
        switch (AsyncPromise$WhenMappings.$EnumSwitchMapping$2[this.getState().ordinal()]) {
            case 1: {
                this.addHandlers(new Consumer<T>(child){
                    final /* synthetic */ AsyncPromise $child;

                    public final void consume(T it) {
                        AsyncPromise $receiver$iv = this.$child;
                        try {
                            this.$child.setResult(it);
                        }
                        catch (Throwable e$iv) {
                            $receiver$iv.setError(e$iv);
                        }
                    }
                    {
                        this.$child = asyncPromise;
                    }
                }, new Consumer<Throwable>(child){
                    final /* synthetic */ AsyncPromise $child;

                    public final void consume(Throwable it) {
                        Throwable throwable = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                        this.$child.setError(throwable);
                    }
                    {
                        this.$child = asyncPromise;
                    }
                });
                break;
            }
            case 2: {
                child.setResult(this.result);
                break;
            }
            case 3: {
                Throwable throwable = (Throwable)this.result;
                if (throwable == null) {
                    Intrinsics.throwNpe();
                }
                child.setError(throwable);
            }
        }
        return this;
    }

    private final void addHandlers(Consumer<T> done2, Consumer<Throwable> rejected2) {
        this.setHandler(this.doneRef, done2, Promise.State.FULFILLED);
        this.setHandler(this.rejectedRef, rejected2, Promise.State.REJECTED);
    }

    public final void setResult(@Nullable T result) {
        if (!this.stateRef.compareAndSet(Promise.State.PENDING, Promise.State.FULFILLED)) {
            return;
        }
        this.result = result;
        Consumer done2 = this.doneRef.getAndSet(null);
        this.rejectedRef.set(null);
        if (done2 != null && !AsyncPromiseKt.isObsolete(done2)) {
            done2.consume(result);
        }
    }

    public final boolean setError(@NotNull String error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        return this.setError(Promises.createError$default(error, false, 2, null));
    }

    public final void cancel() {
        this.setError(Promises.getOBSOLETE_ERROR());
    }

    public boolean setError(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        if (!this.stateRef.compareAndSet(Promise.State.PENDING, Promise.State.REJECTED)) {
            Promises.errorIfNotMessage(AsyncPromiseKt.access$getLOG$p(), error);
            return false;
        }
        this.result = error;
        Consumer rejected2 = this.rejectedRef.getAndSet(null);
        this.doneRef.set(null);
        if (rejected2 == null) {
            Promises.errorIfNotMessage(AsyncPromiseKt.access$getLOG$p(), error);
        } else if (!AsyncPromiseKt.isObsolete(rejected2)) {
            rejected2.consume(error);
        }
        return true;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull Consumer<? super T> processed2) {
        Intrinsics.checkParameterIsNotNull(processed2, (String)"processed");
        this.done(processed2);
        this.rejected(new Consumer<Throwable>(processed2){
            final /* synthetic */ Consumer $processed;

            public final void consume(Throwable it) {
                this.$processed.consume(null);
            }
            {
                this.$processed = consumer;
            }
        });
        return this;
    }

    @Override
    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        if (Promises.isPending(this)) {
            CountDownLatch latch = new CountDownLatch(1);
            this.processed(new Consumer<T>(latch){
                final /* synthetic */ CountDownLatch $latch;

                public final void consume(T it) {
                    this.$latch.countDown();
                }
                {
                    this.$latch = countDownLatch;
                }
            });
            if (!latch.await(timeout, timeUnit)) {
                throw (Throwable)new TimeoutException();
            }
        }
        if (Promises.isRejected(this)) {
            Object object = this.result;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
            }
            throw (Throwable)object;
        }
        return (T)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void setHandler(AtomicReference<Consumer<? super T>> ref, Consumer<? super T> newConsumer, Promise.State targetState) {
        block15: {
            Consumer consumer;
            Consumer newEffectiveConsumer;
            Consumer<? super T> oldConsumer;
            if (AsyncPromiseKt.isObsolete(newConsumer)) {
                return;
            }
            if (Intrinsics.areEqual((Object)((Object)this.getState()), (Object)((Object)Promise.State.PENDING)) ^ true) {
                if (Intrinsics.areEqual((Object)((Object)this.getState()), (Object)((Object)targetState))) {
                    newConsumer.consume(this.result);
                }
                return;
            }
            do {
                Consumer<? super T> consumer2;
                if ((consumer2 = (oldConsumer = ref.get())) == null) {
                    consumer = newConsumer;
                    continue;
                }
                if (consumer2 instanceof CompoundConsumer) {
                    Consumer<? super T> consumer3 = oldConsumer;
                    if (consumer3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.CompoundConsumer<T>");
                    }
                    CompoundConsumer compoundConsumer = (CompoundConsumer)consumer3;
                    boolean executed = true;
                    synchronized (compoundConsumer) {
                        Unit unit;
                        if (compoundConsumer.getConsumers() != null) {
                            List list;
                            List it = list;
                            it.add(newConsumer);
                            executed = false;
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                    if (executed) {
                        if (Intrinsics.areEqual((Object)((Object)this.getState()), (Object)((Object)targetState))) {
                            newConsumer.consume(this.result);
                        }
                        return;
                    }
                    consumer = compoundConsumer;
                    continue;
                }
                consumer = new CompoundConsumer<T>(oldConsumer, newConsumer);
            } while (!ref.compareAndSet(oldConsumer, newEffectiveConsumer = consumer));
            if (!Intrinsics.areEqual((Object)((Object)this.getState()), (Object)((Object)targetState))) break block15;
            Consumer consumer4 = ref.getAndSet(null);
            if (consumer4 != null) {
                Consumer consumer5;
                Consumer it = consumer5 = consumer4;
                it.consume(this.result);
            }
        }
    }
}

