/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DupInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.JumpInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SpliceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SwapInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CFGBuilder {
    private final ControlFlowAnalyzer myAnalyzer;
    private final Deque<JumpInstruction> myBranches = new ArrayDeque<JumpInstruction>();
    private final Map<PsiExpression, PsiVariable> myMethodRefQualifiers = new HashMap<PsiExpression, PsiVariable>();

    CFGBuilder(ControlFlowAnalyzer analyzer) {
        this.myAnalyzer = analyzer;
    }

    public CFGBuilder pushUnknown() {
        this.myAnalyzer.pushUnknown();
        return this;
    }

    public CFGBuilder pushNull() {
        this.myAnalyzer.addInstruction(new PushInstruction(this.getFactory().getConstFactory().getNull(), null));
        return this;
    }

    public CFGBuilder pushExpression(PsiExpression expression) {
        expression.accept(this.myAnalyzer);
        return this;
    }

    public CFGBuilder pushVariable(PsiVariable variable) {
        this.myAnalyzer.addInstruction(new PushInstruction(this.getFactory().getVarFactory().createVariableValue(variable, false), null, true));
        return this;
    }

    public CFGBuilder push(DfaValue value) {
        this.myAnalyzer.addInstruction(new PushInstruction(value, null));
        return this;
    }

    public CFGBuilder pop() {
        this.myAnalyzer.addInstruction(new PopInstruction());
        return this;
    }

    public CFGBuilder dup() {
        this.myAnalyzer.addInstruction(new DupInstruction());
        return this;
    }

    public CFGBuilder splice(int count, int ... replacement) {
        this.myAnalyzer.addInstruction(new SpliceInstruction(count, replacement));
        return this;
    }

    public CFGBuilder swap() {
        this.myAnalyzer.addInstruction(new SwapInstruction());
        return this;
    }

    public CFGBuilder invoke(PsiMethodCallExpression call) {
        this.myAnalyzer.addBareCall(call, call.getMethodExpression());
        return this;
    }

    private CFGBuilder compare(IElementType relation) {
        this.myAnalyzer.addInstruction(new BinopInstruction(relation, null, this.myAnalyzer.getContext().getProject()));
        return this;
    }

    public CFGBuilder ifConditionIs(boolean value) {
        ConditionalGotoInstruction gotoInstruction = new ConditionalGotoInstruction(null, value, null);
        this.myBranches.add(gotoInstruction);
        this.myAnalyzer.addInstruction(gotoInstruction);
        return this;
    }

    public CFGBuilder ifCondition(IElementType relation) {
        return this.compare(relation).ifConditionIs(true);
    }

    public CFGBuilder ifNotNull() {
        return this.pushNull().ifCondition(JavaTokenType.NE);
    }

    public CFGBuilder ifNull() {
        return this.pushNull().ifCondition(JavaTokenType.EQEQ);
    }

    public CFGBuilder endIf() {
        this.myBranches.removeLast().setOffset(this.myAnalyzer.getInstructionCount());
        return this;
    }

    public CFGBuilder elseBranch() {
        GotoInstruction gotoInstruction = new GotoInstruction(null);
        this.myAnalyzer.addInstruction(gotoInstruction);
        this.endIf();
        this.myBranches.add(gotoInstruction);
        return this;
    }

    public CFGBuilder doWhile() {
        ConditionalGotoInstruction jump = new ConditionalGotoInstruction(null, false, null);
        jump.setOffset(this.myAnalyzer.getInstructionCount());
        this.myBranches.add(jump);
        return this;
    }

    public CFGBuilder endWhileUnknown() {
        this.pushUnknown();
        this.myAnalyzer.addInstruction((ConditionalGotoInstruction)this.myBranches.removeLast());
        return this;
    }

    public CFGBuilder boxUnbox(PsiExpression expression, PsiType expectedType) {
        this.myAnalyzer.generateBoxingUnboxingInstructionFor(expression, expectedType);
        return this;
    }

    public CFGBuilder boxUnbox(PsiExpression expression, PsiType expressionType, PsiType expectedType) {
        this.myAnalyzer.generateBoxingUnboxingInstructionFor(expression, expressionType, expectedType);
        return this;
    }

    public CFGBuilder flushFields() {
        this.myAnalyzer.addInstruction(new FlushVariableInstruction(null));
        return this;
    }

    public CFGBuilder checkNotNull(PsiExpression expression, NullabilityProblem problem) {
        this.myAnalyzer.addInstruction(new CheckNotNullInstruction(expression, problem));
        return this;
    }

    public CFGBuilder assign() {
        this.myAnalyzer.addInstruction(new AssignInstruction(null, null));
        return this;
    }

    public CFGBuilder assignTo(PsiVariable var) {
        return this.pushVariable(var).swap().assign();
    }

    public DfaValueFactory getFactory() {
        return this.myAnalyzer.getFactory();
    }

    public CFGBuilder evaluateFunction(@Nullable PsiExpression functionalExpression) {
        PsiExpression stripped = PsiUtil.deparenthesizeExpression(functionalExpression);
        if (stripped == null || stripped instanceof PsiLambdaExpression) {
            return this;
        }
        if (stripped instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)stripped;
            PsiExpression qualifier = methodRef.getQualifierExpression();
            if (qualifier != null && !PsiMethodReferenceUtil.isStaticallyReferenced(methodRef)) {
                PsiVariable qualifierBinding = this.createTempVariable(qualifier.getType());
                this.pushVariable(qualifierBinding).pushExpression(qualifier).checkNotNull(qualifier, NullabilityProblem.fieldAccessNPE).assign().pop();
                this.myMethodRefQualifiers.put(methodRef, qualifierBinding);
            }
            return this;
        }
        return this.pushExpression(functionalExpression).checkNotNull(functionalExpression, NullabilityProblem.passingNullableToNotNullParameter).pop();
    }

    public CFGBuilder invokeFunction(int argCount, @Nullable PsiExpression functionalExpression) {
        return this.invokeFunction(argCount, functionalExpression, Nullness.UNKNOWN);
    }

    public CFGBuilder invokeFunction(int argCount, @Nullable PsiExpression functionalExpression, Nullness resultNullness) {
        PsiLambdaExpression lambda2;
        Object[] parameters;
        PsiExpression stripped = PsiUtil.deparenthesizeExpression(functionalExpression);
        if (stripped instanceof PsiLambdaExpression && (parameters = (lambda2 = (PsiLambdaExpression)stripped).getParameterList().getParameters()).length == argCount && lambda2.getBody() != null) {
            StreamEx.ofReversed((Object[])parameters).forEach(p -> this.assignTo((PsiVariable)p).pop());
            return this.inlineLambda(lambda2, resultNullness);
        }
        if (stripped instanceof PsiMethodReferenceExpression) {
            PsiElement qualifier;
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)stripped;
            JavaResolveResult resolveResult = methodRef.advancedResolve(false);
            PsiMethod method = ObjectUtils.tryCast(resolveResult.getElement(), PsiMethod.class);
            if (method != null && !method.isVarArgs()) {
                int expectedArgCount = method.getParameterList().getParametersCount();
                boolean pushQualifier = true;
                if (!method.hasModifierProperty("static") && !method.isConstructor()) {
                    boolean bl = pushQualifier = !PsiMethodReferenceUtil.isStaticallyReferenced(methodRef);
                    if (!pushQualifier) {
                        ++expectedArgCount;
                    }
                }
                if (argCount == expectedArgCount) {
                    if (pushQualifier) {
                        PsiVariable qualifierVar = this.myMethodRefQualifiers.remove(methodRef);
                        DfaUnknownValue qualifierValue = qualifierVar == null ? DfaUnknownValue.getInstance() : this.getFactory().getVarFactory().createVariableValue(qualifierVar, false);
                        this.push(qualifierValue);
                        this.moveTopValue(argCount);
                    }
                    this.myAnalyzer.addBareCall(null, methodRef);
                    this.myAnalyzer.generateBoxingUnboxingInstructionFor(methodRef, resolveResult.getSubstitutor().substitute(method.getReturnType()), LambdaUtil.getFunctionalInterfaceReturnType(methodRef));
                    if (resultNullness == Nullness.NOT_NULL) {
                        this.checkNotNull(methodRef, NullabilityProblem.nullableFunctionReturn);
                    }
                    return this;
                }
            }
            if ((qualifier = methodRef.getQualifier()) instanceof PsiTypeElement && ((PsiTypeElement)qualifier).getType() instanceof PsiArrayType) {
                this.splice(argCount, new int[0]).push(this.getFactory().createTypeValue(((PsiTypeElement)qualifier).getType(), Nullness.NOT_NULL));
                return this;
            }
        }
        this.splice(argCount, new int[0]);
        if (functionalExpression == null) {
            this.pushUnknown();
            return this;
        }
        this.flushFields();
        PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalExpression.getType());
        if (returnType != null) {
            this.push(this.getFactory().createTypeValue(returnType, DfaPsiUtil.getTypeNullability(returnType)));
        } else {
            this.pushUnknown();
        }
        return this;
    }

    private void moveTopValue(int depth) {
        if (depth > 0) {
            int[] permutation = new int[depth + 1];
            for (int i = 1; i < permutation.length; ++i) {
                permutation[i] = depth + 1 - i;
            }
            this.splice(depth + 1, permutation);
        }
    }

    public CFGBuilder inlineLambda(PsiLambdaExpression lambda2, Nullness resultNullness) {
        PsiElement body = lambda2.getBody();
        PsiExpression expression = LambdaUtil.extractSingleExpressionFromBody(body);
        if (expression != null) {
            this.pushExpression(expression);
            this.boxUnbox(expression, LambdaUtil.getFunctionalInterfaceReturnType(lambda2));
            if (resultNullness == Nullness.NOT_NULL) {
                this.checkNotNull(expression, NullabilityProblem.nullableFunctionReturn);
            }
        } else if (body instanceof PsiCodeBlock) {
            PsiVariable variable = this.createTempVariable(LambdaUtil.getFunctionalInterfaceReturnType(lambda2));
            this.myAnalyzer.inlineBlock((PsiCodeBlock)body, resultNullness, variable);
            this.push(this.getFactory().getVarFactory().createVariableValue(variable, false));
        } else {
            this.pushUnknown();
        }
        return this;
    }

    @NotNull
    public PsiVariable createTempVariable(@Nullable PsiType type) {
        PsiVariable psiVariable = this.myAnalyzer.createTempVariable(type);
        if (psiVariable == null) {
            CFGBuilder.$$$reportNull$$$0(0);
        }
        return psiVariable;
    }

    public CFGBuilder chain(Consumer<CFGBuilder> operation) {
        operation.accept(this);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/CFGBuilder", "createTempVariable"));
    }
}

