/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SpecialField {
    ARRAY_LENGTH(null, "length", true, LongRangeSet.indexRange()){

        @Override
        public boolean isMyAccessor(PsiModifierListOwner accessor) {
            return accessor instanceof PsiField && "length".equals(((PsiField)accessor).getName()) && JavaPsiFacade.getElementFactory(accessor.getProject()).getArrayClass(PsiUtil.getLanguageLevel(accessor)) == ((PsiField)accessor).getContainingClass();
        }

        @Override
        @Nullable
        public PsiModifierListOwner getCanonicalOwner(@Nullable PsiModifierListOwner qualifier, @Nullable PsiClass psiClass) {
            if (qualifier == null) {
                return null;
            }
            PsiClass arrayClass = JavaPsiFacade.getElementFactory(qualifier.getProject()).getArrayClass(PsiUtil.getLanguageLevel(qualifier));
            return arrayClass.findFieldByName("length", false);
        }
    }
    ,
    STRING_LENGTH("java.lang.String", "length", true, LongRangeSet.indexRange()){

        @Override
        public DfaValue createFromConstant(DfaValueFactory factory, @NotNull Object obj) {
            if (obj == null) {
                2.$$$reportNull$$$0(0);
            }
            return obj instanceof String ? factory.getInt(((String)obj).length()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/codeInspection/dataFlow/SpecialField$2", "createFromConstant"));
        }
    }
    ,
    COLLECTION_SIZE("java.util.Collection", "size", false, LongRangeSet.indexRange()),
    MAP_SIZE("java.util.Map", "size", false, LongRangeSet.indexRange());

    private final String myClassName;
    private final String myMethodName;
    private final boolean myFinal;
    private final LongRangeSet myRange;

    private SpecialField(String className, String methodName, boolean isFinal, LongRangeSet range) {
        this.myClassName = className;
        this.myMethodName = methodName;
        this.myFinal = isFinal;
        this.myRange = range;
    }

    public boolean isFinal() {
        return this.myFinal;
    }

    public LongRangeSet getRange() {
        return this.myRange;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public boolean isMyAccessor(PsiModifierListOwner accessor) {
        return accessor instanceof PsiMethod && MethodUtils.methodMatches((PsiMethod)accessor, this.myClassName, null, this.myMethodName, new PsiType[0]);
    }

    @Nullable
    public PsiModifierListOwner getCanonicalOwner(@Nullable PsiModifierListOwner qualifier, @Nullable PsiClass psiClass) {
        PsiMethod[] methods;
        if (psiClass == null) {
            return null;
        }
        if (!this.myClassName.equals(psiClass.getQualifiedName())) {
            PsiClass myClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(this.myClassName, psiClass.getResolveScope());
            if (!InheritanceUtil.isInheritorOrSelf(psiClass, myClass, true)) {
                return null;
            }
            psiClass = myClass;
        }
        return (methods = psiClass.findMethodsByName(this.myMethodName, false)).length == 1 ? methods[0] : null;
    }

    public DfaValue createValue(DfaValueFactory factory, DfaValue qualifier) {
        DfaValue value;
        Object obj;
        DfaVariableValue variableValue;
        PsiModifierListOwner owner;
        if (qualifier instanceof DfaVariableValue && (owner = this.getCanonicalOwner((variableValue = (DfaVariableValue)qualifier).getPsiVariable(), PsiUtil.resolveClassInClassTypeOnly(variableValue.getVariableType()))) != null) {
            return factory.getVarFactory().createVariableValue(owner, PsiType.INT, false, variableValue);
        }
        if (qualifier instanceof DfaConstValue && (obj = ((DfaConstValue)qualifier).getValue()) != null && (value = this.createFromConstant(factory, obj)) != null) {
            return value;
        }
        return factory.getRangeFactory().create(this.myRange);
    }

    public DfaValue createFromConstant(DfaValueFactory factory, @NotNull Object obj) {
        if (obj == null) {
            SpecialField.$$$reportNull$$$0(0);
        }
        return null;
    }

    public List<MethodContract> getEmptyContracts() {
        ContractValue thisValue = ContractValue.qualifier().specialField(this);
        return Arrays.asList(MethodContract.singleConditionContract(thisValue, DfaRelationValue.RelationType.EQ, ContractValue.zero(), MethodContract.ValueConstraint.TRUE_VALUE), MethodContract.trivialContract(MethodContract.ValueConstraint.FALSE_VALUE));
    }

    public String toString() {
        return StringUtil.getShortName(this.myClassName) + "." + this.myMethodName + "()";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/codeInspection/dataFlow/SpecialField", "createFromConstant"));
    }
}

