/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class Java9ModuleExportsPackageToItselfInspection
extends AbstractBaseJavaLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            Java9ModuleExportsPackageToItselfInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = PsiUtil.isModuleFile(holder.getFile()) ? new ExportedToSelfVisitor(holder) : PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            Java9ModuleExportsPackageToItselfInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExportedToSelfVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public ExportedToSelfVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitPackageAccessibilityStatement(PsiPackageAccessibilityStatement statement) {
            super.visitPackageAccessibilityStatement(statement);
            PsiJavaModule javaModule = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiJavaModule.class);
            if (javaModule != null) {
                String moduleName = javaModule.getName();
                ArrayList<PsiJavaModuleReferenceElement> references = ContainerUtil.newArrayList(statement.getModuleReferences());
                for (PsiJavaModuleReferenceElement referenceElement : references) {
                    String fixText;
                    if (!moduleName.equals(referenceElement.getReferenceText())) continue;
                    String message = InspectionsBundle.message("inspection.module.exports.package.to.itself", new Object[0]);
                    if (references.size() == 1) {
                        fixText = InspectionsBundle.message("exports.to.itself.delete.statement.fix", new Object[0]);
                        this.myHolder.registerProblem((PsiElement)referenceElement, message, QuickFixFactory.getInstance().createDeleteFix(statement, fixText));
                        continue;
                    }
                    fixText = InspectionsBundle.message("exports.to.itself.delete.module.ref.fix", moduleName);
                    this.myHolder.registerProblem((PsiElement)referenceElement, message, QuickFixFactory.getInstance().createDeleteFix(referenceElement, fixText));
                }
            }
        }
    }
}

