/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.javaDoc.JavadocHighlightUtil;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocLocalInspectionBase
extends LocalInspectionTool {
    public static final String SHORT_NAME = "JavaDoc";
    protected static final String NONE = "none";
    protected static final String PACKAGE_LOCAL = "package";
    protected static final String PUBLIC = "public";
    protected static final String PROTECTED = "protected";
    protected static final String PRIVATE = "private";
    private static final String IGNORE_ACCESSORS_ATTR_NAME = "IGNORE_ACCESSORS";
    private static final String IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME = "IGNORE_DUPLICATED_THROWS_TAGS";
    private static final String MODULE_OPTIONS_TAG_NAME = "MODULE_OPTIONS";
    protected final Options PACKAGE_OPTIONS = new Options("none", "");
    protected final Options MODULE_OPTIONS = new Options("none", "");
    public Options TOP_LEVEL_CLASS_OPTIONS = new Options("none", "");
    public Options INNER_CLASS_OPTIONS = new Options("none", "");
    public Options METHOD_OPTIONS = new Options("none", "@return@param@throws or @exception");
    public Options FIELD_OPTIONS = new Options("none", "");
    public boolean IGNORE_DEPRECATED;
    public boolean IGNORE_JAVADOC_PERIOD = true;
    @Deprecated
    public boolean IGNORE_DUPLICATED_THROWS;
    public boolean IGNORE_POINT_TO_ITSELF;
    public String myAdditionalJavadocTags = "";
    private boolean myIgnoreDuplicatedThrows = true;
    private boolean myIgnoreEmptyDescriptions;
    private boolean myIgnoreSimpleAccessors;

    public void setPackageOption(String modifier, String tags) {
        this.PACKAGE_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = modifier;
        this.PACKAGE_OPTIONS.REQUIRED_TAGS = tags;
    }

    public void registerAdditionalTag(@NotNull String tag) {
        if (tag == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(0);
        }
        this.myAdditionalJavadocTags = !this.myAdditionalJavadocTags.isEmpty() ? this.myAdditionalJavadocTags + "," + tag : tag;
    }

    public boolean isIgnoreDuplicatedThrows() {
        return this.myIgnoreDuplicatedThrows;
    }

    public void setIgnoreDuplicatedThrows(boolean ignoreDuplicatedThrows) {
        this.myIgnoreDuplicatedThrows = ignoreDuplicatedThrows;
    }

    public void setIgnoreEmptyDescriptions(boolean ignoreEmptyDescriptions) {
        this.myIgnoreEmptyDescriptions = ignoreEmptyDescriptions;
    }

    public boolean isIgnoreSimpleAccessors() {
        return this.myIgnoreSimpleAccessors;
    }

    public void setIgnoreSimpleAccessors(boolean ignoreSimpleAccessors) {
        this.myIgnoreSimpleAccessors = ignoreSimpleAccessors;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(1);
        }
        super.writeSettings(node);
        if (this.myIgnoreSimpleAccessors) {
            JDOMExternalizerUtil.writeCustomField(node, IGNORE_ACCESSORS_ATTR_NAME, String.valueOf(true));
        }
        if (!this.myIgnoreDuplicatedThrows) {
            JDOMExternalizerUtil.writeCustomField(node, IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME, String.valueOf(false));
        }
        if (this.MODULE_OPTIONS.isModified()) {
            this.MODULE_OPTIONS.writeExternal(JDOMExternalizerUtil.writeOption(node, MODULE_OPTIONS_TAG_NAME));
        }
        if (this.PACKAGE_OPTIONS.isModified()) {
            this.PACKAGE_OPTIONS.writeExternal(node);
        }
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        Element moduleOptions;
        String ignoreDuplicatedThrows;
        if (node == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(2);
        }
        super.readSettings(node);
        String ignoreAccessors = JDOMExternalizerUtil.readCustomField(node, IGNORE_ACCESSORS_ATTR_NAME);
        if (ignoreAccessors != null) {
            this.myIgnoreSimpleAccessors = Boolean.parseBoolean(ignoreAccessors);
        }
        if ((ignoreDuplicatedThrows = JDOMExternalizerUtil.readCustomField(node, IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME)) != null) {
            this.myIgnoreDuplicatedThrows = Boolean.parseBoolean(ignoreDuplicatedThrows);
        }
        if ((moduleOptions = JDOMExternalizerUtil.readOption(node, MODULE_OPTIONS_TAG_NAME)) != null) {
            this.MODULE_OPTIONS.readExternal(moduleOptions);
        }
        this.PACKAGE_OPTIONS.readExternal(node);
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitJavaFile(PsiJavaFile file) {
                if ("package-info.java".equals(file.getName())) {
                    JavaDocLocalInspectionBase.this.checkFile(file, holder, isOnTheFly);
                }
            }

            @Override
            public void visitModule(PsiJavaModule module) {
                JavaDocLocalInspectionBase.this.checkModule(module, holder, isOnTheFly);
            }

            @Override
            public void visitClass(PsiClass aClass) {
                JavaDocLocalInspectionBase.this.checkClass(aClass, holder, isOnTheFly);
            }

            @Override
            public void visitField(PsiField field) {
                JavaDocLocalInspectionBase.this.checkField(field, holder, isOnTheFly);
            }

            @Override
            public void visitMethod(PsiMethod method) {
                JavaDocLocalInspectionBase.this.checkMethod(method, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    private void checkFile(PsiJavaFile file, ProblemsHolder delegate, boolean isOnTheFly) {
        PsiPackage pkg = JavaDirectoryService.getInstance().getPackage(file.getContainingDirectory());
        if (pkg == null) {
            return;
        }
        PsiDocComment docComment = PsiTreeUtil.getChildOfType(file, PsiDocComment.class);
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspectionBase.isDeprecated(pkg, docComment)) {
            return;
        }
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, pkg);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            PsiDocTag[] tags = docComment.getTags();
            this.checkBasics(docComment, tags, pkg, required, this.PACKAGE_OPTIONS, holder);
        } else if (required) {
            PsiElement toHighlight = ObjectUtils.notNull(file.getPackageStatement(), file);
            JavadocHighlightUtil.reportMissingTag(toHighlight, holder);
        }
    }

    private void checkModule(PsiJavaModule module, ProblemsHolder delegate, boolean isOnTheFly) {
        PsiDocComment docComment = module.getDocComment();
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspectionBase.isDeprecated(module, docComment)) {
            return;
        }
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, module);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            this.checkBasics(docComment, docComment.getTags(), module, required, this.MODULE_OPTIONS, holder);
        } else if (required) {
            JavadocHighlightUtil.reportMissingTag(module.getNameIdentifier(), holder);
        }
    }

    private void checkClass(PsiClass aClass, ProblemsHolder delegate, boolean isOnTheFly) {
        if (aClass instanceof PsiAnonymousClass || aClass instanceof PsiSyntheticClass || aClass instanceof PsiTypeParameter) {
            return;
        }
        if (this.IGNORE_DEPRECATED && aClass.isDeprecated()) {
            return;
        }
        PsiDocComment docComment = aClass.getDocComment();
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, aClass);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            PsiDocTag[] tags = docComment.getTags();
            Options options = ClassUtil.isTopLevelClass(aClass) ? this.TOP_LEVEL_CLASS_OPTIONS : this.INNER_CLASS_OPTIONS;
            this.checkBasics(docComment, tags, aClass, required, options, holder);
            if (required && JavaDocLocalInspectionBase.isTagRequired(options, "param")) {
                JavadocHighlightUtil.checkMissingTypeParamTags(aClass, tags, docComment.getFirstChild(), holder);
            }
        } else if (required) {
            PsiElement toHighlight = ObjectUtils.notNull(aClass.getNameIdentifier(), aClass);
            JavadocHighlightUtil.reportMissingTag(toHighlight, holder);
        }
    }

    private void checkField(PsiField field, ProblemsHolder delegate, boolean isOnTheFly) {
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspectionBase.isDeprecated(field)) {
            return;
        }
        PsiDocComment docComment = field.getDocComment();
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, field);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            this.checkBasics(docComment, docComment.getTags(), field, required, this.FIELD_OPTIONS, holder);
        } else if (required) {
            JavadocHighlightUtil.reportMissingTag(field.getNameIdentifier(), holder);
        }
    }

    private void checkMethod(PsiMethod method, ProblemsHolder delegate, boolean isOnTheFly) {
        ExtensionPoint ep;
        PsiIdentifier nameIdentifier;
        if (method instanceof SyntheticElement) {
            return;
        }
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspectionBase.isDeprecated(method)) {
            return;
        }
        if (this.myIgnoreSimpleAccessors && PropertyUtilBase.isSimplePropertyAccessor(method)) {
            return;
        }
        PsiDocComment docComment = method.getDocComment();
        boolean hasSupers = method.findSuperMethods().length > 0;
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, method);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            if (!JavaDocLocalInspectionBase.isInherited(docComment, method)) {
                PsiDocTag[] tags = docComment.getTags();
                if (required && !hasSupers) {
                    if (JavaDocLocalInspectionBase.isTagRequired(this.METHOD_OPTIONS, "return")) {
                        JavadocHighlightUtil.checkMissingReturnTag(tags, method, docComment.getFirstChild(), holder);
                    }
                    if (JavaDocLocalInspectionBase.isTagRequired(this.METHOD_OPTIONS, "param")) {
                        JavadocHighlightUtil.checkMissingParamTags(tags, method, docComment.getFirstChild(), holder);
                    }
                    if (JavaDocLocalInspectionBase.isTagRequired(this.METHOD_OPTIONS, "throws")) {
                        JavadocHighlightUtil.checkMissingThrowsTags(tags, method, docComment.getFirstChild(), holder);
                    }
                }
                if (!this.myIgnoreEmptyDescriptions) {
                    JavadocHighlightUtil.checkEmptyMethodTagsDescription(tags, holder);
                }
                this.checkBasics(docComment, tags, method, false, this.METHOD_OPTIONS, holder);
            }
        } else if (required && !hasSupers && (nameIdentifier = method.getNameIdentifier()) != null && Stream.of((ep = Extensions.getRootArea().getExtensionPoint("com.intellij.javaDocNotNecessary")).getExtensions()).noneMatch(condition -> condition.value(method))) {
            JavadocHighlightUtil.reportMissingTag(nameIdentifier, holder);
        }
    }

    private void checkBasics(PsiDocComment docComment, PsiDocTag[] tags, PsiElement context, boolean required, Options options, ProblemHolderImpl holder) {
        if (required) {
            JavadocHighlightUtil.checkRequiredTags(tags, options, docComment.getFirstChild(), holder);
        }
        JavadocHighlightUtil.checkRequiredTagDescriptions(tags, holder);
        JavadocHighlightUtil.checkTagValues(tags, context, holder);
        if (!this.IGNORE_JAVADOC_PERIOD) {
            JavadocHighlightUtil.checkForPeriod(docComment, context, holder);
        }
        JavadocHighlightUtil.checkInlineTags(docComment.getDescriptionElements(), holder);
        JavadocHighlightUtil.checkForBadCharacters(docComment, holder);
        JavadocHighlightUtil.checkDuplicateTags(tags, holder);
    }

    private static boolean isDeprecated(PsiModifierListOwner element, PsiDocComment docComment) {
        return PsiImplUtil.isDeprecatedByAnnotation(element) || docComment != null && docComment.findTagByName("deprecated") != null;
    }

    protected static boolean isTagRequired(Options options, String tag) {
        return options.REQUIRED_TAGS.contains(tag);
    }

    private static boolean isDeprecated(PsiDocCommentOwner element) {
        return element.isDeprecated() || element.getContainingClass() != null && element.getContainingClass().isDeprecated();
    }

    private static boolean isInherited(PsiDocComment docComment, PsiMethod psiMethod) {
        JavadocTagInfo tagInfo;
        for (PsiElement descriptionElement : docComment.getDescriptionElements()) {
            if (!(descriptionElement instanceof PsiInlineDocTag) || !"inheritDoc".equals(((PsiInlineDocTag)descriptionElement).getName())) continue;
            return true;
        }
        return docComment.findTagByName("inheritDoc") != null && (tagInfo = JavadocManager.SERVICE.getInstance(psiMethod.getProject()).getTagInfo("inheritDoc")) != null && tagInfo.isValidInContext(psiMethod);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.javadoc.display.name", new Object[0]);
        if (string == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message("group.names.javadoc.issues", new Object[0]);
        if (string == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(7);
        }
        return SHORT_NAME;
    }

    @Override
    @Nullable
    public String getAlternativeID() {
        return "javadoc";
    }

    protected LocalQuickFix createAddJavadocFix(@NotNull PsiElement nameIdentifier, boolean isOnTheFly) {
        if (nameIdentifier == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(8);
        }
        return null;
    }

    protected LocalQuickFix createAddMissingTagFix(@NotNull String tag, @NotNull String value, boolean isOnTheFly) {
        if (tag == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(9);
        }
        if (value == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(10);
        }
        return null;
    }

    protected LocalQuickFix createAddMissingParamTagFix(@NotNull String name, boolean isOnTheFly) {
        if (name == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(11);
        }
        return null;
    }

    protected LocalQuickFix createRegisterTagFix(@NotNull String tag, boolean isOnTheFly) {
        if (tag == null) {
            JavaDocLocalInspectionBase.$$$reportNull$$$0(12);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAddJavadocFix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAddMissingTagFix";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAddMissingParamTagFix";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRegisterTagFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProblemHolderImpl
    implements JavadocHighlightUtil.ProblemHolder {
        private final ProblemsHolder myHolder;
        private final boolean myOnTheFly;

        private ProblemHolderImpl(ProblemsHolder holder, boolean onTheFly) {
            this.myHolder = holder;
            this.myOnTheFly = onTheFly;
        }

        @Override
        public Project project() {
            return this.myHolder.getManager().getProject();
        }

        @Override
        public JavaDocLocalInspectionBase inspection() {
            return JavaDocLocalInspectionBase.this;
        }

        @Override
        public void problem(@NotNull PsiElement toHighlight, @NotNull @Nls String message, @Nullable LocalQuickFix fix) {
            if (toHighlight == null) {
                ProblemHolderImpl.$$$reportNull$$$0(0);
            }
            if (message == null) {
                ProblemHolderImpl.$$$reportNull$$$0(1);
            }
            this.myHolder.registerProblem(this.myHolder.getManager().createProblemDescriptor(toHighlight, message, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly));
        }

        @Override
        public void eolProblem(@NotNull PsiElement toHighlight, @NotNull @Nls String message, @Nullable LocalQuickFix fix) {
            LocalQuickFix[] localQuickFixArray;
            if (toHighlight == null) {
                ProblemHolderImpl.$$$reportNull$$$0(2);
            }
            if (message == null) {
                ProblemHolderImpl.$$$reportNull$$$0(3);
            }
            if (fix != null) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = fix;
            } else {
                localQuickFixArray = null;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.myHolder.registerProblem(this.myHolder.getManager().createProblemDescriptor(toHighlight, message, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, true));
        }

        @Override
        public LocalQuickFix addJavadocFix(@NotNull PsiElement nameIdentifier) {
            if (nameIdentifier == null) {
                ProblemHolderImpl.$$$reportNull$$$0(4);
            }
            return JavaDocLocalInspectionBase.this.createAddJavadocFix(nameIdentifier, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix addMissingTagFix(@NotNull String tag, @NotNull String value) {
            if (tag == null) {
                ProblemHolderImpl.$$$reportNull$$$0(5);
            }
            if (value == null) {
                ProblemHolderImpl.$$$reportNull$$$0(6);
            }
            return JavaDocLocalInspectionBase.this.createAddMissingTagFix(tag, value, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix addMissingParamTagFix(@NotNull String name) {
            if (name == null) {
                ProblemHolderImpl.$$$reportNull$$$0(7);
            }
            return JavaDocLocalInspectionBase.this.createAddMissingParamTagFix(name, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix registerTagFix(@NotNull String tag) {
            if (tag == null) {
                ProblemHolderImpl.$$$reportNull$$$0(8);
            }
            return JavaDocLocalInspectionBase.this.createRegisterTagFix(tag, this.myOnTheFly);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toHighlight";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIdentifier";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$ProblemHolderImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problem";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "eolProblem";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addJavadocFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMissingTagFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMissingParamTagFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerTagFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Options
    implements JDOMExternalizable {
        public String ACCESS_JAVADOC_REQUIRED_FOR = "none";
        public String REQUIRED_TAGS = "";

        public Options() {
        }

        public Options(String accessJavadocRequiredFor, String requiredTags) {
            this.ACCESS_JAVADOC_REQUIRED_FOR = accessJavadocRequiredFor;
            this.REQUIRED_TAGS = requiredTags;
        }

        @Override
        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal(this, element);
        }

        @Override
        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal(this, element);
        }

        private boolean isModified() {
            return !this.ACCESS_JAVADOC_REQUIRED_FOR.equals(JavaDocLocalInspectionBase.NONE) || !this.REQUIRED_TAGS.isEmpty();
        }
    }
}

