/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationInMessageFormatCallInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.message.format.call.display.name", new Object[0]);
        if (string == null) {
            StringConcatenationInMessageFormatCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.message.format.call.problem.descriptor", new Object[0]);
        if (string == null) {
            StringConcatenationInMessageFormatCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)infos[0];
        String referenceName = referenceExpression.getReferenceName();
        return new StringConcatenationInFormatCallFix(referenceName);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInMessageFormatCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/StringConcatenationInMessageFormatCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StringConcatenationInMessageFormatCallVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInMessageFormatCallVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (!StringConcatenationInMessageFormatCallVisitor.isMessageFormatCall(expression)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            PsiType type = firstArgument.getType();
            if (type == null) {
                return;
            }
            int formatArgumentIndex = "java.util.Locale".equals(type.getCanonicalText()) && arguments.length > 1 ? 1 : 0;
            PsiExpression formatArgument = arguments[formatArgumentIndex];
            PsiType formatArgumentType = formatArgument.getType();
            if (formatArgumentType == null || !formatArgumentType.equalsToText("java.lang.String")) {
                return;
            }
            if (!(formatArgument instanceof PsiBinaryExpression)) {
                return;
            }
            if (PsiUtil.isConstantExpression(formatArgument)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)formatArgument;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiType lhsType = lhs.getType();
            if (lhsType == null || !lhsType.equalsToText("java.lang.String")) {
                return;
            }
            PsiExpression rhs = binaryExpression.getROperand();
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            this.registerError((PsiElement)formatArgument, rhs);
        }

        private static boolean isMessageFormatCall(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"format".equals(referenceName)) {
                return false;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiClass)) {
                return false;
            }
            PsiClass aClass = (PsiClass)target;
            return InheritanceUtil.isInheritor(aClass, "java.text.MessageFormat");
        }
    }

    private static class StringConcatenationInFormatCallFix
    extends InspectionGadgetsFix {
        private final String variableName;

        public StringConcatenationInFormatCallFix(String variableName) {
            this.variableName = variableName;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.in.format.call.quickfix", this.variableName);
            if (string == null) {
                StringConcatenationInFormatCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace concatenation with argument" == null) {
                StringConcatenationInFormatCallFix.$$$reportNull$$$0(1);
            }
            return "Replace concatenation with argument";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
            PsiElement parent = binaryExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiExpression[] expressions = expressionList.getExpressions();
            int parameter = expressions.length - 1;
            expressionList.add(rhs);
            Object constant = ExpressionUtils.computeConstantExpression(lhs);
            if (constant instanceof String) {
                PsiExpression newExpression = StringConcatenationInFormatCallFix.addParameter(lhs, parameter);
                if (newExpression == null) {
                    expressionList.addAfter(lhs, binaryExpression);
                } else {
                    expressionList.addAfter(newExpression, binaryExpression);
                }
            } else {
                expressionList.addAfter(lhs, binaryExpression);
            }
            binaryExpression.delete();
        }

        @Nullable
        private static PsiExpression addParameter(PsiExpression expression, int parameterNumber) {
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) {
                    return null;
                }
                PsiExpression newExpression = StringConcatenationInFormatCallFix.addParameter(rhs, parameterNumber);
                if (newExpression == null) {
                    return null;
                }
                rhs.replace(newExpression);
                return expression;
            }
            if (expression instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
                Object value = literalExpression.getValue();
                if (!(value instanceof String)) {
                    return null;
                }
                Project project = expression.getProject();
                PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
                return factory.createExpressionFromText("\"" + value + '{' + parameterNumber + "}\"", null);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/StringConcatenationInMessageFormatCallInspection$StringConcatenationInFormatCallFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

