/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import com.siyeh.ig.ui.ExternalizableStringSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilityClassWithoutPrivateConstructorInspectionBase
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);
    public boolean ignoreClassesWithOnlyMain = false;

    @Nullable
    static PsiMethod getNullArgConstructor(PsiClass aClass) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = aClass.getConstructors()) {
            PsiParameterList params = constructor.getParameterList();
            if (params.getParametersCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("utility.class.without.private.constructor.display.name", new Object[0]);
        if (string == null) {
            UtilityClassWithoutPrivateConstructorInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("utility.class.without.private.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            UtilityClassWithoutPrivateConstructorInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UtilityClassWithoutPrivateConstructorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UtilityClassWithoutPrivateConstructorVisitor
    extends BaseInspectionVisitor {
        private UtilityClassWithoutPrivateConstructorVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                UtilityClassWithoutPrivateConstructorVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!UtilityClassUtil.isUtilityClass(aClass)) {
                return;
            }
            if (UtilityClassWithoutPrivateConstructorInspectionBase.this.ignoreClassesWithOnlyMain && this.hasOnlyMain(aClass)) {
                return;
            }
            if (this.hasPrivateConstructor(aClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated(aClass, UtilityClassWithoutPrivateConstructorInspectionBase.this.ignorableAnnotations)) {
                return;
            }
            if (aClass.hasModifierProperty("private") && aClass.getConstructors().length == 0) {
                return;
            }
            GlobalSearchScope scope = GlobalSearchScope.projectScope(aClass.getProject());
            Query<PsiClass> query = ClassInheritorsSearch.search(aClass, scope, true);
            PsiClass subclass = query.findFirst();
            if (subclass != null) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private boolean hasOnlyMain(PsiClass aClass) {
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length == 0) {
                return false;
            }
            for (PsiMethod method : methods) {
                if (method.isConstructor()) continue;
                if (!method.hasModifierProperty("static")) {
                    return false;
                }
                if (method.hasModifierProperty("private")) continue;
                if (!method.hasModifierProperty("public")) {
                    return false;
                }
                String name = method.getName();
                if (!name.equals("main")) {
                    return false;
                }
                PsiType returnType = method.getReturnType();
                if (!PsiType.VOID.equals(returnType)) {
                    return false;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 1) {
                    return false;
                }
                PsiParameter[] parameters = parameterList.getParameters();
                PsiParameter parameter = parameters[0];
                PsiType type = parameter.getType();
                if (type.equalsToText("java.lang.String[]")) continue;
                return false;
            }
            return true;
        }

        boolean hasPrivateConstructor(PsiClass aClass) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                if (!constructor.hasModifierProperty("private")) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspectionBase$UtilityClassWithoutPrivateConstructorVisitor", "visitClass"));
        }
    }
}

