/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseCompareMethodInspection
extends AbstractBaseJavaLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UseCompareMethodInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.getLanguageLevel(holder.getFile()).isAtLeast(LanguageLevel.JDK_1_4)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                UseCompareMethodInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                CompareInfo info = UseCompareMethodInspection.fromCall(call);
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (info != null && nameElement != null) {
                    this.register(info, nameElement);
                }
            }

            @Override
            public void visitIfStatement(PsiIfStatement statement) {
                CompareInfo info = UseCompareMethodInspection.fromIf(statement);
                PsiElement keyword = statement.getFirstChild();
                if (info != null && keyword != null) {
                    this.register(info, keyword);
                }
            }

            @Override
            public void visitConditionalExpression(PsiConditionalExpression expression) {
                CompareInfo info = UseCompareMethodInspection.fromTernary(expression);
                if (info != null) {
                    this.register(info, expression);
                }
            }

            private void register(CompareInfo info, PsiElement nameElement) {
                holder.registerProblem(nameElement, "Can be replaced with '" + info.myClass.getClassName() + ".compare'", new ReplaceWithPrimitiveCompareFix(info.myClass.getCanonicalText()));
            }
        };
        if (javaElementVisitor == null) {
            UseCompareMethodInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static CompareInfo fromIf(PsiIfStatement ifStatement) {
        PsiExpression firstCondition = ifStatement.getCondition();
        if (firstCondition == null) {
            return null;
        }
        PsiIfStatement elseIfStatement = ObjectUtils.tryCast(UseCompareMethodInspection.getElse(ifStatement), PsiIfStatement.class);
        if (elseIfStatement == null) {
            return null;
        }
        PsiExpression secondCondition = elseIfStatement.getCondition();
        if (secondCondition == null) {
            return null;
        }
        PsiStatement firstStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (firstStatement == null) {
            return null;
        }
        PsiStatement secondStatement = ControlFlowUtils.stripBraces(elseIfStatement.getThenBranch());
        if (secondStatement == null) {
            return null;
        }
        PsiStatement thirdStatement = UseCompareMethodInspection.getElse(elseIfStatement);
        if (thirdStatement == null) {
            return null;
        }
        HashMap<Integer, PsiExpression> result = new HashMap<Integer, PsiExpression>(3);
        if (firstStatement instanceof PsiReturnStatement) {
            if (!(secondStatement instanceof PsiReturnStatement) || !(thirdStatement instanceof PsiReturnStatement)) {
                return null;
            }
            PsiExpression firstValue = ((PsiReturnStatement)firstStatement).getReturnValue();
            if (!UseCompareMethodInspection.storeCondition(result, firstCondition, firstValue)) {
                return null;
            }
            if (!UseCompareMethodInspection.storeCondition(result, secondCondition, ((PsiReturnStatement)secondStatement).getReturnValue())) {
                return null;
            }
            if (!UseCompareMethodInspection.storeCondition(result, null, ((PsiReturnStatement)thirdStatement).getReturnValue())) {
                return null;
            }
            return UseCompareMethodInspection.fromMap(result, firstValue, firstStatement);
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(firstStatement);
        if (assignment == null) {
            return null;
        }
        PsiReferenceExpression ref = ObjectUtils.tryCast(assignment.getLExpression(), PsiReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        PsiVariable variable = ObjectUtils.tryCast(ref.resolve(), PsiVariable.class);
        if (variable == null) {
            return null;
        }
        PsiExpression firstExpression = assignment.getRExpression();
        if (!UseCompareMethodInspection.storeCondition(result, firstCondition, firstExpression)) {
            return null;
        }
        if (!UseCompareMethodInspection.storeCondition(result, secondCondition, ExpressionUtils.getAssignmentTo(secondStatement, variable))) {
            return null;
        }
        if (!UseCompareMethodInspection.storeCondition(result, null, ExpressionUtils.getAssignmentTo(thirdStatement, variable))) {
            return null;
        }
        return UseCompareMethodInspection.fromMap(result, firstExpression, assignment);
    }

    private static PsiStatement getElse(PsiIfStatement ifStatement) {
        PsiStatement branch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        if (branch != null) {
            return branch;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenBranch instanceof PsiReturnStatement)) {
            return null;
        }
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward(ifStatement);
        return ObjectUtils.tryCast(next, PsiStatement.class);
    }

    @Nullable
    private static Map<Integer, PsiExpression> extractConditions(PsiConditionalExpression ternary) {
        HashMap<Integer, PsiExpression> result = new HashMap<Integer, PsiExpression>(3);
        if (!UseCompareMethodInspection.storeCondition(result, ternary.getCondition(), ternary.getThenExpression())) {
            return null;
        }
        PsiExpression elseExpression = PsiUtil.skipParenthesizedExprDown(ternary.getElseExpression());
        if (elseExpression instanceof PsiConditionalExpression) {
            Map<Integer, PsiExpression> m = UseCompareMethodInspection.extractConditions((PsiConditionalExpression)elseExpression);
            if (m == null) {
                return null;
            }
            result.putAll(m);
            return result;
        }
        return UseCompareMethodInspection.storeCondition(result, null, elseExpression) ? result : null;
    }

    @Contract(value="_, _, null -> false")
    private static boolean storeCondition(@NotNull Map<Integer, PsiExpression> result, @Nullable PsiExpression condition, @Nullable PsiExpression expression) {
        if (result == null) {
            UseCompareMethodInspection.$$$reportNull$$$0(3);
        }
        if (expression == null) {
            return false;
        }
        Object thenValue = ExpressionUtils.computeConstantExpression(expression);
        if (!(thenValue instanceof Integer) || Math.abs((Integer)thenValue) > 1) {
            return false;
        }
        result.put((Integer)thenValue, condition);
        return true;
    }

    private static CompareInfo fromTernary(PsiConditionalExpression ternary) {
        if (!PsiType.INT.equals(ternary.getType())) {
            return null;
        }
        Map<Integer, PsiExpression> map = UseCompareMethodInspection.extractConditions(ternary);
        return UseCompareMethodInspection.fromMap(map, ternary, ternary);
    }

    private static CompareInfo fromMap(@Nullable Map<Integer, PsiExpression> map, @NotNull PsiExpression expression, @NotNull PsiElement template) {
        if (expression == null) {
            UseCompareMethodInspection.$$$reportNull$$$0(4);
        }
        if (template == null) {
            UseCompareMethodInspection.$$$reportNull$$$0(5);
        }
        if (map == null || map.size() != 3) {
            return null;
        }
        PsiExpression lt = map.get(-1);
        Pair<PsiExpression, PsiExpression> ltPair = UseCompareMethodInspection.getOperands(lt, JavaTokenType.LT);
        if (lt != null && ltPair == null) {
            return null;
        }
        PsiExpression gt = map.get(1);
        Pair<PsiExpression, PsiExpression> gtPair = UseCompareMethodInspection.getOperands(gt, JavaTokenType.GT);
        if ((gt != null || ltPair == null) && gtPair == null) {
            return null;
        }
        if (ltPair != null && gtPair != null) {
            if (!PsiEquivalenceUtil.areElementsEquivalent(ltPair.getFirst(), gtPair.getFirst())) {
                return null;
            }
            if (!PsiEquivalenceUtil.areElementsEquivalent(ltPair.getSecond(), gtPair.getSecond())) {
                return null;
            }
        }
        Pair<PsiExpression, PsiExpression> canonicalPair = ltPair == null ? gtPair : ltPair;
        PsiType leftType = canonicalPair.getFirst().getType();
        PsiType rightType = canonicalPair.getSecond().getType();
        if (!UseCompareMethodInspection.isTypeConvertible(leftType, expression) || !leftType.equals(rightType)) {
            return null;
        }
        PsiExpression eq = map.get(0);
        Pair<PsiExpression, PsiExpression> eqPair = UseCompareMethodInspection.getOperands(eq, JavaTokenType.EQEQ);
        if (eq != null && eqPair == null) {
            return null;
        }
        if (!(eqPair == null || PsiEquivalenceUtil.areElementsEquivalent(canonicalPair.getFirst(), eqPair.getFirst()) && PsiEquivalenceUtil.areElementsEquivalent(canonicalPair.getSecond(), eqPair.getSecond()) || PsiEquivalenceUtil.areElementsEquivalent(canonicalPair.getFirst(), eqPair.getSecond()) && PsiEquivalenceUtil.areElementsEquivalent(canonicalPair.getSecond(), eqPair.getFirst()))) {
            return null;
        }
        PsiClassType boxedType = ((PsiPrimitiveType)leftType).getBoxedType(expression);
        if (boxedType == null) {
            return null;
        }
        return new CompareInfo(template, expression, canonicalPair.getFirst(), canonicalPair.getSecond(), boxedType);
    }

    private static Pair<PsiExpression, PsiExpression> getOperands(PsiExpression expression, IElementType expectedToken) {
        if (!((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)expression;
        PsiExpression left = PsiUtil.skipParenthesizedExprDown(binOp.getLOperand());
        PsiExpression right = PsiUtil.skipParenthesizedExprDown(binOp.getROperand());
        if (left == null || right == null) {
            return null;
        }
        if (binOp.getOperationTokenType().equals(expectedToken)) {
            return Pair.create(left, right);
        }
        if (expectedToken.equals(JavaTokenType.GT) && binOp.getOperationTokenType().equals(JavaTokenType.LT) || expectedToken.equals(JavaTokenType.LT) && binOp.getOperationTokenType().equals(JavaTokenType.GT)) {
            return Pair.create(right, left);
        }
        return null;
    }

    @Contract(value="null -> null")
    private static CompareInfo fromCall(PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
        if (nameElement == null) {
            return null;
        }
        String name = nameElement.getText();
        if (!"compareTo".equals(name)) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return null;
        }
        PsiExpression arg = args[0];
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiClassType boxedType = UseCompareMethodInspection.getBoxedType(call);
        if (boxedType == null) {
            return null;
        }
        PsiPrimitiveType primitiveType = PsiPrimitiveType.getUnboxedType(boxedType);
        if (!UseCompareMethodInspection.isTypeConvertible(primitiveType, call)) {
            return null;
        }
        PsiExpression left = UseCompareMethodInspection.extractPrimitive(boxedType, primitiveType, qualifier);
        if (left == null) {
            return null;
        }
        PsiExpression right = UseCompareMethodInspection.extractPrimitive(boxedType, primitiveType, arg);
        if (right == null) {
            return null;
        }
        return new CompareInfo(call, call, left, right, boxedType);
    }

    @Nullable
    static PsiClassType getBoxedType(PsiMethodCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory(call.getProject()).createType(aClass);
    }

    @Nullable
    static PsiExpression extractPrimitive(PsiClassType type, PsiPrimitiveType primitiveType, PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) == null) {
            return null;
        }
        if (primitiveType.equals(expression.getType())) {
            return expression;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (!"valueOf".equals(call.getMethodExpression().getReferenceName())) {
                return null;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null || type.resolve() != method.getContainingClass()) {
                return null;
            }
            return UseCompareMethodInspection.checkPrimitive(args[0]);
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression cast = (PsiTypeCastExpression)expression;
            if (!type.equals(cast.getType())) {
                return null;
            }
            return UseCompareMethodInspection.checkPrimitive(cast.getOperand());
        }
        if (expression instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            if (!type.equals(newExpression.getType())) {
                return null;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1) {
                return null;
            }
            if (!(args[0].getType() instanceof PsiPrimitiveType)) {
                return null;
            }
            return UseCompareMethodInspection.checkPrimitive(args[0]);
        }
        return null;
    }

    private static PsiExpression checkPrimitive(PsiExpression expression) {
        return expression != null && expression.getType() instanceof PsiPrimitiveType ? expression : null;
    }

    @Contract(value="null, _ -> false")
    private static boolean isTypeConvertible(PsiType type, PsiElement context) {
        return type instanceof PsiPrimitiveType && (PsiType.DOUBLE.equals(type) || PsiType.FLOAT.equals(type) || PsiUtil.isLanguageLevel7OrHigher(context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/UseCompareMethodInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/UseCompareMethodInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "storeCondition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithPrimitiveCompareFix
    implements LocalQuickFix {
        private String myClassName;

        public ReplaceWithPrimitiveCompareFix(String className) {
            this.myClassName = className;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with '" + StringUtil.getShortName(this.myClassName) + ".compare'";
            if (string == null) {
                ReplaceWithPrimitiveCompareFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with static 'compare' method" == null) {
                ReplaceWithPrimitiveCompareFix.$$$reportNull$$$0(1);
            }
            return "Replace with static 'compare' method";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            CompareInfo info;
            PsiElement toReplace;
            if (project == null) {
                ReplaceWithPrimitiveCompareFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ReplaceWithPrimitiveCompareFix.$$$reportNull$$$0(3);
            }
            PsiElement element = descriptor.getStartElement();
            ArrayList<PsiStatement> toDelete = new ArrayList<PsiStatement>();
            if (element instanceof PsiConditionalExpression) {
                toReplace = element;
                info = UseCompareMethodInspection.fromTernary((PsiConditionalExpression)element);
            } else {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiIfStatement) {
                    toReplace = parent;
                    info = UseCompareMethodInspection.fromIf((PsiIfStatement)parent);
                    PsiStatement elseIf = UseCompareMethodInspection.getElse((PsiIfStatement)parent);
                    toDelete.add(elseIf);
                    if (elseIf instanceof PsiIfStatement) {
                        toDelete.add(UseCompareMethodInspection.getElse((PsiIfStatement)elseIf));
                    }
                } else {
                    PsiMethodCallExpression call = PsiTreeUtil.getParentOfType(element, PsiMethodCallExpression.class);
                    info = UseCompareMethodInspection.fromCall(call);
                    toReplace = call;
                }
            }
            if (info == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            info.replace(toReplace, ct);
            ((StreamEx)StreamEx.of(toDelete).nonNull().filter(PsiElement::isValid)).forEach(e -> new CommentTracker().deleteAndRestoreComments((PsiElement)e));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/UseCompareMethodInspection$ReplaceWithPrimitiveCompareFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/UseCompareMethodInspection$ReplaceWithPrimitiveCompareFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CompareInfo {
        @NotNull
        final PsiElement myTemplate;
        @NotNull
        final PsiExpression myToReplace;
        @NotNull
        final PsiExpression myLeft;
        @NotNull
        final PsiExpression myRight;
        @NotNull
        final PsiClassType myClass;

        CompareInfo(@NotNull PsiElement template, @NotNull PsiExpression toReplace, @NotNull PsiExpression left, @NotNull PsiExpression right, @NotNull PsiClassType aClass) {
            if (template == null) {
                CompareInfo.$$$reportNull$$$0(0);
            }
            if (toReplace == null) {
                CompareInfo.$$$reportNull$$$0(1);
            }
            if (left == null) {
                CompareInfo.$$$reportNull$$$0(2);
            }
            if (right == null) {
                CompareInfo.$$$reportNull$$$0(3);
            }
            if (aClass == null) {
                CompareInfo.$$$reportNull$$$0(4);
            }
            this.myTemplate = template;
            this.myToReplace = toReplace;
            this.myLeft = left;
            this.myRight = right;
            this.myClass = aClass;
        }

        private void replace(PsiElement toReplace, CommentTracker ct) {
            String replacement = this.myClass.getCanonicalText() + ".compare(" + ct.text(this.myLeft) + "," + ct.text(this.myRight) + ")";
            if (toReplace == this.myTemplate) {
                ct.replaceAndRestoreComments((PsiElement)this.myToReplace, replacement);
            } else {
                ct.replace((PsiElement)this.myToReplace, replacement);
                ct.replaceAndRestoreComments(toReplace, this.myTemplate);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "template";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "toReplace";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "left";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "right";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/UseCompareMethodInspection$CompareInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

