/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ColorGenerator {
    @NotNull
    public static List<Color> generateLinearColorSequence(@NotNull List<Color> anchorColors, int colorsBetweenAnchors) {
        if (anchorColors == null) {
            ColorGenerator.$$$reportNull$$$0(0);
        }
        assert (colorsBetweenAnchors >= 0);
        if (anchorColors.isEmpty()) {
            List<Color> list = Collections.singletonList(JBColor.GRAY);
            if (list == null) {
                ColorGenerator.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (anchorColors.size() == 1) {
            List<Color> list = Collections.singletonList(anchorColors.get(0));
            if (list == null) {
                ColorGenerator.$$$reportNull$$$0(2);
            }
            return list;
        }
        int segmentCount = anchorColors.size() - 1;
        ArrayList<Color> result = new ArrayList<Color>(anchorColors.size() + segmentCount * colorsBetweenAnchors);
        result.add(anchorColors.get(0));
        for (int i = 0; i < segmentCount; ++i) {
            Color color1 = anchorColors.get(i);
            Color color2 = anchorColors.get(i + 1);
            List<Color> linearColors = ColorGenerator.generateLinearColorSequence(color1, color2, colorsBetweenAnchors);
            result.addAll(linearColors.subList(1, linearColors.size()));
        }
        ArrayList<Color> arrayList = result;
        if (arrayList == null) {
            ColorGenerator.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static List<Color> generateLinearColorSequence(@NotNull Color color1, @NotNull Color color2, int colorsBetweenAnchors) {
        if (color1 == null) {
            ColorGenerator.$$$reportNull$$$0(4);
        }
        if (color2 == null) {
            ColorGenerator.$$$reportNull$$$0(5);
        }
        assert (colorsBetweenAnchors >= 0);
        ArrayList<Color> result = new ArrayList<Color>(colorsBetweenAnchors + 2);
        result.add(color1);
        for (int i = 1; i <= colorsBetweenAnchors; ++i) {
            float ratio = (float)i / (float)(colorsBetweenAnchors + 1);
            result.add(new Color(ColorGenerator.ratio(color1.getRed(), color2.getRed(), ratio), ColorGenerator.ratio(color1.getGreen(), color2.getGreen(), ratio), ColorGenerator.ratio(color1.getBlue(), color2.getBlue(), ratio)));
        }
        result.add(color2);
        ArrayList<Color> arrayList = result;
        if (arrayList == null) {
            ColorGenerator.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static int ratio(int val1, int val2, float ratio) {
        int value = (int)((float)val1 + (float)(val2 - val1) * ratio);
        return Math.max(Math.min(value, 255), 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorColors";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeHighlighting/ColorGenerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeHighlighting/ColorGenerator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLinearColorSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateLinearColorSequence";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

