/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultHighlightUtil {
    @Nullable
    public static HighlightInfo checkBadCharacter(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            DefaultHighlightUtil.$$$reportNull$$$0(0);
        }
        if ((node = element.getNode()) != null && node.getElementType() == TokenType.BAD_CHARACTER) {
            char c = element.textToCharArray()[0];
            boolean printable = StringUtil.isPrintableUnicode(c) && !Character.isSpaceChar(c);
            String hex = String.format("U+%04X", c);
            String text2 = "Illegal character: " + (printable ? c + " (" + hex + ")" : hex);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(text2).create();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/DefaultHighlightUtil", "checkBadCharacter"));
    }
}

