/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BlockMarkerCommentsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final PsiJavaElementPattern ANONYMOUS_CLASS_MARKER_PATTERN = (PsiJavaElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiJavaPatterns.psiElement(PsiDeclarationStatement.class, PsiExpressionStatement.class))).afterSiblingSkipping(PsiJavaPatterns.or(new ElementPattern[]{PsiJavaPatterns.psiElement(PsiWhiteSpace.class), PsiJavaPatterns.psiElement(PsiJavaToken.class).with(new PatternCondition<PsiJavaToken>(null){

        @Override
        public boolean accepts(@NotNull PsiJavaToken psiJavaToken, ProcessingContext context) {
            if (psiJavaToken == null) {
                1.$$$reportNull$$$0(0);
            }
            return psiJavaToken.getTokenType().equals(JavaTokenType.SEMICOLON);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiJavaToken", "com/intellij/codeInspection/BlockMarkerCommentsInspection$1", "accepts"));
        }
    })}), PsiJavaPatterns.psiElement(PsiLocalVariable.class, PsiAssignmentExpression.class).withChild(PsiJavaPatterns.psiElement(PsiNewExpression.class).withChild(PsiJavaPatterns.psiElement(PsiAnonymousClass.class))));
    private static final PsiJavaElementPattern CLASS_MARKER_PATTERN = (PsiJavaElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiClass.class)).afterSiblingSkipping(PsiJavaPatterns.psiElement(PsiWhiteSpace.class), PsiJavaPatterns.psiElement(PsiJavaToken.class).with(new PatternCondition<PsiJavaToken>(null){

        @Override
        public boolean accepts(@NotNull PsiJavaToken token, ProcessingContext context) {
            if (token == null) {
                2.$$$reportNull$$$0(0);
            }
            return JavaTokenType.RBRACE.equals(token.getTokenType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInspection/BlockMarkerCommentsInspection$2", "accepts"));
        }
    }));
    private static final PsiJavaElementPattern TRY_CATCH_MARKER_PATTERN = (PsiJavaElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiTryStatement.class)).afterSiblingSkipping(PsiJavaPatterns.psiElement(PsiWhiteSpace.class), PsiJavaPatterns.psiElement(PsiCodeBlock.class, PsiCatchSection.class));
    private static final PsiJavaElementPattern LOOP_OR_IF_MARKER = (PsiJavaElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterSiblingSkipping(PsiJavaPatterns.psiElement(PsiWhiteSpace.class), PsiJavaPatterns.psiElement(PsiCodeBlock.class))).withParent(PsiJavaPatterns.psiElement(PsiBlockStatement.class).withParent(PsiJavaPatterns.psiElement(PsiLoopStatement.class, PsiIfStatement.class)));
    private static final PsiJavaElementPattern METHOD_MARKER_PATTERN = (PsiJavaElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiMethod.class)).afterSiblingSkipping(PsiJavaPatterns.psiElement(PsiWhiteSpace.class), PsiJavaPatterns.psiElement(PsiCodeBlock.class));
    private static final ElementPattern MARKER_PATTERN = PsiJavaPatterns.or(ANONYMOUS_CLASS_MARKER_PATTERN, CLASS_MARKER_PATTERN, TRY_CATCH_MARKER_PATTERN, LOOP_OR_IF_MARKER, METHOD_MARKER_PATTERN);
    private static final String END_WORD = "end";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            BlockMarkerCommentsInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            @Override
            public void visitComment(PsiComment element) {
                String commentText;
                IElementType tokenType = element.getTokenType();
                if (!tokenType.equals(JavaTokenType.END_OF_LINE_COMMENT)) {
                    return;
                }
                Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element.getLanguage());
                String rawCommentText = element.getText();
                String prefix = commenter.getLineCommentPrefix();
                if (prefix != null && rawCommentText.startsWith(prefix)) {
                    rawCommentText = rawCommentText.substring(prefix.length());
                }
                if (!(commentText = rawCommentText.trim().toLowerCase()).startsWith(BlockMarkerCommentsInspection.END_WORD) || StringUtil.split(commentText, " ").size() > 3) {
                    return;
                }
                if (MARKER_PATTERN.accepts(element)) {
                    holder.registerProblem((PsiElement)element, "Redundant block marker", new LocalQuickFix(){

                        @Override
                        @NotNull
                        public String getFamilyName() {
                            if ("Remove block marker comments" == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return "Remove block marker comments";
                        }

                        @Override
                        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                            if (project == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (descriptor == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            descriptor.getPsiElement().delete();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 2;
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    n2 = 3;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/codeInspection/BlockMarkerCommentsInspection$3$1";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "project";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "descriptor";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getFamilyName";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/codeInspection/BlockMarkerCommentsInspection$3$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray;
                                    objectArray[2] = "applyFix";
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                }
            }
        };
        if (psiElementVisitor == null) {
            BlockMarkerCommentsInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Block marker comment" == null) {
            BlockMarkerCommentsInspection.$$$reportNull$$$0(2);
        }
        return "Block marker comment";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/BlockMarkerCommentsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/BlockMarkerCommentsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

