/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;

public abstract class LocalQuickFixOnPsiElement
implements LocalQuickFix {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.LocalQuickFixAndIntentionAction");
    protected final SmartPsiElementPointer<PsiElement> myStartElement;
    protected final SmartPsiElementPointer<PsiElement> myEndElement;

    protected LocalQuickFixOnPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(0);
        }
        this(element, element);
    }

    public LocalQuickFixOnPsiElement(PsiElement startElement, PsiElement endElement) {
        PsiFile endContainingFile;
        if (startElement == null || endElement == null) {
            this.myEndElement = null;
            this.myStartElement = null;
            return;
        }
        LOG.assertTrue(startElement.isValid());
        PsiFile startContainingFile = startElement.getContainingFile();
        PsiFile psiFile = endContainingFile = startElement == endElement ? startContainingFile : endElement.getContainingFile();
        if (startElement != endElement) {
            LOG.assertTrue(endElement.isValid());
            LOG.assertTrue(startContainingFile == endContainingFile, "Both elements must be from the same file");
        }
        Project project = startContainingFile == null ? startElement.getProject() : startContainingFile.getProject();
        this.myStartElement = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(startElement, startContainingFile);
        this.myEndElement = endElement == startElement ? null : SmartPointerManager.getInstance(project).createSmartPsiElementPointer(endElement, endContainingFile);
    }

    @Override
    @NotNull
    public final String getName() {
        String string = this.getText();
        if (string == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(2);
        }
        if (file == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(5);
        }
        return true;
    }

    protected boolean isAvailable() {
        if (this.myStartElement == null) {
            return false;
        }
        PsiElement startElement = this.myStartElement.getElement();
        PsiElement endElement = this.myEndElement == null ? startElement : this.myEndElement.getElement();
        PsiFile file = this.myStartElement.getContainingFile();
        Project project = this.myStartElement.getProject();
        return startElement != null && endElement != null && startElement.isValid() && (endElement == startElement || endElement.isValid()) && file != null && this.isAvailable(project, file, startElement, endElement);
    }

    public PsiElement getStartElement() {
        return this.myStartElement == null ? null : this.myStartElement.getElement();
    }

    public PsiElement getEndElement() {
        return this.myEndElement == null ? null : this.myEndElement.getElement();
    }

    @NotNull
    public abstract String getText();

    @Override
    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(7);
        }
        this.applyFix();
    }

    public void applyFix() {
        PsiElement endElement;
        if (this.myStartElement == null) {
            return;
        }
        PsiElement startElement = this.myStartElement.getElement();
        PsiElement psiElement = endElement = this.myEndElement == null ? startElement : this.myEndElement.getElement();
        if (startElement == null || endElement == null) {
            return;
        }
        PsiFile file = startElement.getContainingFile();
        if (file == null) {
            return;
        }
        this.invoke(file.getProject(), file, startElement, endElement);
    }

    public abstract void invoke(@NotNull Project var1, @NotNull PsiFile var2, @NotNull PsiElement var3, @NotNull PsiElement var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/LocalQuickFixOnPsiElement";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/LocalQuickFixOnPsiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

