/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.ex.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;

public abstract class ComponentManagerImpl
extends UserDataHolderBase
implements ComponentManagerEx,
org.picocontainer.Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.components.ComponentManager");
    private volatile MutablePicoContainer myPicoContainer;
    private volatile boolean myDisposed;
    private volatile boolean myDisposeCompleted;
    private MessageBus myMessageBus;
    private final Map<String, BaseComponent> myNameToComponent;
    private int myComponentConfigCount;
    private int myInstantiatedComponentCount;
    private boolean myComponentsCreated;
    private final List<BaseComponent> myBaseComponents;
    private final ComponentManager myParentComponentManager;
    private final Condition myDisposedCondition;

    protected ComponentManagerImpl(@Nullable ComponentManager parentComponentManager) {
        this.myNameToComponent = new THashMap();
        this.myInstantiatedComponentCount = -1;
        this.myBaseComponents = new ArrayList<BaseComponent>();
        this.myDisposedCondition = o -> this.isDisposed();
        this.myParentComponentManager = parentComponentManager;
        this.bootstrapPicoContainer(this.toString());
    }

    protected ComponentManagerImpl(@Nullable ComponentManager parentComponentManager, @NotNull String name) {
        if (name == null) {
            ComponentManagerImpl.$$$reportNull$$$0(0);
        }
        this.myNameToComponent = new THashMap();
        this.myInstantiatedComponentCount = -1;
        this.myBaseComponents = new ArrayList<BaseComponent>();
        this.myDisposedCondition = o -> this.isDisposed();
        this.myParentComponentManager = parentComponentManager;
        this.bootstrapPicoContainer(name);
    }

    protected final void init(@Nullable ProgressIndicator progressIndicator) {
        this.init(progressIndicator, null);
    }

    protected final void init(@Nullable ProgressIndicator indicator, @Nullable Runnable componentsRegistered) {
        List<ComponentConfig> componentConfigs = this.getComponentConfigs(indicator);
        for (ComponentConfig config : componentConfigs) {
            this.registerComponents(config);
        }
        this.myComponentConfigCount = componentConfigs.size();
        if (componentsRegistered != null) {
            componentsRegistered.run();
        }
        this.createComponents(indicator);
        this.myComponentsCreated = true;
    }

    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ComponentManagerImpl.$$$reportNull$$$0(1);
        }
        indicator.setFraction(this.getPercentageOfComponentsLoaded());
    }

    protected final double getPercentageOfComponentsLoaded() {
        return (double)this.myInstantiatedComponentCount / (double)this.myComponentConfigCount;
    }

    protected void createComponents(@Nullable ProgressIndicator indicator) {
        DefaultPicoContainer picoContainer = (DefaultPicoContainer)this.getPicoContainer();
        for (ComponentAdapter componentAdapter : picoContainer.getComponentAdapters()) {
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter)) continue;
            componentAdapter.getComponentInstance((PicoContainer)picoContainer);
            if (indicator == null) continue;
            indicator.checkCanceled();
        }
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        if (this.myDisposeCompleted || this.myDisposed) {
            ProgressManager.checkCanceled();
            throw new AssertionError((Object)"Already disposed");
        }
        assert (this.myMessageBus != null) : "Not initialized yet";
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            ComponentManagerImpl.$$$reportNull$$$0(2);
        }
        return messageBus;
    }

    public final boolean isComponentsCreated() {
        return this.myComponentsCreated;
    }

    protected final synchronized void disposeComponents() {
        assert (!this.myDisposeCompleted) : "Already disposed!";
        this.myDisposed = true;
        List<BaseComponent> components = this.myBaseComponents;
        for (int i = components.size() - 1; i >= 0; --i) {
            try {
                components.get(i).disposeComponent();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.myBaseComponents.clear();
        this.myComponentConfigCount = -1;
    }

    @Override
    public final <T> T getComponent(@NotNull Class<T> interfaceClass) {
        ComponentAdapter adapter;
        if (interfaceClass == null) {
            ComponentManagerImpl.$$$reportNull$$$0(3);
        }
        if (this.myDisposeCompleted) {
            ReadAction.run(() -> {
                ProgressManager.checkCanceled();
                throw new AssertionError((Object)("Already disposed: " + this));
            });
        }
        if (!((adapter = this.getPicoContainer().getComponentAdapter(interfaceClass)) instanceof ComponentConfigComponentAdapter)) {
            return null;
        }
        if (this.myDisposed) {
            return (T)((ComponentConfigComponentAdapter)adapter).myInitializedComponentInstance;
        }
        return (T)adapter.getComponentInstance((PicoContainer)this.getPicoContainer());
    }

    @Override
    public final <T> T getComponent(@NotNull Class<T> interfaceClass, T defaultImplementation) {
        T component;
        if (interfaceClass == null) {
            ComponentManagerImpl.$$$reportNull$$$0(4);
        }
        return (component = this.getComponent(interfaceClass)) == null ? defaultImplementation : component;
    }

    @Nullable
    protected ProgressIndicator getProgressIndicator() {
        return ProgressManager.getInstance().getProgressIndicator();
    }

    @Override
    public void initializeComponent(@NotNull Object component, boolean service) {
        if (component == null) {
            ComponentManagerImpl.$$$reportNull$$$0(5);
        }
    }

    protected void handleInitComponentError(Throwable ex, String componentClassName, PluginId pluginId) {
        LOG.error(ex);
    }

    public void registerComponentImplementation(@NotNull Class<?> componentKey, @NotNull Class<?> componentImplementation) {
        MutablePicoContainer picoContainer;
        ComponentConfigComponentAdapter adapter;
        if (componentKey == null) {
            ComponentManagerImpl.$$$reportNull$$$0(6);
        }
        if (componentImplementation == null) {
            ComponentManagerImpl.$$$reportNull$$$0(7);
        }
        LOG.assertTrue((adapter = (ComponentConfigComponentAdapter)(picoContainer = this.getPicoContainer()).unregisterComponent(componentKey)) != null);
        picoContainer.registerComponent((ComponentAdapter)new ComponentConfigComponentAdapter(componentKey, componentImplementation, null, false));
    }

    public synchronized <T> T registerComponentInstance(@NotNull Class<T> componentKey, @NotNull T componentImplementation) {
        if (componentKey == null) {
            ComponentManagerImpl.$$$reportNull$$$0(8);
        }
        if (componentImplementation == null) {
            ComponentManagerImpl.$$$reportNull$$$0(9);
        }
        MutablePicoContainer picoContainer = this.getPicoContainer();
        ComponentAdapter adapter = picoContainer.getComponentAdapter(componentKey);
        LOG.assertTrue(adapter instanceof ComponentConfigComponentAdapter);
        ComponentConfigComponentAdapter componentAdapter = (ComponentConfigComponentAdapter)adapter;
        Object oldInstance = componentAdapter.myInitializedComponentInstance;
        componentAdapter.myInitializedComponentInstance = componentImplementation;
        return (T)oldInstance;
    }

    @Override
    public boolean hasComponent(@NotNull Class interfaceClass) {
        if (interfaceClass == null) {
            ComponentManagerImpl.$$$reportNull$$$0(10);
        }
        return this.getPicoContainer().getComponentAdapter((Object)interfaceClass) != null;
    }

    @Override
    @NotNull
    public <T> T[] getComponents(@NotNull Class<T> baseClass) {
        if (baseClass == null) {
            ComponentManagerImpl.$$$reportNull$$$0(11);
        }
        T[] TArray = ArrayUtil.toObjectArray(this.getComponentInstancesOfType(baseClass), baseClass);
        if (TArray == null) {
            ComponentManagerImpl.$$$reportNull$$$0(12);
        }
        return TArray;
    }

    @NotNull
    public final <T> List<T> getComponentInstancesOfType(@NotNull Class<T> baseClass) {
        if (baseClass == null) {
            ComponentManagerImpl.$$$reportNull$$$0(13);
        }
        ArrayList<Object> result = null;
        for (ComponentAdapter componentAdapter : ((DefaultPicoContainer)this.getPicoContainer()).getComponentAdapters()) {
            Object instance;
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter) || !ReflectionUtil.isAssignable(baseClass, componentAdapter.getComponentImplementation()) || (instance = ((ComponentConfigComponentAdapter)componentAdapter).myInitializedComponentInstance) == null) continue;
            if (result == null) {
                result = new ArrayList<Object>();
            }
            result.add(instance);
        }
        List list = ContainerUtil.notNullize(result);
        if (list == null) {
            ComponentManagerImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public MutablePicoContainer getPicoContainer() {
        MutablePicoContainer container = this.myPicoContainer;
        if (container == null || this.myDisposeCompleted) {
            ReadAction.run(() -> {
                ProgressManager.checkCanceled();
                throw new AssertionError((Object)("Already disposed: " + this.toString()));
            });
        }
        MutablePicoContainer mutablePicoContainer = container;
        if (mutablePicoContainer == null) {
            ComponentManagerImpl.$$$reportNull$$$0(15);
        }
        return mutablePicoContainer;
    }

    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        DefaultPicoContainer defaultPicoContainer = this.myParentComponentManager == null ? new DefaultPicoContainer() : new DefaultPicoContainer(this.myParentComponentManager.getPicoContainer());
        if (defaultPicoContainer == null) {
            ComponentManagerImpl.$$$reportNull$$$0(16);
        }
        return defaultPicoContainer;
    }

    protected boolean isComponentSuitable(@Nullable Map<String, String> options) {
        return options == null || Extensions.isComponentSuitableForOs(options.get("os")) && (!Boolean.parseBoolean(options.get("internal")) || ApplicationManager.getApplication().isInternal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDisposeCompleted = true;
        if (this.myMessageBus != null) {
            Disposer.dispose(this.myMessageBus);
            this.myMessageBus = null;
        }
        this.myPicoContainer = null;
        ComponentManagerImpl componentManagerImpl = this;
        synchronized (componentManagerImpl) {
            this.myNameToComponent.clear();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    private List<ComponentConfig> getComponentConfigs(ProgressIndicator indicator) {
        ArrayList<ComponentConfig> componentConfigs = new ArrayList<ComponentConfig>();
        boolean isDefaultProject = this instanceof Project && ((Project)((Object)this)).isDefault();
        boolean headless = ApplicationManager.getApplication().isHeadlessEnvironment();
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins((message, progress) -> indicator.setFraction(progress))) {
            if (PluginManagerCore.shouldSkipPlugin(plugin)) continue;
            ComponentConfig[] configs = this.getMyComponentConfigsFromDescriptor(plugin);
            componentConfigs.ensureCapacity(componentConfigs.size() + configs.length);
            for (ComponentConfig config : configs) {
                if (isDefaultProject && !config.isLoadForDefaultProject() || !this.isComponentSuitable(config.options) || !config.prepareClasses(headless)) continue;
                config.pluginDescriptor = plugin;
                componentConfigs.add(config);
            }
        }
        ArrayList<ComponentConfig> arrayList = componentConfigs;
        if (arrayList == null) {
            ComponentManagerImpl.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public ComponentConfig[] getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            ComponentManagerImpl.$$$reportNull$$$0(18);
        }
        ComponentConfig[] componentConfigArray = plugin.getAppComponents();
        if (componentConfigArray == null) {
            ComponentManagerImpl.$$$reportNull$$$0(19);
        }
        return componentConfigArray;
    }

    protected void bootstrapPicoContainer(@NotNull String name) {
        MutablePicoContainer picoContainer;
        if (name == null) {
            ComponentManagerImpl.$$$reportNull$$$0(20);
        }
        this.myPicoContainer = picoContainer = this.createPicoContainer();
        this.myMessageBus = MessageBusFactory.newMessageBus(name, this.myParentComponentManager == null ? null : this.myParentComponentManager.getMessageBus());
        picoContainer.registerComponentInstance(MessageBus.class, (Object)this.myMessageBus);
    }

    protected final ComponentManager getParentComponentManager() {
        return this.myParentComponentManager;
    }

    protected final int getComponentConfigCount() {
        return this.myComponentConfigCount;
    }

    @Nullable
    public final PluginId getConfig(@NotNull ComponentAdapter adapter) {
        if (adapter == null) {
            ComponentManagerImpl.$$$reportNull$$$0(21);
        }
        return adapter instanceof ComponentConfigComponentAdapter ? ((ComponentConfigComponentAdapter)adapter).myPluginId : null;
    }

    public final boolean isWorkspaceComponent(@NotNull Class<?> componentImplementation) {
        ComponentConfigComponentAdapter adapter;
        if (componentImplementation == null) {
            ComponentManagerImpl.$$$reportNull$$$0(22);
        }
        return (adapter = this.getComponentAdapter(componentImplementation)) != null && adapter.isWorkspaceComponent;
    }

    @Nullable
    private ComponentConfigComponentAdapter getComponentAdapter(@NotNull Class<?> componentImplementation) {
        if (componentImplementation == null) {
            ComponentManagerImpl.$$$reportNull$$$0(23);
        }
        for (ComponentAdapter componentAdapter : ((DefaultPicoContainer)this.getPicoContainer()).getComponentAdapters()) {
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter) || componentAdapter.getComponentImplementation() != componentImplementation) continue;
            return (ComponentConfigComponentAdapter)componentAdapter;
        }
        return null;
    }

    @Override
    @NotNull
    public final Condition<?> getDisposed() {
        Condition condition = this.myDisposedCondition;
        if (condition == null) {
            ComponentManagerImpl.$$$reportNull$$$0(24);
        }
        return condition;
    }

    @NotNull
    public static String getComponentName(@NotNull Object component) {
        if (component == null) {
            ComponentManagerImpl.$$$reportNull$$$0(25);
        }
        if (component instanceof NamedComponent) {
            String string = ((NamedComponent)component).getComponentName();
            if (string == null) {
                ComponentManagerImpl.$$$reportNull$$$0(26);
            }
            return string;
        }
        String string = component.getClass().getName();
        if (string == null) {
            ComponentManagerImpl.$$$reportNull$$$0(27);
        }
        return string;
    }

    protected boolean logSlowComponents() {
        return LOG.isDebugEnabled();
    }

    private void registerComponents(@NotNull ComponentConfig config) {
        if (config == null) {
            ComponentManagerImpl.$$$reportNull$$$0(28);
        }
        ClassLoader loader = config.getClassLoader();
        try {
            Class<?> interfaceClass = Class.forName(config.getInterfaceClass(), true, loader);
            Class<?> implementationClass = Comparing.equal(config.getInterfaceClass(), config.getImplementationClass()) ? interfaceClass : (StringUtil.isEmpty(config.getImplementationClass()) ? null : Class.forName(config.getImplementationClass(), true, loader));
            MutablePicoContainer picoContainer = this.getPicoContainer();
            if (config.options != null && Boolean.parseBoolean(config.options.get("overrides"))) {
                ComponentAdapter oldAdapter = picoContainer.getComponentAdapterOfType(interfaceClass);
                if (oldAdapter == null) {
                    throw new RuntimeException(config + " does not override anything");
                }
                picoContainer.unregisterComponent(oldAdapter.getComponentKey());
            }
            if (implementationClass != null) {
                boolean ws = config.options != null && Boolean.parseBoolean(config.options.get("workspace"));
                picoContainer.registerComponent((ComponentAdapter)new ComponentConfigComponentAdapter(interfaceClass, implementationClass, config.getPluginId(), ws));
            }
        }
        catch (Throwable t) {
            this.handleInitComponentError(t, null, config.getPluginId());
        }
    }

    private void registerComponentInstance(@NotNull Object instance) {
        if (instance == null) {
            ComponentManagerImpl.$$$reportNull$$$0(29);
        }
        ++this.myInstantiatedComponentCount;
        if (instance instanceof Disposable) {
            Disposer.register(this, (Disposable)instance);
        }
        if (!(instance instanceof BaseComponent)) {
            return;
        }
        BaseComponent baseComponent = (BaseComponent)instance;
        String componentName = baseComponent.getComponentName();
        if (this.myNameToComponent.containsKey(componentName)) {
            BaseComponent loadedComponent = this.myNameToComponent.get(componentName);
            if (!instance.equals(loadedComponent)) {
                LOG.error("Component name collision: " + componentName + " " + (loadedComponent == null ? "null" : loadedComponent.getClass()) + " and " + instance.getClass());
            }
        } else {
            this.myNameToComponent.put(componentName, baseComponent);
        }
        this.myBaseComponents.add(baseComponent);
    }

    @Override
    public synchronized BaseComponent getComponent(@NotNull String name) {
        if (name == null) {
            ComponentManagerImpl.$$$reportNull$$$0(30);
        }
        return this.myNameToComponent.get(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/ComponentManagerImpl";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 5: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 7: 
            case 9: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/ComponentManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentInstancesOfType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPicoContainer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createPicoContainer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentConfigs";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyComponentConfigsFromDescriptor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposed";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProgressDuringInit";
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 27: {
                break;
            }
            case 3: 
            case 4: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initializeComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentImplementation";
                break;
            }
            case 8: 
            case 9: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstancesOfType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMyComponentConfigsFromDescriptor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "bootstrapPicoContainer";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isWorkspaceComponent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapter";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getComponentName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "registerComponents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ComponentConfigComponentAdapter
    extends CachingConstructorInjectionComponentAdapter {
        private final PluginId myPluginId;
        private volatile Object myInitializedComponentInstance;
        private boolean myInitializing;
        final boolean isWorkspaceComponent;

        ComponentConfigComponentAdapter(@NotNull Class<?> interfaceClass, @Nullable Class<?> implementationClass, PluginId pluginId, boolean isWorkspaceComponent) {
            if (interfaceClass == null) {
                ComponentConfigComponentAdapter.$$$reportNull$$$0(0);
            }
            if (implementationClass == null) {
                ComponentConfigComponentAdapter.$$$reportNull$$$0(1);
            }
            super(interfaceClass, implementationClass, null, true);
            this.myPluginId = pluginId;
            this.isWorkspaceComponent = isWorkspaceComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, ProcessCanceledException {
            Object instance = this.myInitializedComponentInstance;
            if (instance != null) {
                return instance;
            }
            try {
                ComponentConfigComponentAdapter componentConfigComponentAdapter = this;
                synchronized (componentConfigComponentAdapter) {
                    instance = this.myInitializedComponentInstance;
                    if (instance != null) {
                        return instance;
                    }
                    long startTime = System.nanoTime();
                    instance = super.getComponentInstance(picoContainer);
                    if (this.myInitializing) {
                        String errorMessage = "Cyclic component initialization: " + this.getComponentKey();
                        if (this.myPluginId != null) {
                            LOG.error(new PluginException(errorMessage, this.myPluginId));
                        } else {
                            LOG.error(new Throwable(errorMessage));
                        }
                    }
                    try {
                        long ms;
                        this.myInitializing = true;
                        ComponentManagerImpl.this.registerComponentInstance(instance);
                        ProgressIndicator indicator = ComponentManagerImpl.this.getProgressIndicator();
                        if (indicator != null) {
                            indicator.checkCanceled();
                            ComponentManagerImpl.this.setProgressDuringInit(indicator);
                        }
                        ComponentManagerImpl.this.initializeComponent(instance, false);
                        if (instance instanceof BaseComponent) {
                            ((BaseComponent)instance).initComponent();
                        }
                        if ((ms = (System.nanoTime() - startTime) / 1000000L) > 10L && ComponentManagerImpl.this.logSlowComponents()) {
                            LOG.info(instance.getClass().getName() + " initialized in " + ms + " ms");
                        }
                    }
                    finally {
                        this.myInitializing = false;
                    }
                    this.myInitializedComponentInstance = instance;
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                ComponentManagerImpl.this.handleInitComponentError(t, ((Class)this.getComponentKey()).getName(), this.myPluginId);
            }
            return instance;
        }

        public String toString() {
            return "ComponentConfigAdapter[" + this.getComponentKey() + "]: implementation=" + this.getComponentImplementation() + ", plugin=" + this.myPluginId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interfaceClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "implementationClass";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/components/impl/ComponentManagerImpl$ComponentConfigComponentAdapter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

