/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPolyadicExpressionImpl
extends ExpressionPsiElement
implements PsiPolyadicExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiPolyadicExpressionImpl");
    private static final Function<PsiPolyadicExpressionImpl, PsiType> MY_TYPE_EVALUATOR = expression -> PsiPolyadicExpressionImpl.doGetType(expression);
    private static final TokenSet OUR_OPERATIONS_BIT_SET = TokenSet.create(JavaTokenType.OROR, JavaTokenType.ANDAND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.AND, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC);
    private volatile PsiExpression[] cachedOperands;

    public PsiPolyadicExpressionImpl() {
        super(JavaElementType.POLYADIC_EXPRESSION);
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = ((PsiJavaToken)this.findChildByRoleAsPsiElement(63)).getTokenType();
        if (iElementType == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(0);
        }
        return iElementType;
    }

    @Override
    public PsiJavaToken getTokenBeforeOperand(@NotNull PsiExpression operand) {
        if (operand == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(1);
        }
        for (PsiElement element = operand; element != null; element = element.getPrevSibling()) {
            if (this.getChildRole(element.getNode()) != 63) continue;
            return (PsiJavaToken)element;
        }
        return null;
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, MY_TYPE_EVALUATOR);
    }

    @Nullable
    private static PsiType doGetType(PsiPolyadicExpressionImpl param) {
        PsiExpression[] operands = param.getOperands();
        PsiType lType = null;
        IElementType sign = param.getOperationTokenType();
        for (int i = 1; i < operands.length; ++i) {
            PsiType rType = operands[i].getType();
            PsiType type = TypeConversionUtil.calcTypeForBinaryExpression(null, rType, sign, false);
            if (type != TypeConversionUtil.NULL_TYPE) {
                return type;
            }
            if (lType == null) {
                lType = operands[0].getType();
            }
            lType = TypeConversionUtil.calcTypeForBinaryExpression(lType, rType, sign, true);
        }
        return lType;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 63: 
        }
        return this.findChildByType(OUR_OPERATIONS_BIT_SET);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (OUR_OPERATIONS_BIT_SET.contains(child.getElementType())) {
            return 63;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPolyadicExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiExpression[] getOperands() {
        PsiExpression[] operands = this.cachedOperands;
        if (operands == null) {
            operands = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.EXPRESSION_BIT_SET, PsiExpression.ARRAY_FACTORY);
            this.cachedOperands = operands;
        }
        if (operands == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(3);
        }
        return operands;
    }

    @Override
    public void clearCaches() {
        this.cachedOperands = null;
        super.clearCaches();
    }

    @Override
    public String toString() {
        return "PsiPolyadicExpression: " + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiPolyadicExpressionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationTokenType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiPolyadicExpressionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperands";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTokenBeforeOperand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

