/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualsToEqualityFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectEqualsNullInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.equals.null.display.name", new Object[0]);
        if (string == null) {
            ObjectEqualsNullInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("object.equals.null.problem.descriptor", new Object[0]);
        if (string == null) {
            ObjectEqualsNullInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean negated = (Boolean)infos[0];
        return negated == null ? null : new EqualsToEqualityFix(negated);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectEqualsNullVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ObjectEqualsNullInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ObjectEqualsNullVisitor
    extends BaseInspectionVisitor {
        private ObjectEqualsNullVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            boolean negated;
            PsiExpression argument;
            if (call == null) {
                ObjectEqualsNullVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            if (!MethodCallUtils.isEqualsCall(call)) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            PsiExpression psiExpression = argument = args.length > 0 ? args[0] : null;
            if (!ExpressionUtils.isNullLiteral(argument)) {
                return;
            }
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses(call);
            boolean bl = negated = parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
            if (negated) {
                parent = parent.getParent();
            }
            boolean quickFix = !(parent instanceof PsiExpressionStatement);
            this.registerError((PsiElement)argument, quickFix ? Boolean.valueOf(negated) : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/bugs/ObjectEqualsNullInspection$ObjectEqualsNullVisitor", "visitMethodCallExpression"));
        }
    }
}

