/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class InstanceofCatchParameterInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("instanceof.catch.parameter.display.name", new Object[0]);
        if (string == null) {
            InstanceofCatchParameterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instanceof.catch.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            InstanceofCatchParameterInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofCatchParameterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/InstanceofCatchParameterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class InstanceofCatchParameterVisitor
    extends BaseInspectionVisitor {
        private InstanceofCatchParameterVisitor() {
        }

        @Override
        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression exp) {
            if (exp == null) {
                InstanceofCatchParameterVisitor.$$$reportNull$$$0(0);
            }
            super.visitInstanceOfExpression(exp);
            if (!ControlFlowUtils.isInCatchBlock(exp)) {
                return;
            }
            PsiExpression operand = exp.getOperand();
            if (!(operand instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)operand;
            PsiElement referent = ref.resolve();
            if (!(referent instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)referent;
            if (!(parameter.getDeclarationScope() instanceof PsiCatchSection)) {
                return;
            }
            this.registerError((PsiElement)exp, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/siyeh/ig/errorhandling/InstanceofCatchParameterInspection$InstanceofCatchParameterVisitor", "visitInstanceOfExpression"));
        }
    }
}

