/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class BadOddnessInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("bad.oddness.display.name", new Object[0]);
        if (string == null) {
            BadOddnessInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("bad.oddness.problem.descriptor", new Object[0]);
        if (string == null) {
            BadOddnessInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadOddnessVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/BadOddnessInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class BadOddnessVisitor
    extends BaseInspectionVisitor {
        private BadOddnessVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                BadOddnessVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            if (BadOddnessVisitor.isModTwo(lhs) && BadOddnessVisitor.hasValue(rhs, 1)) {
                this.registerError((PsiElement)expression, expression);
            }
            if (BadOddnessVisitor.isModTwo(rhs) && BadOddnessVisitor.hasValue(lhs, 1)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static boolean isModTwo(PsiExpression exp) {
            if (!(exp instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binary = (PsiBinaryExpression)exp;
            IElementType tokenType = binary.getOperationTokenType();
            if (!JavaTokenType.PERC.equals(tokenType)) {
                return false;
            }
            PsiExpression rhs = binary.getROperand();
            PsiExpression lhs = binary.getLOperand();
            if (rhs == null) {
                return false;
            }
            return BadOddnessVisitor.hasValue(rhs, 2) && BadOddnessVisitor.canBeNegative(lhs);
        }

        private static boolean canBeNegative(PsiExpression lhs) {
            LongRangeSet range = CommonDataflow.getExpressionFact(lhs, DfaFactType.RANGE);
            return range == null || range.min() < 0L;
        }

        private static boolean hasValue(PsiExpression expression, int testValue) {
            Integer value = (Integer)ConstantExpressionUtil.computeCastTo(expression, (PsiType)PsiType.INT);
            return value != null && value == testValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/BadOddnessInspection$BadOddnessVisitor", "visitBinaryExpression"));
        }
    }
}

