/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnaryPlusInspection
extends BaseInspection {
    public boolean onlyReportInsideBinaryExpression = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unary.plus.display.name", new Object[0]);
        if (string == null) {
            UnaryPlusInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unary.plus.problem.descriptor", new Object[0]);
        if (string == null) {
            UnaryPlusInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Only report in confusing binary or unary expression context", this, "onlyReportInsideBinaryExpression");
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            UnaryPlusInspection.$$$reportNull$$$0(2);
        }
        if (!this.onlyReportInsideBinaryExpression) {
            node.addContent(new Element("option").setAttribute("name", "onlyReportInsideBinaryExpression").setAttribute("value", "false"));
        }
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnaryPlusFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnaryPlusVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/numeric/UnaryPlusInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/numeric/UnaryPlusInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UnaryPlusVisitor
    extends BaseInspectionVisitor {
        private UnaryPlusVisitor() {
        }

        @Override
        public void visitPrefixExpression(PsiPrefixExpression prefixExpression) {
            super.visitPrefixExpression(prefixExpression);
            PsiJavaToken token = prefixExpression.getOperationSign();
            IElementType tokenType = token.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUS)) {
                return;
            }
            PsiExpression operand = prefixExpression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType type = operand.getType();
            if (type == null) {
                return;
            }
            if (UnaryPlusInspection.this.onlyReportInsideBinaryExpression) {
                PsiElement parent = ParenthesesUtils.getParentSkipParentheses(prefixExpression);
                if (!(operand instanceof PsiParenthesizedExpression || operand instanceof PsiPrefixExpression || parent instanceof PsiPolyadicExpression || parent instanceof PsiPrefixExpression)) {
                    return;
                }
            } else if (TypeUtils.unaryNumericPromotion(type) != type && MethodCallUtils.isNecessaryForSurroundingMethodCall(prefixExpression, operand)) {
                return;
            }
            this.registerError((PsiElement)token, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }
    }

    private static class UnaryPlusFix
    extends InspectionGadgetsFix {
        private UnaryPlusFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unary.plus.quickfix", new Object[0]);
            if (string == null) {
                UnaryPlusFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
            PsiExpression operand = prefixExpression.getOperand();
            if (operand == null) {
                return;
            }
            prefixExpression.replace(operand);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/UnaryPlusInspection$UnaryPlusFix", "getFamilyName"));
        }
    }
}

