/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.library;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.JpsJavaSdkTypeWrapper;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.library.JpsLibraryRootTypeSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkPropertiesSerializer;

public class JpsSdkTableSerializer {
    private static final Logger LOG = Logger.getInstance(JpsSdkTableSerializer.class);
    private static final JpsLibraryRootTypeSerializer[] PREDEFINED_ROOT_TYPE_SERIALIZERS = new JpsLibraryRootTypeSerializer[]{new JpsLibraryRootTypeSerializer("classPath", JpsOrderRootType.COMPILED, true), new JpsLibraryRootTypeSerializer("sourcePath", JpsOrderRootType.SOURCES, true)};
    private static final JpsSdkPropertiesSerializer<JpsDummyElement> JPS_JAVA_SDK_PROPERTIES_LOADER = new JpsSdkPropertiesSerializer<JpsDummyElement>("JavaSDK", (JpsSdkType)JpsJavaSdkType.INSTANCE){

        @Override
        @NotNull
        public JpsDummyElement loadProperties(Element propertiesElement) {
            JpsDummyElement jpsDummyElement = JpsElementFactory.getInstance().createDummyElement();
            if (jpsDummyElement == null) {
                1.$$$reportNull$$$0(0);
            }
            return jpsDummyElement;
        }

        @Override
        public void saveProperties(@NotNull JpsDummyElement properties, @NotNull Element element) {
            if (properties == null) {
                1.$$$reportNull$$$0(1);
            }
            if (element == null) {
                1.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/model/serialization/library/JpsSdkTableSerializer$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadProperties";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/model/serialization/library/JpsSdkTableSerializer$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "saveProperties";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final String JDK_TAG = "jdk";
    private static final String NAME_TAG = "name";
    private static final String TYPE_TAG = "type";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String ROOTS_TAG = "roots";
    private static final String ROOT_TAG = "root";
    private static final String VERSION_TAG = "version";
    private static final String HOME_PATH_TAG = "homePath";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String COMPOSITE_TYPE = "composite";
    private static final String SIMPLE_TYPE = "simple";
    private static final String URL_ATTRIBUTE = "url";
    private static final String ADDITIONAL_TAG = "additional";

    public static void loadSdks(@Nullable Element sdkListElement, JpsLibraryCollection result) {
        for (Element sdkElement : JDOMUtil.getChildren(sdkListElement, JDK_TAG)) {
            result.addLibrary(JpsSdkTableSerializer.loadSdk(sdkElement));
        }
    }

    public static void saveSdks(JpsLibraryCollection libraryCollection, Element sdkListElement) {
        for (JpsLibrary library : libraryCollection.getLibraries()) {
            JpsElement properties = library.getProperties();
            if (!(properties instanceof JpsSdk)) continue;
            Element sdkTag = new Element(JDK_TAG);
            JpsSdkTableSerializer.saveSdk((JpsSdk)properties, sdkTag);
            sdkListElement.addContent(sdkTag);
        }
    }

    private static JpsLibrary loadSdk(Element sdkElement) {
        String name = JpsSdkTableSerializer.getAttributeValue(sdkElement, NAME_TAG);
        String typeId = JpsSdkTableSerializer.getAttributeValue(sdkElement, "type");
        LOG.debug("Loading " + typeId + " SDK '" + name + "'");
        JpsSdkPropertiesSerializer<?> serializer2 = JpsSdkTableSerializer.getSdkPropertiesSerializer(typeId);
        JpsLibrary library = JpsSdkTableSerializer.createSdk(name, serializer2, sdkElement);
        Element roots = sdkElement.getChild(ROOTS_TAG);
        for (Element rootTypeElement : JDOMUtil.getChildren(roots)) {
            JpsLibraryRootTypeSerializer rootTypeSerializer = JpsSdkTableSerializer.getRootTypeSerializer(rootTypeElement.getName());
            if (rootTypeSerializer != null) {
                for (Element rootElement : rootTypeElement.getChildren()) {
                    JpsSdkTableSerializer.loadRoots(rootElement, library, rootTypeSerializer.getType());
                }
                continue;
            }
            LOG.info("root type serializer not found for " + rootTypeElement.getName());
        }
        if (LOG.isDebugEnabled()) {
            List<File> files = library.getFiles(JpsOrderRootType.COMPILED);
            LOG.debug(name + " SDK classpath (" + files.size() + " roots):");
            for (File file : files) {
                LOG.debug(" " + file.getAbsolutePath());
            }
        }
        return library;
    }

    private static <P extends JpsElement> void saveSdk(JpsSdk<P> sdk, Element sdkTag) {
        JpsLibrary library = sdk.getParent();
        sdkTag.setAttribute(VERSION_TAG, "2");
        JpsSdkTableSerializer.setAttributeValue(sdkTag, NAME_TAG, library.getName());
        JpsSdkPropertiesSerializer<P> serializer2 = JpsSdkTableSerializer.getSdkPropertiesSerializer(sdk.getSdkType());
        JpsSdkTableSerializer.setAttributeValue(sdkTag, "type", serializer2.getTypeId());
        String versionString = sdk.getVersionString();
        if (versionString != null) {
            JpsSdkTableSerializer.setAttributeValue(sdkTag, VERSION_TAG, versionString);
        }
        JpsSdkTableSerializer.setAttributeValue(sdkTag, HOME_PATH_TAG, sdk.getHomePath());
        Element rootsTag = new Element(ROOTS_TAG);
        for (JpsLibraryRootTypeSerializer rootTypeSerializer : JpsSdkTableSerializer.getRootTypeSerializers()) {
            Element rootTypeTag = new Element(rootTypeSerializer.getTypeId());
            Element compositeTag = new Element(ROOT_TAG);
            compositeTag.setAttribute("type", COMPOSITE_TYPE);
            List<JpsLibraryRoot> roots = library.getRoots(rootTypeSerializer.getType());
            for (JpsLibraryRoot root : roots) {
                compositeTag.addContent(new Element(ROOT_TAG).setAttribute("type", SIMPLE_TYPE).setAttribute(URL_ATTRIBUTE, root.getUrl()));
            }
            rootTypeTag.addContent(compositeTag);
            rootsTag.addContent(rootTypeTag);
        }
        sdkTag.addContent(rootsTag);
        Element additionalTag = new Element(ADDITIONAL_TAG);
        serializer2.saveProperties(sdk.getSdkProperties(), additionalTag);
        sdkTag.addContent(additionalTag);
    }

    private static void setAttributeValue(Element tag, String tagName, String value) {
        tag.addContent(new Element(tagName).setAttribute(VALUE_ATTRIBUTE, value));
    }

    private static void loadRoots(Element rootElement, JpsLibrary library, JpsOrderRootType rootType) {
        String type = rootElement.getAttributeValue("type");
        if (type.equals(COMPOSITE_TYPE)) {
            for (Element element : rootElement.getChildren()) {
                JpsSdkTableSerializer.loadRoots(element, library, rootType);
            }
        } else if (type.equals(SIMPLE_TYPE)) {
            library.addRoot(rootElement.getAttributeValue(URL_ATTRIBUTE), rootType);
        }
    }

    @Nullable
    private static JpsLibraryRootTypeSerializer getRootTypeSerializer(String typeId) {
        for (JpsLibraryRootTypeSerializer serializer2 : PREDEFINED_ROOT_TYPE_SERIALIZERS) {
            if (!serializer2.getTypeId().equals(typeId)) continue;
            return serializer2;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsLibraryRootTypeSerializer serializer2 : extension.getSdkRootTypeSerializers()) {
                if (!serializer2.getTypeId().equals(typeId)) continue;
                return serializer2;
            }
        }
        return null;
    }

    private static List<JpsLibraryRootTypeSerializer> getRootTypeSerializers() {
        ArrayList<JpsLibraryRootTypeSerializer> serializers = new ArrayList<JpsLibraryRootTypeSerializer>(Arrays.asList(PREDEFINED_ROOT_TYPE_SERIALIZERS));
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            serializers.addAll(extension.getSdkRootTypeSerializers());
        }
        Collections.sort(serializers);
        return serializers;
    }

    private static <P extends JpsElement> JpsLibrary createSdk(String name, JpsSdkPropertiesSerializer<P> loader, Element sdkElement) {
        String versionString = JpsSdkTableSerializer.getAttributeValue(sdkElement, VERSION_TAG);
        String homePath = JpsSdkTableSerializer.getAttributeValue(sdkElement, HOME_PATH_TAG);
        Element propertiesTag = sdkElement.getChild(ADDITIONAL_TAG);
        P properties = loader.loadProperties(propertiesTag);
        return JpsElementFactory.getInstance().createSdk(name, homePath, versionString, (JpsSdkType)loader.getType(), properties);
    }

    public static JpsSdkPropertiesSerializer<?> getSdkPropertiesSerializer(@Nullable String typeId) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsSdkPropertiesSerializer<?> loader : extension.getSdkPropertiesSerializers()) {
                if (!loader.getTypeId().equals(typeId)) continue;
                return loader;
            }
        }
        return JPS_JAVA_SDK_PROPERTIES_LOADER;
    }

    public static <P extends JpsElement> JpsSdkPropertiesSerializer<P> getSdkPropertiesSerializer(JpsSdkType<P> type) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsSdkPropertiesSerializer<?> loader : extension.getSdkPropertiesSerializers()) {
                if (!((JpsSdkType)loader.getType()).equals(type)) continue;
                return loader;
            }
        }
        return JPS_JAVA_SDK_PROPERTIES_LOADER;
    }

    @Nullable
    private static String getAttributeValue(Element element, String childName) {
        Element child = element.getChild(childName);
        return child != null ? child.getAttributeValue(VALUE_ATTRIBUTE) : null;
    }

    public static JpsSdkType<?> getSdkType(@Nullable String typeId) {
        return (JpsSdkType)JpsSdkTableSerializer.getSdkPropertiesSerializer(typeId).getType();
    }

    public static JpsSdkPropertiesSerializer<?> getLoader(JpsSdkType<?> type) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsSdkPropertiesSerializer<?> loader : extension.getSdkPropertiesSerializers()) {
                if (!((JpsSdkType)loader.getType()).equals(type)) continue;
                return loader;
            }
        }
        return JPS_JAVA_SDK_PROPERTIES_LOADER;
    }

    public static <P extends JpsElement> void setSdkReference(JpsSdkReferencesTable table, String sdkName, JpsSdkType<P> sdkType) {
        JpsSdkReference<P> reference = JpsElementFactory.getInstance().createSdkReference(sdkName, sdkType);
        table.setSdkReference(sdkType, reference);
        if (sdkType instanceof JpsJavaSdkTypeWrapper) {
            JpsSdkReference<P> wrapperRef = JpsElementFactory.getInstance().createSdkReference(sdkName, sdkType);
            table.setSdkReference(JpsJavaSdkType.INSTANCE, JpsJavaExtensionService.getInstance().createWrappedJavaSdkReference((JpsJavaSdkTypeWrapper)((Object)sdkType), wrapperRef));
        }
    }
}

