/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightModifierList
extends LightElement
implements PsiModifierList {
    private final Set<String> myModifiers;

    public LightModifierList(PsiModifierListOwner modifierListOwner) {
        this(modifierListOwner.getManager());
        this.copyModifiers(modifierListOwner.getModifierList());
    }

    public LightModifierList(PsiManager manager) {
        this(manager, JavaLanguage.INSTANCE, new String[0]);
    }

    public LightModifierList(PsiManager manager, Language language, String ... modifiers) {
        super(manager, language);
        this.myModifiers = ContainerUtil.newTroveSet(modifiers);
    }

    public void addModifier(String modifier) {
        this.myModifiers.add(modifier);
    }

    public void copyModifiers(PsiModifierList modifierList) {
        if (modifierList == null) {
            return;
        }
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!modifierList.hasExplicitModifier(modifier)) continue;
            this.addModifier(modifier);
        }
    }

    public void clearModifiers() {
        this.myModifiers.clear();
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            LightModifierList.$$$reportNull$$$0(0);
        }
        return this.myModifiers.contains(name);
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        if (name == null) {
            LightModifierList.$$$reportNull$$$0(1);
        }
        return this.myModifiers.contains(name);
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            LightModifierList.$$$reportNull$$$0(2);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            LightModifierList.$$$reportNull$$$0(3);
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            LightModifierList.$$$reportNull$$$0(4);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            LightModifierList.$$$reportNull$$$0(5);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            LightModifierList.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            LightModifierList.$$$reportNull$$$0(7);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            LightModifierList.$$$reportNull$$$0(8);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiModifierList";
    }

    @Override
    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            buffer.append(modifier);
            buffer.append(' ');
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    @NotNull
    public String[] getModifiers() {
        String[] stringArray = ArrayUtil.toStringArray(this.myModifiers);
        if (stringArray == null) {
            LightModifierList.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightModifierList";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitModifier";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkSetModifierProperty";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

