/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ErrorFixExtensionPoint
extends AbstractExtensionPointBean {
    public static final ExtensionPointName<ErrorFixExtensionPoint> ERROR_FIX_EXTENSION_POINT = ExtensionPointName.create("com.intellij.java.error.fix");
    @Attribute(value="errorCode")
    public String errorCode;
    @Attribute(value="implementationClass")
    public String implementationClass;
    private static volatile Map<String, List<ErrorFixExtensionPoint>> ourCodeToFix;

    IntentionAction instantiate(PsiElement context) {
        try {
            return this.findClass(this.implementationClass).asSubclass(IntentionAction.class).getConstructor(PsiElement.class).newInstance(context);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            throw new RuntimeException("Error instantiating quick-fix " + this.implementationClass + " (error code: " + this.errorCode + ")", e.getCause());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException("Error instantiating quick-fix " + this.implementationClass + " (error code: " + this.errorCode + ")", e);
        }
    }

    @NotNull
    private static Map<String, List<ErrorFixExtensionPoint>> getCodeToFixMap() {
        Map map = ourCodeToFix;
        if (map == null) {
            ourCodeToFix = map = StreamEx.of((Object[])ERROR_FIX_EXTENSION_POINT.getExtensions()).groupingBy(fix -> fix.errorCode);
        }
        Map map2 = map;
        if (map2 == null) {
            ErrorFixExtensionPoint.$$$reportNull$$$0(0);
        }
        return map2;
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static HighlightInfo registerFixes(@Nullable HighlightInfo info, @NotNull PsiElement context, @NotNull @PropertyKey(resourceBundle="messages.JavaErrorMessages") String code) {
        if (context == null) {
            ErrorFixExtensionPoint.$$$reportNull$$$0(1);
        }
        if (code == null) {
            ErrorFixExtensionPoint.$$$reportNull$$$0(2);
        }
        if (info == null) {
            return null;
        }
        List<ErrorFixExtensionPoint> fixes = ErrorFixExtensionPoint.getCodeToFixMap().get(code);
        for (ErrorFixExtensionPoint fix : fixes) {
            QuickFixAction.registerQuickFixAction(info, fix.instantiate(context));
        }
        return info;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/ErrorFixExtensionPoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeToFixMap";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/ErrorFixExtensionPoint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

