/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectRootsUtil {
    private ProjectRootsUtil() {
    }

    public static boolean isSourceRoot(PsiDirectory psiDirectory) {
        return ProjectRootsUtil.isSourceRoot(psiDirectory.getVirtualFile(), psiDirectory.getProject());
    }

    public static boolean isSourceRoot(VirtualFile directoryFile, Project project) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        return directoryFile.equals(fileIndex.getSourceRootForFile(directoryFile));
    }

    public static boolean isInSource(@NotNull PsiDirectory directory) {
        if (directory == null) {
            ProjectRootsUtil.$$$reportNull$$$0(0);
        }
        return ProjectRootsUtil.isInSource(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean isInSource(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        if (directoryFile == null) {
            ProjectRootsUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ProjectRootsUtil.$$$reportNull$$$0(2);
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        return projectFileIndex.isInSourceContent(directoryFile);
    }

    public static boolean isInTestSource(@NotNull PsiFile file) {
        VirtualFile vFile;
        if (file == null) {
            ProjectRootsUtil.$$$reportNull$$$0(3);
        }
        return (vFile = file.getVirtualFile()) != null && ProjectRootsUtil.isInTestSource(vFile, file.getProject());
    }

    public static boolean isInTestSource(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        if (directoryFile == null) {
            ProjectRootsUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ProjectRootsUtil.$$$reportNull$$$0(5);
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        return projectFileIndex.isInTestSourceContent(directoryFile);
    }

    public static boolean isModuleSourceRoot(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            ProjectRootsUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ProjectRootsUtil.$$$reportNull$$$0(7);
        }
        return ProjectRootsUtil.getModuleSourceRoot(virtualFile, project) != null;
    }

    @Nullable
    public static SourceFolder getModuleSourceRoot(@NotNull VirtualFile root, @NotNull Project project) {
        ProjectFileIndex projectFileIndex;
        Module module;
        if (root == null) {
            ProjectRootsUtil.$$$reportNull$$$0(8);
        }
        if (project == null) {
            ProjectRootsUtil.$$$reportNull$$$0(9);
        }
        return (module = (projectFileIndex = ProjectRootManager.getInstance(project).getFileIndex()).getModuleForFile(root)) != null && !module.isDisposed() ? ProjectRootsUtil.findSourceFolder(module, root) : null;
    }

    public static boolean isLibraryRoot(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        ProjectFileIndex projectFileIndex;
        if (directoryFile == null) {
            ProjectRootsUtil.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ProjectRootsUtil.$$$reportNull$$$0(11);
        }
        if ((projectFileIndex = ProjectRootManager.getInstance(project).getFileIndex()).isInLibraryClasses(directoryFile)) {
            VirtualFile parent = directoryFile.getParent();
            return parent == null || !projectFileIndex.isInLibraryClasses(parent);
        }
        return false;
    }

    public static boolean isModuleContentRoot(@NotNull PsiDirectory directory) {
        if (directory == null) {
            ProjectRootsUtil.$$$reportNull$$$0(12);
        }
        return ProjectRootsUtil.isModuleContentRoot(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean isModuleContentRoot(@NotNull VirtualFile directoryFile, @NotNull Project project) {
        if (directoryFile == null) {
            ProjectRootsUtil.$$$reportNull$$$0(13);
        }
        if (project == null) {
            ProjectRootsUtil.$$$reportNull$$$0(14);
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        VirtualFile contentRootForFile = projectFileIndex.getContentRootForFile(directoryFile);
        return directoryFile.equals(contentRootForFile);
    }

    public static String findUnloadedModuleByContentRoot(@NotNull VirtualFile root, @NotNull Project project) {
        DirectoryInfo info;
        if (root == null) {
            ProjectRootsUtil.$$$reportNull$$$0(15);
        }
        if (project == null) {
            ProjectRootsUtil.$$$reportNull$$$0(16);
        }
        if ((info = DirectoryIndex.getInstance(project).getInfoForFile(root)).isExcluded(root) && root.equals(info.getContentRoot()) && info.getUnloadedModuleName() != null) {
            return info.getUnloadedModuleName();
        }
        return null;
    }

    public static String findUnloadedModuleByFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            ProjectRootsUtil.$$$reportNull$$$0(17);
        }
        if (project == null) {
            ProjectRootsUtil.$$$reportNull$$$0(18);
        }
        DirectoryInfo info = DirectoryIndex.getInstance(project).getInfoForFile(file);
        VirtualFile contentRoot = info.getContentRoot();
        if (info.isExcluded(file) && contentRoot != null) {
            DirectoryInfo rootInfo = DirectoryIndex.getInstance(project).getInfoForFile(contentRoot);
            return rootInfo.getUnloadedModuleName();
        }
        return null;
    }

    public static boolean isProjectHome(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            ProjectRootsUtil.$$$reportNull$$$0(19);
        }
        return psiDirectory.getVirtualFile().equals(psiDirectory.getProject().getBaseDir());
    }

    public static boolean isOutsideSourceRoot(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        if (psiFile instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(psiFile.getProject()).getFileIndex();
        return !projectFileIndex.isInSource(file) && !projectFileIndex.isInLibraryClasses(file);
    }

    @Nullable
    public static SourceFolder findSourceFolder(@NotNull Module module, @NotNull VirtualFile root) {
        if (module == null) {
            ProjectRootsUtil.$$$reportNull$$$0(20);
        }
        if (root == null) {
            ProjectRootsUtil.$$$reportNull$$$0(21);
        }
        for (ContentEntry entry : ModuleRootManager.getInstance(module).getContentEntries()) {
            for (SourceFolder folder : entry.getSourceFolders()) {
                if (!root.equals(folder.getFile())) continue;
                return folder;
            }
        }
        return null;
    }

    @Nullable
    public static ExcludeFolder findExcludeFolder(@NotNull Module module, @NotNull VirtualFile root) {
        if (module == null) {
            ProjectRootsUtil.$$$reportNull$$$0(22);
        }
        if (root == null) {
            ProjectRootsUtil.$$$reportNull$$$0(23);
        }
        for (ContentEntry entry : ModuleRootManager.getInstance(module).getContentEntries()) {
            for (ExcludeFolder folder : entry.getExcludeFolders()) {
                if (!root.equals(folder.getFile())) continue;
                return folder;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryFile";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 15: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectRootsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSource";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isInTestSource";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isModuleSourceRoot";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleSourceRoot";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isLibraryRoot";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isModuleContentRoot";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "findUnloadedModuleByContentRoot";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "findUnloadedModuleByFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isProjectHome";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "findSourceFolder";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "findExcludeFolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

