/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.ex;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DefaultColorSchemesManager", defaultStateAsResource=true, storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
public class DefaultColorSchemesManager
implements PersistentStateComponent<Element> {
    private static final String SCHEME_ELEMENT = "scheme";
    private volatile List<DefaultColorsScheme> mySchemes = Collections.emptyList();

    public static DefaultColorSchemesManager getInstance() {
        return ServiceManager.getService(DefaultColorSchemesManager.class);
    }

    @Override
    @Nullable
    public Element getState() {
        return null;
    }

    @Override
    public void loadState(Element state) {
        ArrayList<DefaultColorsScheme> schemes = new ArrayList<DefaultColorsScheme>();
        for (Element schemeElement : state.getChildren(SCHEME_ELEMENT)) {
            boolean isUpdated = false;
            Attribute nameAttr = schemeElement.getAttribute("name");
            if (nameAttr != null) {
                for (DefaultColorsScheme oldScheme : this.mySchemes) {
                    if (!StringUtil.equals(nameAttr.getValue(), oldScheme.getName())) continue;
                    oldScheme.readExternal(schemeElement);
                    schemes.add(oldScheme);
                    isUpdated = true;
                }
            }
            if (isUpdated) continue;
            DefaultColorsScheme newScheme = new DefaultColorsScheme();
            newScheme.readExternal(schemeElement);
            schemes.add(newScheme);
        }
        schemes.add(EmptyColorScheme.INSTANCE);
        this.mySchemes = schemes;
    }

    @NotNull
    public List<DefaultColorsScheme> getAllSchemes() {
        List<DefaultColorsScheme> list = Collections.unmodifiableList(this.mySchemes);
        if (list == null) {
            DefaultColorSchemesManager.$$$reportNull$$$0(0);
        }
        return list;
    }

    public String[] listNames() {
        String[] names = new String[this.mySchemes.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.mySchemes.get(i).getName();
        }
        return names;
    }

    @NotNull
    public DefaultColorsScheme getFirstScheme() {
        DefaultColorsScheme defaultColorsScheme = this.mySchemes.get(0);
        if (defaultColorsScheme == null) {
            DefaultColorSchemesManager.$$$reportNull$$$0(1);
        }
        return defaultColorsScheme;
    }

    @Nullable
    public EditorColorsScheme getScheme(String name) {
        for (DefaultColorsScheme scheme : this.mySchemes) {
            if (!name.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/editor/colors/ex/DefaultColorSchemesManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSchemes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstScheme";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

