/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class InnerClassOnInterfaceInspectionBase
extends BaseInspection {
    public boolean m_ignoreInnerInterfaces = false;

    @Override
    @NotNull
    public String getID() {
        if ("InnerClassOfInterface" == null) {
            InnerClassOnInterfaceInspectionBase.$$$reportNull$$$0(0);
        }
        return "InnerClassOfInterface";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inner.class.on.interface.display.name", new Object[0]);
        if (string == null) {
            InnerClassOnInterfaceInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass parentInterface = (PsiClass)infos[0];
        String interfaceName = parentInterface.getName();
        String string = InspectionGadgetsBundle.message("inner.class.on.interface.problem.descriptor", interfaceName);
        if (string == null) {
            InnerClassOnInterfaceInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassOnInterfaceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/InnerClassOnInterfaceInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class InnerClassOnInterfaceVisitor
    extends BaseInspectionVisitor {
        private InnerClassOnInterfaceVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass[] innerClasses;
            if (aClass == null) {
                InnerClassOnInterfaceVisitor.$$$reportNull$$$0(0);
            }
            if (!aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            for (PsiClass innerClass : innerClasses = aClass.getInnerClasses()) {
                if (!this.isInnerClass(innerClass)) continue;
                this.registerClassError(innerClass, aClass);
            }
        }

        private boolean isInnerClass(PsiClass innerClass) {
            if (innerClass.isEnum()) {
                return false;
            }
            if (innerClass.isAnnotationType()) {
                return false;
            }
            if (innerClass instanceof PsiTypeParameter || innerClass instanceof PsiAnonymousClass) {
                return false;
            }
            return !innerClass.isInterface() || !InnerClassOnInterfaceInspectionBase.this.m_ignoreInnerInterfaces;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/InnerClassOnInterfaceInspectionBase$InnerClassOnInterfaceVisitor", "visitClass"));
        }
    }
}

