/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CyclomaticComplexityVisitor
extends JavaRecursiveElementWalkingVisitor {
    private int m_complexity = 1;

    @Override
    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(0);
        }
    }

    @Override
    public void visitForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(1);
        }
        super.visitForStatement(statement);
        ++this.m_complexity;
    }

    @Override
    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(2);
        }
        super.visitForeachStatement(statement);
        ++this.m_complexity;
    }

    @Override
    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(3);
        }
        super.visitIfStatement(statement);
        ++this.m_complexity;
    }

    @Override
    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(4);
        }
        super.visitDoWhileStatement(statement);
        ++this.m_complexity;
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression) {
        super.visitConditionalExpression(expression);
        ++this.m_complexity;
    }

    @Override
    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(5);
        }
        super.visitSwitchStatement(statement);
        PsiCodeBlock body = statement.getBody();
        if (body == null) {
            return;
        }
        PsiStatement[] statements = body.getStatements();
        boolean pendingLabel = false;
        for (PsiStatement child : statements) {
            if (child instanceof PsiSwitchLabelStatement) {
                if (!pendingLabel) {
                    ++this.m_complexity;
                }
                pendingLabel = true;
                continue;
            }
            pendingLabel = false;
        }
    }

    @Override
    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(6);
        }
        super.visitWhileStatement(statement);
        ++this.m_complexity;
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        super.visitPolyadicExpression(expression);
        IElementType token = expression.getOperationTokenType();
        if (token.equals(JavaTokenType.ANDAND) || token.equals(JavaTokenType.OROR)) {
            this.m_complexity += expression.getOperands().length - 1;
        }
    }

    @Override
    public void visitCatchSection(PsiCatchSection section) {
        super.visitCatchSection(section);
        ++this.m_complexity;
    }

    public int getComplexity() {
        return this.m_complexity;
    }

    public void reset() {
        this.m_complexity = 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/classmetrics/CyclomaticComplexityVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnonymousClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForeachStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIfStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDoWhileStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchStatement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhileStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

