/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageTokenSeparatorGenerators;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.NotNullFunction;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeEditUtil {
    private static final Key<Boolean> GENERATED_FLAG = new Key("GENERATED_FLAG");
    private static final Key<Integer> INDENT_INFO = new Key("INDENT_INFO");
    private static final Key<Boolean> REFORMAT_BEFORE_KEY = new Key("REFORMAT_BEFORE_KEY");
    private static final Key<Boolean> REFORMAT_KEY = new Key("REFORMAT_KEY");
    private static final ThreadLocal<Boolean> ALLOW_TO_MARK_NODES_TO_REFORMAT = ThreadLocal.withInitial(() -> Boolean.TRUE);
    private static final ThreadLocal<Boolean> ALLOW_NODES_REFORMATTING = ThreadLocal.withInitial(() -> Boolean.TRUE);
    private static final ThreadLocal<NotNullFunction<ASTNode, Boolean>> NODE_REFORMAT_STRATEGY = new ThreadLocal();

    private CodeEditUtil() {
    }

    public static void addChild(ASTNode parent, ASTNode child, ASTNode anchorBefore) {
        CodeEditUtil.addChildren(parent, child, child, anchorBefore);
    }

    public static void removeChild(ASTNode parent, @NotNull ASTNode child) {
        if (child == null) {
            CodeEditUtil.$$$reportNull$$$0(0);
        }
        CodeEditUtil.removeChildren(parent, child, child);
    }

    public static ASTNode addChildren(ASTNode parent, @NotNull ASTNode first, @NotNull ASTNode last, ASTNode anchorBefore) {
        ASTNode anchorPrev;
        if (first == null) {
            CodeEditUtil.$$$reportNull$$$0(1);
        }
        if (last == null) {
            CodeEditUtil.$$$reportNull$$$0(2);
        }
        ASTNode lastChild = last.getTreeNext();
        for (ASTNode current = first; current != lastChild; current = current.getTreeNext()) {
            CodeEditUtil.saveWhitespacesInfo(current);
        }
        if (anchorBefore != null && CodeEditUtil.isComment(anchorBefore.getElementType()) && (anchorPrev = anchorBefore.getTreePrev()) != null && anchorPrev.getElementType() == TokenType.WHITE_SPACE) {
            anchorBefore = anchorPrev;
        }
        parent.addChildren(first, lastChild, anchorBefore);
        ASTNode firstAddedLeaf = CodeEditUtil.findFirstLeaf(first, last);
        ASTNode prevLeaf = TreeUtil.prevLeaf(first);
        ASTNode result = first;
        if (firstAddedLeaf != null) {
            ASTNode lastAddedLeaf;
            ASTNode placeHolderEnd = CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, firstAddedLeaf, CodeEditUtil.isFormattingRequired(prevLeaf, first), false);
            if (placeHolderEnd != prevLeaf && first == firstAddedLeaf) {
                result = placeHolderEnd;
            }
            if ((placeHolderEnd = CodeEditUtil.makePlaceHolderBetweenTokens(lastAddedLeaf = CodeEditUtil.findLastLeaf(first, last), TreeUtil.nextLeaf(last), true, false)) != lastAddedLeaf && lastAddedLeaf == first) {
                result = placeHolderEnd;
            }
        } else {
            CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, TreeUtil.nextLeaf(last), CodeEditUtil.isFormattingRequired(prevLeaf, first), false);
        }
        return result;
    }

    private static boolean isComment(IElementType type) {
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(type.getLanguage());
        return def != null && def.getCommentTokens().contains(type);
    }

    private static boolean isFormattingRequired(ASTNode prevLeaf, ASTNode first) {
        while (first != null) {
            for (ASTNode current = prevLeaf; current != null; current = current.getTreeParent()) {
                if (current.getTreeNext() != first) continue;
                return true;
            }
            ASTNode parent = first.getTreeParent();
            if (parent == null || !parent.getTextRange().equals(first.getTextRange())) break;
            first = parent;
        }
        return false;
    }

    public static void saveWhitespacesInfo(ASTNode first) {
        if (first == null || CodeEditUtil.isNodeGenerated(first) || CodeEditUtil.getOldIndentation(first) >= 0) {
            return;
        }
        PsiElement psiElement = first.getPsi();
        if (psiElement == null) {
            return;
        }
        PsiFile file = psiElement.getContainingFile();
        CodeEditUtil.setOldIndentation((TreeElement)first, IndentHelper.getInstance().getIndent(file.getProject(), file.getFileType(), first));
    }

    public static int getOldIndentation(ASTNode node) {
        if (node == null) {
            return -1;
        }
        Integer stored = node.getCopyableUserData(INDENT_INFO);
        return stored != null ? stored : -1;
    }

    public static void removeChildren(ASTNode parent, @NotNull ASTNode first, @NotNull ASTNode last) {
        TreeElement child;
        if (first == null) {
            CodeEditUtil.$$$reportNull$$$0(3);
        }
        if (last == null) {
            CodeEditUtil.$$$reportNull$$$0(4);
        }
        boolean tailingElement = last.getStartOffset() + last.getTextLength() == parent.getStartOffset() + parent.getTextLength();
        boolean forceReformat = CodeEditUtil.needToForceReformat(parent, first, last);
        CodeEditUtil.saveWhitespacesInfo(first);
        for (child = (TreeElement)first; child != null && child != last; child = child.getTreeNext()) {
        }
        assert (child == last) : last + " is not a successor of " + first + " in the .getTreeNext() chain";
        ASTNode prevLeaf = TreeUtil.prevLeaf(first);
        ASTNode nextLeaf = TreeUtil.nextLeaf(first);
        parent.removeRange(first, last.getTreeNext());
        ASTNode nextLeafToAdjust = nextLeaf;
        if (nextLeafToAdjust != null && prevLeaf != null && nextLeafToAdjust.getTreeParent() == null) {
            nextLeafToAdjust = prevLeaf.getTreeNext();
        }
        CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, nextLeafToAdjust, forceReformat, tailingElement);
    }

    private static boolean needToForceReformat(ASTNode parent, ASTNode first, ASTNode last) {
        return parent == null || first.getStartOffset() != parent.getStartOffset() || parent.getText().trim().length() == CodeEditUtil.getTrimmedTextLength(first, last) && CodeEditUtil.needToForceReformat(parent.getTreeParent(), parent, parent);
    }

    private static int getTrimmedTextLength(ASTNode first, ASTNode last) {
        StringBuilder buffer = new StringBuilder();
        while (first != last.getTreeNext()) {
            buffer.append(first.getText());
            first = first.getTreeNext();
        }
        return buffer.toString().trim().length();
    }

    public static void replaceChild(ASTNode parent, @NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            CodeEditUtil.$$$reportNull$$$0(5);
        }
        if (newChild == null) {
            CodeEditUtil.$$$reportNull$$$0(6);
        }
        CodeEditUtil.saveWhitespacesInfo(oldChild);
        CodeEditUtil.saveWhitespacesInfo(newChild);
        LeafElement oldFirst = TreeUtil.findFirstLeaf(oldChild);
        parent.replaceChild(oldChild, newChild);
        LeafElement firstLeaf = TreeUtil.findFirstLeaf(newChild);
        ASTNode prevToken = TreeUtil.prevLeaf(newChild);
        if (firstLeaf != null) {
            ASTNode nextLeaf = TreeUtil.nextLeaf(newChild);
            CodeEditUtil.makePlaceHolderBetweenTokens(prevToken, firstLeaf, CodeEditUtil.isFormattingRequired(prevToken, newChild), false);
            if (nextLeaf != null && !CharArrayUtil.containLineBreaks(nextLeaf.getText())) {
                CodeEditUtil.makePlaceHolderBetweenTokens(TreeUtil.prevLeaf(nextLeaf), nextLeaf, false, false);
            }
        } else {
            ASTNode whitespaceNode;
            if (oldFirst != null && prevToken == null && (whitespaceNode = newChild.getTreeNext()) != null && whitespaceNode.getElementType() == TokenType.WHITE_SPACE) {
                parent.removeChild(whitespaceNode);
            }
            CodeEditUtil.makePlaceHolderBetweenTokens(prevToken, TreeUtil.nextLeaf(newChild), CodeEditUtil.isFormattingRequired(prevToken, newChild), false);
        }
    }

    @Nullable
    private static ASTNode findFirstLeaf(ASTNode first, ASTNode last) {
        do {
            LeafElement leaf;
            if ((leaf = TreeUtil.findFirstLeaf(first)) != null) {
                return leaf;
            }
            if ((first = first.getTreeNext()) != null) continue;
            return null;
        } while (first != last);
        return null;
    }

    @Nullable
    private static ASTNode findLastLeaf(ASTNode first, ASTNode last) {
        do {
            ASTNode leaf;
            if ((leaf = TreeUtil.findLastLeaf(last)) != null) {
                return leaf;
            }
            if ((last = last.getTreePrev()) != null) continue;
            return null;
        } while (first != last);
        return null;
    }

    @Nullable
    private static ASTNode makePlaceHolderBetweenTokens(ASTNode left, ASTNode right, boolean forceReformat, boolean normalizeTrailingWS) {
        if (right == null) {
            return left;
        }
        CodeEditUtil.markToReformatBefore(right, false);
        if (left == null) {
            CodeEditUtil.markToReformatBefore(right, true);
        } else if (left.getElementType() == TokenType.WHITE_SPACE && left.getTreeNext() == null && normalizeTrailingWS) {
            ASTNode prevLeaf = TreeUtil.prevLeaf(left);
            left.getTreeParent().removeChild(left);
            CodeEditUtil.markToReformatBeforeOrInsertWhitespace(prevLeaf, right);
            left = right;
        } else if (left.getElementType() == TokenType.WHITE_SPACE && right.getElementType() == TokenType.WHITE_SPACE) {
            int rightBlankLines;
            boolean leaveRightText;
            int leftBlankLines = CodeEditUtil.getBlankLines(left.getText());
            boolean bl = leaveRightText = leftBlankLines < (rightBlankLines = CodeEditUtil.getBlankLines(right.getText()));
            String text = leftBlankLines == 0 && rightBlankLines == 0 ? left.getText() + right.getText() : (leaveRightText ? right.getText() : left.getText());
            if (leaveRightText || forceReformat) {
                LeafElement merged = ASTFactory.whitespace(text);
                if (!leaveRightText) {
                    left.getTreeParent().replaceChild(left, merged);
                    right.getTreeParent().removeChild(right);
                } else {
                    right.getTreeParent().replaceChild(right, merged);
                    left.getTreeParent().removeChild(left);
                }
                left = merged;
            } else {
                right.getTreeParent().removeChild(right);
            }
        } else if (left.getElementType() != TokenType.WHITE_SPACE || forceReformat) {
            if (right.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.markWhitespaceForReformat(right);
            } else if (left.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.markWhitespaceForReformat(left);
            } else {
                CodeEditUtil.markToReformatBeforeOrInsertWhitespace(left, right);
            }
        }
        return left;
    }

    private static void markWhitespaceForReformat(ASTNode right) {
        String text = right.getText();
        LeafElement merged = ASTFactory.whitespace(text);
        right.getTreeParent().replaceChild(right, merged);
    }

    private static void markToReformatBeforeOrInsertWhitespace(ASTNode left, @NotNull ASTNode right) {
        if (right == null) {
            CodeEditUtil.$$$reportNull$$$0(7);
        }
        Language leftLang = left != null ? PsiUtilCore.getNotAnyLanguage(left) : null;
        Language rightLang = PsiUtilCore.getNotAnyLanguage(right);
        ASTNode generatedWhitespace = null;
        if (leftLang != null && leftLang.isKindOf(rightLang)) {
            generatedWhitespace = ((TokenSeparatorGenerator)LanguageTokenSeparatorGenerators.INSTANCE.forLanguage(leftLang)).generateWhitespaceBetweenTokens(left, right);
        } else if (rightLang.isKindOf(leftLang)) {
            generatedWhitespace = ((TokenSeparatorGenerator)LanguageTokenSeparatorGenerators.INSTANCE.forLanguage(rightLang)).generateWhitespaceBetweenTokens(left, right);
        }
        if (generatedWhitespace != null) {
            TreeUtil.CommonParentState parentState = new TreeUtil.CommonParentState();
            TreeUtil.prevLeaf((TreeElement)right, parentState);
            parentState.nextLeafBranchStart.getTreeParent().addChild(generatedWhitespace, parentState.nextLeafBranchStart);
        } else {
            CodeEditUtil.markToReformatBefore(right, true);
        }
    }

    public static void markToReformatBefore(ASTNode right, boolean value) {
        right.putCopyableUserData(REFORMAT_BEFORE_KEY, value ? Boolean.valueOf(true) : null);
    }

    private static int getBlankLines(String text) {
        int result = 0;
        int currentIndex = -1;
        while ((currentIndex = text.indexOf(10, currentIndex + 1)) >= 0) {
            ++result;
        }
        return result;
    }

    public static boolean isNodeGenerated(ASTNode node) {
        return node == null || node.getCopyableUserData(GENERATED_FLAG) != null;
    }

    public static void setNodeGenerated(ASTNode next, boolean value) {
        if (next == null) {
            return;
        }
        next.putCopyableUserData(GENERATED_FLAG, value ? Boolean.valueOf(true) : null);
    }

    public static void setNodeGeneratedRecursively(ASTNode next, boolean value) {
        if (next == null) {
            return;
        }
        CodeEditUtil.setNodeGenerated(next, value);
        for (ASTNode child = next.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            CodeEditUtil.setNodeGeneratedRecursively(child, value);
        }
    }

    public static void setOldIndentation(TreeElement treeElement, int oldIndentation) {
        if (treeElement == null) {
            return;
        }
        treeElement.putCopyableUserData(INDENT_INFO, oldIndentation >= 0 ? Integer.valueOf(oldIndentation) : null);
    }

    public static boolean isMarkedToReformatBefore(TreeElement element) {
        return element.getCopyableUserData(REFORMAT_BEFORE_KEY) != null;
    }

    @Nullable
    public static PsiElement createLineFeed(PsiManager manager) {
        return Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n", 0, 1, null, manager).getPsi();
    }

    public static boolean isMarkedToReformat(ASTNode node) {
        if (node.getCopyableUserData(REFORMAT_KEY) == null || !CodeEditUtil.isSuspendedNodesReformattingAllowed()) {
            return false;
        }
        NotNullFunction<ASTNode, Boolean> strategy = NODE_REFORMAT_STRATEGY.get();
        return strategy == null || strategy.fun(node) != false;
    }

    public static void markToReformat(ASTNode node, boolean value) {
        if (ALLOW_TO_MARK_NODES_TO_REFORMAT.get().booleanValue()) {
            node.putCopyableUserData(REFORMAT_KEY, value ? Boolean.valueOf(true) : null);
        }
    }

    public static void allowToMarkNodesForPostponedFormatting(boolean allow) {
        ALLOW_TO_MARK_NODES_TO_REFORMAT.set(allow);
    }

    public static boolean isSuspendedNodesReformattingAllowed() {
        return ALLOW_NODES_REFORMATTING.get();
    }

    public static void setAllowSuspendNodesReformatting(boolean allow) {
        ALLOW_NODES_REFORMATTING.set(allow);
    }

    public static void setNodeReformatStrategy(@Nullable NotNullFunction<ASTNode, Boolean> strategy) {
        NODE_REFORMAT_STRATEGY.set(strategy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChild";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeEditUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "removeChild";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addChildren";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceChild";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "markToReformatBeforeOrInsertWhitespace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

