/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.DeprecationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MarkedForRemovalInspection
extends DeprecationInspectionBase {
    public MarkedForRemovalInspection() {
        this.IGNORE_IN_SAME_OUTERMOST_CLASS = true;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            MarkedForRemovalInspection.$$$reportNull$$$0(0);
        }
        if ((file = holder.getFile()) instanceof PsiJavaFile && ((PsiJavaFile)file).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9)) {
            HighlightSeverity severity = MarkedForRemovalInspection.getCurrentSeverity(file);
            DeprecationInspectionBase.DeprecationElementVisitor deprecationElementVisitor = new DeprecationInspectionBase.DeprecationElementVisitor(holder, false, false, false, false, this.IGNORE_IN_SAME_OUTERMOST_CLASS, true, severity);
            if (deprecationElementVisitor == null) {
                MarkedForRemovalInspection.$$$reportNull$$$0(1);
            }
            return deprecationElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            MarkedForRemovalInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DeprecationUtil.FOR_REMOVAL_DISPLAY_NAME;
        if (string == null) {
            MarkedForRemovalInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            MarkedForRemovalInspection.$$$reportNull$$$0(4);
        }
        return "";
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("MarkedForRemoval" == null) {
            MarkedForRemovalInspection.$$$reportNull$$$0(5);
        }
        return "MarkedForRemoval";
    }

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    @NonNls
    public String getID() {
        if ("removal" == null) {
            MarkedForRemovalInspection.$$$reportNull$$$0(6);
        }
        return "removal";
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        MarkedForRemovalInspection.addSameOutermostClassCheckBox(panel);
        return panel;
    }

    private static HighlightSeverity getCurrentSeverity(@NotNull PsiFile file) {
        if (file == null) {
            MarkedForRemovalInspection.$$$reportNull$$$0(7);
        }
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.find("MarkedForRemoval");
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(file.getProject()).getCurrentProfile();
        HighlightDisplayLevel displayLevel = profile2.getErrorLevel(highlightDisplayKey, file);
        return displayLevel.getSeverity();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/deprecation/MarkedForRemovalInspection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/deprecation/MarkedForRemovalInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentSeverity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

