/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedLibraries;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractDependencyVisitor;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModuleProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedLibrariesInspection
extends GlobalInspectionTool {
    private static final Logger LOG = Logger.getInstance(UnusedLibrariesInspection.class);
    public boolean IGNORE_LIBRARY_PARTS = true;

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Don't report unused jars inside used library", this, "IGNORE_LIBRARY_PARTS");
    }

    @Override
    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(0);
        }
        return new UnusedLibraryGraphAnnotator(refManager);
    }

    @Override
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(5);
        }
        if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            Module module = refModule.getModule();
            VirtualFile[] givenRoots = OrderEnumerator.orderEntries(module).withoutSdk().withoutModuleSourceEntries().withoutDepModules().classes().usingCache().getRoots();
            if (givenRoots.length == 0) {
                return null;
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            Set<VirtualFile> usedRoots = refModule.getUserData(UnusedLibraryGraphAnnotator.USED_LIBRARY_ROOTS);
            if (usedRoots != null) {
                UnusedLibrariesInspection.appendUsedRootDependencies(usedRoots, givenRoots);
            }
            ArrayList<CommonProblemDescriptor> result = new ArrayList<CommonProblemDescriptor>();
            for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
                boolean allRootsUnused;
                if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).isExported() || ((LibraryOrderEntry)entry).getScope() == DependencyScope.RUNTIME) continue;
                HashSet<VirtualFile> files = new HashSet<VirtualFile>(Arrays.asList(((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES)));
                boolean bl = allRootsUnused = usedRoots == null || !files.removeAll(usedRoots);
                if (allRootsUnused) {
                    String message = InspectionsBundle.message("unused.library.problem.descriptor", entry.getPresentableName());
                    result.add(manager.createProblemDescriptor(message, module, new RemoveUnusedLibrary(entry.getPresentableName(), null)));
                    continue;
                }
                if (files.isEmpty() || this.IGNORE_LIBRARY_PARTS) continue;
                String unusedLibraryRoots = StringUtil.join(files, file -> file.getPresentableName(), ",");
                String message = InspectionsBundle.message("unused.library.roots.problem.descriptor", unusedLibraryRoots, entry.getPresentableName());
                CommonProblemDescriptor descriptor = ((LibraryOrderEntry)entry).isModuleLevel() ? manager.createProblemDescriptor(message, module, new RemoveUnusedLibrary(entry.getPresentableName(), files)) : manager.createProblemDescriptor(message, new QuickFix[0]);
                result.add(descriptor);
            }
            return result.isEmpty() ? null : result.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    private static void appendUsedRootDependencies(@NotNull Set<VirtualFile> usedRoots, final @NotNull VirtualFile[] givenRoots) {
        if (usedRoots == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(6);
        }
        if (givenRoots == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(7);
        }
        THashMap fromClasses = new THashMap();
        THashMap toClasses = new THashMap();
        UnusedLibrariesInspection.collectClassesPerRoots(givenRoots, (Map<VirtualFile, Set<String>>)fromClasses, (Map<VirtualFile, Set<String>>)toClasses);
        Graph<VirtualFile> graph = GraphGenerator.generate(new InboundSemiGraph<VirtualFile>((Map)fromClasses, (Map)toClasses){
            final /* synthetic */ Map val$fromClasses;
            final /* synthetic */ Map val$toClasses;
            {
                this.val$fromClasses = map;
                this.val$toClasses = map2;
            }

            @Override
            public Collection<VirtualFile> getNodes() {
                return Arrays.asList(givenRoots);
            }

            @Override
            public Iterator<VirtualFile> getIn(VirtualFile n) {
                Set classesInCurrentRoot = (Set)this.val$fromClasses.get(n);
                return this.val$toClasses.entrySet().stream().filter(entry -> ContainerUtil.intersects((Collection)entry.getValue(), classesInCurrentRoot)).map(entry -> (VirtualFile)entry.getKey()).collect(Collectors.toSet()).iterator();
            }
        });
        GraphAlgorithms algorithms = GraphAlgorithms.getInstance();
        HashSet dependencies = new HashSet();
        for (VirtualFile root : usedRoots) {
            algorithms.collectOutsRecursively(graph, (Object)root, dependencies);
        }
        usedRoots.addAll(dependencies);
    }

    private static void collectClassesPerRoots(VirtualFile[] givenRoots, Map<VirtualFile, Set<String>> fromClasses, Map<VirtualFile, Set<String>> toClasses) {
        for (VirtualFile root : givenRoots) {
            THashSet fromClassNames = new THashSet();
            THashSet toClassNames = new THashSet();
            VfsUtilCore.iterateChildrenRecursively(root, null, arg_0 -> UnusedLibrariesInspection.lambda$collectClassesPerRoots$1((Set)toClassNames, (Set)fromClassNames, arg_0));
            toClassNames.removeAll((Collection<?>)fromClassNames);
            fromClasses.put(root, (Set<String>)fromClassNames);
            toClasses.put(root, (Set<String>)toClassNames);
        }
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("unused.library.display.name", new Object[0]);
        if (string == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        if ("UnusedLibrary" == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(10);
        }
        return "UnusedLibrary";
    }

    @Override
    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new RemoveUnusedLibrary(hint, null);
    }

    @Override
    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            UnusedLibrariesInspection.$$$reportNull$$$0(11);
        }
        if (fix instanceof RemoveUnusedLibrary && ((RemoveUnusedLibrary)fix).myFiles == null) {
            return ((RemoveUnusedLibrary)fix).myLibraryName;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$collectClassesPerRoots$1(final Set toClassNames, Set fromClassNames, VirtualFile fileOrDir) {
        if (!fileOrDir.isDirectory() && fileOrDir.getName().endsWith(".class")) {
            AbstractDependencyVisitor visitor = new AbstractDependencyVisitor(){

                @Override
                protected void addClassName(String name) {
                    if (!name.startsWith("java.") && !name.startsWith("javax.")) {
                        toClassNames.add(name);
                    }
                }
            };
            try {
                visitor.processStream(fileOrDir.getInputStream());
                fromClassNames.add(visitor.getCurrentClassName());
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedRoots";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "givenRoots";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendUsedRootDependencies";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnusedLibraryGraphAnnotator
    extends RefGraphAnnotator {
        public static final Key<Set<VirtualFile>> USED_LIBRARY_ROOTS = Key.create("inspection.dependencies");
        private final ProjectFileIndex myFileIndex;
        private final RefManager myManager;

        public UnusedLibraryGraphAnnotator(RefManager manager) {
            this.myManager = manager;
            this.myFileIndex = ProjectRootManager.getInstance(manager.getProject()).getFileIndex();
        }

        @Override
        public void onMarkReferenced(PsiElement what, PsiElement from, boolean referencedFromClassInitializer) {
            if (what != null && from != null) {
                RefModule refModule;
                Module fromModule;
                VirtualFile libraryClassRoot;
                VirtualFile containingDir;
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile(what);
                VirtualFile virtualFile2 = containingDir = virtualFile != null ? virtualFile.getParent() : null;
                if (containingDir != null && (libraryClassRoot = this.myFileIndex.getClassRootForFile(containingDir)) != null && (fromModule = ModuleUtilCore.findModuleForPsiElement(from)) != null && (refModule = this.myManager.getRefModule(fromModule)) != null) {
                    Set<VirtualFile> usedRoots = refModule.getUserData(USED_LIBRARY_ROOTS);
                    if (usedRoots == null) {
                        usedRoots = new HashSet<VirtualFile>();
                        refModule.putUserData(USED_LIBRARY_ROOTS, usedRoots);
                    }
                    usedRoots.add(libraryClassRoot);
                }
            }
        }
    }

    private static class RemoveUnusedLibrary
    implements QuickFix<ModuleProblemDescriptor> {
        private final Set<VirtualFile> myFiles;
        private String myLibraryName;

        public RemoveUnusedLibrary(String libraryName, Set<VirtualFile> files) {
            this.myLibraryName = libraryName;
            this.myFiles = files;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.myFiles == null ? InspectionsBundle.message("detach.library.quickfix.name", new Object[0]) : InspectionsBundle.message("detach.library.roots.quickfix.name", new Object[0]);
            if (string == null) {
                RemoveUnusedLibrary.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ModuleProblemDescriptor descriptor) {
            if (project == null) {
                RemoveUnusedLibrary.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveUnusedLibrary.$$$reportNull$$$0(2);
            }
            Module module = descriptor.getModule();
            ModifiableRootModel model = ModuleRootManager.getInstance(module).getModifiableModel();
            for (OrderEntry entry : model.getOrderEntries()) {
                if (!(entry instanceof LibraryOrderEntry) || !Comparing.strEqual(entry.getPresentableName(), this.myLibraryName)) continue;
                if (this.myFiles == null) {
                    model.removeOrderEntry(entry);
                    continue;
                }
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (library == null) continue;
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                for (VirtualFile file : this.myFiles) {
                    modifiableModel.removeRoot(file.getUrl(), OrderRootType.CLASSES);
                }
                modifiableModel.commit();
            }
            model.commit();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection$RemoveUnusedLibrary";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection$RemoveUnusedLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

