/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TreeElementWrapper
extends CachingChildrenTreeNode<TreeElement> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.util.treeView.smartTree.TreeElementWrapper");

    public TreeElementWrapper(Project project, TreeElement value, TreeModel treeModel) {
        super(project, value, treeModel);
    }

    @Override
    public void copyFromNewInstance(@NotNull CachingChildrenTreeNode oldInstance) {
        if (oldInstance == null) {
            TreeElementWrapper.$$$reportNull$$$0(0);
        }
    }

    @Override
    public void update(PresentationData presentation) {
        if (((StructureViewTreeElement)this.getValue()).getValue() != null) {
            presentation.updateFrom(((TreeElement)this.getValue()).getPresentation());
        }
    }

    @Override
    public void initChildren() {
        Object[] children;
        this.clearChildren();
        TreeElement value = (TreeElement)this.getValue();
        for (TreeElement treeElement : children = value.getChildren()) {
            if (treeElement == null) {
                LOG.error(value + " returned null child: " + Arrays.toString(children));
            }
            this.addSubElement(this.createChildNode(treeElement));
        }
        if (this.myTreeModel instanceof ProvidingTreeModel) {
            Collection<NodeProvider> originalProviders = ((ProvidingTreeModel)this.myTreeModel).getNodeProviders();
            List<NodeProvider> providers = DumbService.getInstance(this.myProject).filterByDumbAwareness(originalProviders);
            for (NodeProvider nodeProvider : providers) {
                if (!((ProvidingTreeModel)this.myTreeModel).isEnabled(nodeProvider)) continue;
                Collection nodes = nodeProvider.provideNodes(value);
                for (TreeElement node : nodes) {
                    if (node == null) {
                        LOG.error(nodeProvider + " returned null node: " + nodes);
                    }
                    this.addSubElement(this.createChildNode(node));
                }
            }
        }
    }

    @Override
    protected void performTreeActions() {
        this.filterChildren(this.myTreeModel.getFilters());
        this.groupChildren(this.myTreeModel.getGroupers());
        this.sortChildren(this.myTreeModel.getSorters());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldInstance", "com/intellij/ide/util/treeView/smartTree/TreeElementWrapper", "copyFromNewInstance"));
    }
}

