/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public abstract class DependencyVisitorFactory {
    private static final LanguageExtension<DependencyVisitorFactory> EP_NAME = new LanguageExtension("com.intellij.packageDependencies.visitor");

    @NotNull
    public abstract PsiElementVisitor getVisitor(@NotNull DependenciesBuilder.DependencyProcessor var1, @NotNull VisitorOptions var2);

    @NotNull
    public static PsiElementVisitor createVisitor(@NotNull PsiFile file, @NotNull DependenciesBuilder.DependencyProcessor processor, @NotNull VisitorOptions options) {
        DependencyVisitorFactory factory;
        if (file == null) {
            DependencyVisitorFactory.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            DependencyVisitorFactory.$$$reportNull$$$0(1);
        }
        if (options == null) {
            DependencyVisitorFactory.$$$reportNull$$$0(2);
        }
        PsiElementVisitor psiElementVisitor = (factory = EP_NAME.forLanguage(file.getLanguage())) != null ? factory.getVisitor(processor, options) : new DefaultVisitor(processor);
        if (psiElementVisitor == null) {
            DependencyVisitorFactory.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packageDependencies/DependencyVisitorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packageDependencies/DependencyVisitorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefaultVisitor
    extends PsiRecursiveElementVisitor {
        private final DependenciesBuilder.DependencyProcessor myProcessor;

        public DefaultVisitor(@NotNull DependenciesBuilder.DependencyProcessor processor) {
            if (processor == null) {
                DefaultVisitor.$$$reportNull$$$0(0);
            }
            this.myProcessor = processor;
        }

        @Override
        public void visitElement(PsiElement element) {
            super.visitElement(element);
            for (PsiReference ref : element.getReferences()) {
                PsiElement resolved = ref.resolve();
                if (resolved == null) continue;
                this.myProcessor.process(ref.getElement(), resolved);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packageDependencies/DependencyVisitorFactory$DefaultVisitor", "<init>"));
        }
    }

    public static abstract class VisitorOptions {
        public static final VisitorOptions SKIP_IMPORTS = new VisitorOptions(){

            @Override
            public boolean skipImports() {
                return true;
            }
        };
        public static final VisitorOptions INCLUDE_IMPORTS = new VisitorOptions(){

            @Override
            public boolean skipImports() {
                return false;
            }
        };

        public abstract boolean skipImports();

        public static VisitorOptions fromSettings(@NotNull Project project) {
            if (project == null) {
                VisitorOptions.$$$reportNull$$$0(0);
            }
            final DependencyValidationManager manager = DependencyValidationManager.getInstance(project);
            return new VisitorOptions(){

                @Override
                public boolean skipImports() {
                    return manager.skipImportStatements();
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packageDependencies/DependencyVisitorFactory$VisitorOptions", "fromSettings"));
        }
    }
}

