/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSourceFilterScope
extends DelegatingGlobalSearchScope {
    @Nullable
    private final ProjectFileIndex myIndex;
    private final boolean myIncludeVersions;

    public JavaSourceFilterScope(@NotNull GlobalSearchScope delegate) {
        if (delegate == null) {
            JavaSourceFilterScope.$$$reportNull$$$0(0);
        }
        this(delegate, false);
    }

    public JavaSourceFilterScope(@NotNull GlobalSearchScope delegate, boolean includeVersions) {
        if (delegate == null) {
            JavaSourceFilterScope.$$$reportNull$$$0(1);
        }
        super(delegate);
        Project project = this.getProject();
        this.myIndex = project == null ? null : ProjectRootManager.getInstance(project).getFileIndex();
        this.myIncludeVersions = includeVersions;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            JavaSourceFilterScope.$$$reportNull$$$0(2);
        }
        if (!super.contains(file)) {
            return false;
        }
        if (this.myIndex == null) {
            return false;
        }
        if (JavaClassFileType.INSTANCE == file.getFileType()) {
            return this.myIndex.isInLibraryClasses(file) && (this.myIncludeVersions || !JavaSourceFilterScope.isVersioned(file, this.myIndex));
        }
        return this.myIndex.isInSourceContent(file) || this.myBaseScope.isForceSearchingInLibrarySources() && this.myIndex.isInLibrarySource(file);
    }

    private static boolean isVersioned(VirtualFile file, ProjectFileIndex index) {
        VirtualFile root = index.getClassRootForFile(file);
        while ((file = file.getParent()) != null && !file.equals(root)) {
            VirtualFile parent;
            if (!Comparing.equal(file.getNameSequence(), (CharSequence)"versions") || (parent = file.getParent()) == null || !Comparing.equal(parent.getNameSequence(), (CharSequence)"META-INF")) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/JavaSourceFilterScope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

