/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AssertWithSideEffectsInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> resultSetSideEffectMethods = ContainerUtil.newHashSet("next", "first", "last", "absolute", "relative", "previous");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assert.with.side.effects.display.name", new Object[0]);
        if (string == null) {
            AssertWithSideEffectsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assert.with.side.effects.problem.descriptor", new Object[0]);
        if (string == null) {
            AssertWithSideEffectsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertWithSideEffectsVisitor();
    }

    private static boolean methodHasSideEffects(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        MethodSideEffectVisitor visitor = new MethodSideEffectVisitor();
        body.accept(visitor);
        return visitor.hasSideEffects();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/AssertWithSideEffectsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MethodSideEffectVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean hasSideEffects;

        private MethodSideEffectVisitor() {
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            if (this.hasSideEffects) {
                return;
            }
            this.checkExpression(expression.getLExpression());
            super.visitAssignmentExpression(expression);
        }

        @Override
        public void visitUnaryExpression(PsiUnaryExpression expression) {
            if (this.hasSideEffects) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.checkExpression(expression.getOperand());
            }
            super.visitUnaryExpression(expression);
        }

        private void checkExpression(PsiExpression operand) {
            if (!(operand instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiField) {
                this.hasSideEffects = true;
            }
        }

        private boolean hasSideEffects() {
            return this.hasSideEffects;
        }
    }

    private static class SideEffectVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean hasSideEffects;

        private SideEffectVisitor() {
        }

        boolean hasSideEffects() {
            return this.hasSideEffects;
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            this.hasSideEffects = true;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.hasSideEffects) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.hasSideEffects) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            if (AssertWithSideEffectsInspection.methodHasSideEffects(method)) {
                this.hasSideEffects = true;
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !"java.sql.ResultSet".equals(containingClass.getQualifiedName())) {
                return;
            }
            String methodName = method.getName();
            if (resultSetSideEffectMethods.contains(methodName)) {
                this.hasSideEffects = true;
            }
        }

        @Override
        public void visitUnaryExpression(PsiUnaryExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.hasSideEffects = true;
            } else {
                super.visitUnaryExpression(expression);
            }
        }
    }

    private static class AssertWithSideEffectsVisitor
    extends BaseInspectionVisitor {
        private AssertWithSideEffectsVisitor() {
        }

        @Override
        public void visitAssertStatement(PsiAssertStatement statement) {
            super.visitAssertStatement(statement);
            PsiExpression condition = statement.getAssertCondition();
            if (condition == null) {
                return;
            }
            SideEffectVisitor visitor = new SideEffectVisitor();
            condition.accept(visitor);
            if (!visitor.hasSideEffects()) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }
    }
}

