/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchUtils {
    private SwitchUtils() {
    }

    public static int calculateBranchCount(@NotNull PsiSwitchStatement statement) {
        PsiCodeBlock body;
        if (statement == null) {
            SwitchUtils.$$$reportNull$$$0(0);
        }
        if ((body = statement.getBody()) == null) {
            return 0;
        }
        int branches = 0;
        boolean defaultFound = false;
        for (PsiSwitchLabelStatement child : PsiTreeUtil.getChildrenOfTypeAsList(body, PsiSwitchLabelStatement.class)) {
            if (child.isDefaultCase()) {
                defaultFound = true;
                continue;
            }
            ++branches;
        }
        return defaultFound ? -branches : branches;
    }

    @Nullable
    public static PsiExpression getSwitchExpression(PsiIfStatement statement, int minimumBranches, boolean nullSafe, boolean stringEquality) {
        LanguageLevel languageLevel;
        PsiExpression condition = statement.getCondition();
        PsiExpression possibleSwitchExpression = SwitchUtils.determinePossibleSwitchExpressions(condition, languageLevel = PsiUtil.getLanguageLevel(statement), nullSafe, stringEquality);
        if (!SwitchUtils.canBeSwitchExpression(possibleSwitchExpression, languageLevel)) {
            return null;
        }
        int branchCount = 0;
        while (true) {
            ++branchCount;
            if (!SwitchUtils.canBeMadeIntoCase(statement.getCondition(), possibleSwitchExpression, languageLevel, false, stringEquality)) break;
            PsiStatement elseBranch = statement.getElseBranch();
            if (!(elseBranch instanceof PsiIfStatement)) {
                if (elseBranch != null) {
                    ++branchCount;
                }
                if (branchCount < minimumBranches) {
                    return null;
                }
                return possibleSwitchExpression;
            }
            statement = (PsiIfStatement)elseBranch;
        }
        return null;
    }

    private static boolean canBeMadeIntoCase(PsiExpression expression, PsiExpression switchExpression, LanguageLevel languageLevel, boolean nullSafe, boolean stringEquality) {
        expression = ParenthesesUtils.stripParentheses(expression);
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7)) {
            PsiExpression stringSwitchExpression = SwitchUtils.determinePossibleJdk17SwitchExpression(expression, nullSafe);
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, stringSwitchExpression)) {
                return true;
            }
        }
        if (!(expression instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
        IElementType operation = polyadicExpression.getOperationTokenType();
        PsiExpression[] operands = polyadicExpression.getOperands();
        if (operation.equals(JavaTokenType.OROR)) {
            for (PsiExpression operand : operands) {
                if (SwitchUtils.canBeMadeIntoCase(operand, switchExpression, languageLevel, nullSafe, stringEquality)) continue;
                return false;
            }
            return true;
        }
        if (operation.equals(JavaTokenType.EQEQ) && operands.length == 2) {
            return SwitchUtils.canBeCaseLabel(operands[0], languageLevel, stringEquality) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, operands[1]) || SwitchUtils.canBeCaseLabel(operands[1], languageLevel, stringEquality) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, operands[0]);
        }
        return false;
    }

    private static boolean canBeSwitchExpression(PsiExpression expression, LanguageLevel languageLevel) {
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (PsiType.CHAR.equals(type) || PsiType.BYTE.equals(type) || PsiType.SHORT.equals(type) || PsiType.INT.equals(type)) {
            return true;
        }
        if (type instanceof PsiClassType) {
            PsiClassType classType;
            PsiClass aClass;
            if (ExpressionUtils.isAnnotatedNullable(expression)) {
                return false;
            }
            if (type.equalsToText("java.lang.Character") || type.equalsToText("java.lang.Byte") || type.equalsToText("java.lang.Short") || type.equalsToText("java.lang.Integer")) {
                return true;
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5) && (aClass = (classType = (PsiClassType)type).resolve()) != null && aClass.isEnum()) {
                return true;
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7) && type.equalsToText("java.lang.String")) {
                return true;
            }
        }
        return false;
    }

    private static PsiExpression determinePossibleSwitchExpressions(PsiExpression expression, LanguageLevel languageLevel, boolean nullSafe, boolean stringEquality) {
        PsiExpression jdk17Expression;
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            return null;
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7) && (jdk17Expression = SwitchUtils.determinePossibleJdk17SwitchExpression(expression, nullSafe)) != null) {
            return jdk17Expression;
        }
        if (!(expression instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
        IElementType operation = polyadicExpression.getOperationTokenType();
        PsiExpression[] operands = polyadicExpression.getOperands();
        if (operation.equals(JavaTokenType.OROR) && operands.length > 0) {
            return SwitchUtils.determinePossibleSwitchExpressions(operands[0], languageLevel, nullSafe, stringEquality);
        }
        if (operation.equals(JavaTokenType.EQEQ) && operands.length == 2) {
            PsiExpression lhs = ParenthesesUtils.stripParentheses(operands[0]);
            PsiExpression rhs = ParenthesesUtils.stripParentheses(operands[1]);
            if (SwitchUtils.canBeCaseLabel(lhs, languageLevel, stringEquality)) {
                return rhs;
            }
            if (SwitchUtils.canBeCaseLabel(rhs, languageLevel, stringEquality)) {
                return lhs;
            }
        }
        return null;
    }

    private static PsiExpression determinePossibleJdk17SwitchExpression(PsiExpression expression, boolean nullSafe) {
        if (!(expression instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String referenceName = methodExpression.getReferenceName();
        if (!"equals".equals(referenceName)) {
            return null;
        }
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (qualifierExpression == null) {
            return null;
        }
        if (ExpressionUtils.hasStringType(qualifierExpression)) {
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression argument = ExpressionUtils.getOnlyExpressionInList(argumentList);
            if (argument == null) {
                return null;
            }
            PsiType argumentType = argument.getType();
            if (argumentType == null || !argumentType.equalsToText("java.lang.String")) {
                return null;
            }
            if (PsiUtil.isConstantExpression(qualifierExpression)) {
                if (nullSafe && !ExpressionUtils.isAnnotatedNotNull(argument)) {
                    return null;
                }
                return argument;
            }
            if (PsiUtil.isConstantExpression(argument)) {
                return qualifierExpression;
            }
        } else if (qualifierExpression instanceof PsiReferenceExpression && !nullSafe) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiClass)) {
                return null;
            }
            PsiClass aClass = (PsiClass)target;
            if (!"java.util.Objects".equals(aClass.getQualifiedName())) {
                return null;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 2) {
                return null;
            }
            PsiExpression firstArgument = arguments[0];
            PsiExpression secondArgument = arguments[1];
            if (PsiUtil.isConstantExpression(firstArgument)) {
                return secondArgument;
            }
            if (PsiUtil.isConstantExpression(secondArgument)) {
                return firstArgument;
            }
        }
        return null;
    }

    private static boolean canBeCaseLabel(PsiExpression expression, LanguageLevel languageLevel, boolean allowUnsafe) {
        PsiElement referent;
        if (expression == null) {
            return false;
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5) && expression instanceof PsiReferenceExpression && (referent = ((PsiReference)((Object)expression)).resolve()) instanceof PsiEnumConstant) {
            return true;
        }
        PsiType type = expression.getType();
        if (allowUnsafe && languageLevel.isAtLeast(LanguageLevel.JDK_1_7) && TypeUtils.isJavaLangString(type) && PsiUtil.isConstantExpression(expression)) {
            return true;
        }
        return (PsiType.INT.equals(type) || PsiType.SHORT.equals(type) || PsiType.BYTE.equals(type) || PsiType.CHAR.equals(type)) && PsiUtil.isConstantExpression(expression);
    }

    public static String findUniqueLabelName(PsiStatement statement, @NonNls String baseName) {
        PsiMember ancestor = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMember.class);
        if (!SwitchUtils.checkForLabel(baseName, ancestor)) {
            return baseName;
        }
        int val = 1;
        String name;
        while (SwitchUtils.checkForLabel(name = baseName + val, ancestor)) {
            ++val;
        }
        return name;
    }

    private static boolean checkForLabel(String name, PsiElement ancestor) {
        LabelSearchVisitor visitor = new LabelSearchVisitor(name);
        ancestor.accept(visitor);
        return visitor.isUsed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/SwitchUtils", "calculateBranchCount"));
    }

    public static class IfStatementBranch {
        private final Set<String> topLevelVariables = new HashSet<String>(3);
        private final LinkedList<String> comments = new LinkedList();
        private final LinkedList<String> statementComments = new LinkedList();
        private final List<PsiExpression> caseExpressions = new ArrayList<PsiExpression>(3);
        private final PsiStatement statement;
        private final boolean elseBranch;

        public IfStatementBranch(PsiStatement branch, boolean elseBranch) {
            this.statement = branch;
            this.elseBranch = elseBranch;
            this.calculateVariablesDeclared(this.statement);
        }

        public void addComment(String comment) {
            this.comments.addFirst(comment);
        }

        public void addStatementComment(String comment) {
            this.statementComments.addFirst(comment);
        }

        public void addCaseExpression(PsiExpression expression) {
            this.caseExpressions.add(expression);
        }

        public PsiStatement getStatement() {
            return this.statement;
        }

        public List<PsiExpression> getCaseExpressions() {
            return Collections.unmodifiableList(this.caseExpressions);
        }

        public boolean isElse() {
            return this.elseBranch;
        }

        public boolean topLevelDeclarationsConflictWith(IfStatementBranch testBranch) {
            Set<String> topLevel = testBranch.topLevelVariables;
            return IfStatementBranch.intersects(this.topLevelVariables, topLevel);
        }

        private static boolean intersects(Set<String> set1, Set<String> set2) {
            for (String s : set1) {
                if (!set2.contains(s)) continue;
                return true;
            }
            return false;
        }

        public List<String> getComments() {
            return this.comments;
        }

        public List<String> getStatementComments() {
            return this.statementComments;
        }

        public void calculateVariablesDeclared(PsiStatement statement) {
            block4: {
                PsiStatement[] statements;
                block3: {
                    PsiElement[] elements;
                    if (statement == null) {
                        return;
                    }
                    if (!(statement instanceof PsiDeclarationStatement)) break block3;
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
                        PsiVariable variable = (PsiVariable)element;
                        String varName = variable.getName();
                        this.topLevelVariables.add(varName);
                    }
                    break block4;
                }
                if (!(statement instanceof PsiBlockStatement)) break block4;
                PsiBlockStatement block = (PsiBlockStatement)statement;
                PsiCodeBlock codeBlock = block.getCodeBlock();
                for (PsiStatement statement1 : statements = codeBlock.getStatements()) {
                    this.calculateVariablesDeclared(statement1);
                }
            }
        }
    }

    private static class LabelSearchVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final String m_labelName;
        private boolean m_used = false;

        LabelSearchVisitor(String name) {
            this.m_labelName = name;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.m_used) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitLabeledStatement(PsiLabeledStatement statement) {
            PsiIdentifier labelIdentifier = statement.getLabelIdentifier();
            String labelText = labelIdentifier.getText();
            if (labelText.equals(this.m_labelName)) {
                this.m_used = true;
            }
        }

        public boolean isUsed() {
            return this.m_used;
        }
    }
}

