/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.GoToSymbolFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public class ModuleHighlightUtil {
    private static final Attributes.Name MULTI_RELEASE = new Attributes.Name("Multi-Release");

    @Nullable
    static PsiJavaModule getModuleDescriptor(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            return null;
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance(project);
        if (index.isInLibrary(file)) {
            VirtualFile root2 = index.getClassRootForFile(file);
            if (root2 != null) {
                VirtualFile alt;
                VirtualFile descriptorFile = root2.findChild("module-info.class");
                if (descriptorFile == null && (alt = root2.findFileByRelativePath("META-INF/versions/9/module-info.class")) != null && ModuleHighlightUtil.isMultiReleaseJar(root2)) {
                    descriptorFile = alt;
                }
                if (descriptorFile != null) {
                    PsiFile psiFile = PsiManager.getInstance(project).findFile(descriptorFile);
                    if (psiFile instanceof PsiJavaFile) {
                        return ((PsiJavaFile)psiFile).getModuleDeclaration();
                    }
                } else if (root2.getFileSystem() instanceof JarFileSystem && "jar".equalsIgnoreCase(root2.getExtension())) {
                    return LightJavaModule.getModule(PsiManager.getInstance(project), root2);
                }
            } else {
                PsiFile psiFile;
                VirtualFile descriptorFile;
                root2 = index.getSourceRootForFile(file);
                if (root2 != null && (descriptorFile = root2.findChild("module-info.java")) != null && (psiFile = PsiManager.getInstance(project).findFile(descriptorFile)) instanceof PsiJavaFile) {
                    return ((PsiJavaFile)psiFile).getModuleDeclaration();
                }
            }
        } else {
            Module module = index.getModuleForFile(file);
            if (module != null) {
                PsiFile psiFile;
                JavaSourceRootType rootType = index.isInTestSourceContent(file) ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
                List files = ModuleRootManager.getInstance(module).getSourceRoots(rootType).stream().map(root -> root.findChild("module-info.java")).filter(Objects::nonNull).collect(Collectors.toList());
                if (files.size() == 1 && (psiFile = PsiManager.getInstance(project).findFile((VirtualFile)files.get(0))) instanceof PsiJavaFile) {
                    return ((PsiJavaFile)psiFile).getModuleDeclaration();
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMultiReleaseJar(VirtualFile root) {
        if (!(root.getFileSystem() instanceof JarFileSystem)) return false;
        VirtualFile manifest = root.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifest == null) return false;
        try (InputStream stream = manifest.getInputStream();){
            boolean bl = Boolean.valueOf(new Manifest(stream).getMainAttributes().getValue(MULTI_RELEASE));
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static HighlightInfo checkPackageStatement(@NotNull PsiPackageStatement statement, @NotNull PsiFile file, @Nullable PsiJavaModule module) {
        PsiJavaModule origin;
        String packageName;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(2);
        }
        if (PsiUtil.isModuleFile(file)) {
            String message = JavaErrorMessages.message("module.no.package", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createDeleteFix(statement));
            return info;
        }
        if (module != null && (packageName = statement.getPackageName()) != null && (origin = JavaModuleGraphUtil.findOrigin(module, packageName)) != null) {
            String message = JavaErrorMessages.message("module.conflicting.packages", packageName, origin.getName());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileName(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        if (element == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(4);
        }
        if (!"module-info.java".equals(file.getName())) {
            String message = JavaErrorMessages.message("module.file.wrong.name", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createRenameFileFix("module-info.java"));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileDuplicates(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        Project project;
        Collection<VirtualFile> others;
        Module module;
        if (element == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(6);
        }
        if ((module = ModuleHighlightUtil.findModule(file)) != null && (others = FilenameIndex.getVirtualFilesByName(project = file.getProject(), "module-info.java", module.getModuleScope())).size() > 1) {
            String message = JavaErrorMessages.message("module.file.duplicate", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message).create();
            others.stream().map(f -> PsiManager.getInstance(project).findFile((VirtualFile)f)).filter(f -> {
                if (file == null) {
                    ModuleHighlightUtil.$$$reportNull$$$0(20);
                }
                return f != file;
            }).findFirst().ifPresent(duplicate -> QuickFixAction.registerQuickFixAction(info, new GoToSymbolFix((NavigatablePsiElement)duplicate, JavaErrorMessages.message("module.open.duplicate.text", new Object[0]))));
            return info;
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkDuplicateStatements(@NotNull PsiJavaModule module) {
        if (module == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(7);
        }
        List<HighlightInfo> results = ContainerUtil.newSmartList();
        ModuleHighlightUtil.checkDuplicateRefs(module.getRequires(), st -> Optional.ofNullable(st.getReferenceElement()).map(PsiJavaModuleReferenceElement::getReferenceText), "module.duplicate.requires", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getExports(), st -> Optional.ofNullable(st.getPackageReference()).map(ModuleHighlightUtil::refText), "module.duplicate.exports", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getOpens(), st -> Optional.ofNullable(st.getPackageReference()).map(ModuleHighlightUtil::refText), "module.duplicate.opens", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getUses(), st -> Optional.ofNullable(st.getClassReference()).map(ModuleHighlightUtil::qName), "module.duplicate.uses", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getProvides(), st -> Optional.ofNullable(st.getInterfaceReference()).map(ModuleHighlightUtil::qName), "module.duplicate.provides", results);
        List<HighlightInfo> list = results;
        if (list == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static <T extends PsiElement> void checkDuplicateRefs(Iterable<T> statements, Function<T, Optional<String>> ref, @PropertyKey(resourceBundle="messages.JavaErrorMessages") String key, List<HighlightInfo> results) {
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiElement statement : statements) {
            String refText = ref.apply(statement).orElse(null);
            if (refText == null || filter.add((String)refText)) continue;
            String message = JavaErrorMessages.message(key, refText);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createDeleteFix(statement));
            QuickFixAction.registerQuickFixAction(info, MergeModuleStatementsFix.createFix(statement));
            results.add(info);
        }
    }

    @NotNull
    static List<HighlightInfo> checkUnusedServices(@NotNull PsiJavaModule module) {
        if (module == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(9);
        }
        List<HighlightInfo> results = ContainerUtil.newSmartList();
        Set<String> exports = JBIterable.from(module.getExports()).map(st -> ModuleHighlightUtil.refText(st.getPackageReference())).filter(Objects::nonNull).toSet();
        Set<String> uses = JBIterable.from(module.getUses()).map(st -> ModuleHighlightUtil.qName(st.getClassReference())).filter(Objects::nonNull).toSet();
        Module host = ModuleHighlightUtil.findModule(module);
        if (host != null) {
            for (PsiProvidesStatement statement : module.getProvides()) {
                String className;
                String packageName;
                PsiElement target;
                PsiJavaCodeReferenceElement ref = statement.getInterfaceReference();
                if (ref == null || !((target = ref.resolve()) instanceof PsiClass) || ModuleHighlightUtil.findModule(target) != host || exports.contains(packageName = StringUtil.getPackageName(className = ModuleHighlightUtil.qName(ref))) || uses.contains(className)) continue;
                String message = JavaErrorMessages.message("module.service.unused", new Object[0]);
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(ref)).descriptionAndTooltip(message).create());
            }
        }
        List<HighlightInfo> list = results;
        if (list == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static String refText(PsiJavaCodeReferenceElement ref) {
        return ref != null ? PsiNameHelper.getQualifiedClassName(ref.getText(), true) : null;
    }

    private static String qName(PsiJavaCodeReferenceElement ref) {
        return ref != null ? ref.getQualifiedName() : null;
    }

    @Nullable
    static HighlightInfo checkFileLocation(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        VirtualFile root;
        VirtualFile vFile;
        if (element == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(11);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(12);
        }
        if ((vFile = file.getVirtualFile()) != null && (root = ProjectFileIndex.SERVICE.getInstance(file.getProject()).getSourceRootForFile(vFile)) != null && !root.equals(vFile.getParent())) {
            String message = JavaErrorMessages.message("module.file.wrong.location", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(info, new MoveFileFix(vFile, root, QuickFixBundle.message("move.file.to.source.root.text", new Object[0])));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkModuleReference(@Nullable PsiJavaModuleReferenceElement refElement, @NotNull PsiJavaModule container) {
        if (container == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(13);
        }
        if (refElement != null) {
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : refElement.getParent();
            PsiElement target = ref.resolve();
            if (!(target instanceof PsiJavaModule)) {
                return ModuleHighlightUtil.moduleResolveError(refElement, ref);
            }
            if (target == container) {
                String message = JavaErrorMessages.message("module.cyclic.dependence", container.getName());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).descriptionAndTooltip(message).create();
            }
            Collection<PsiJavaModule> cycle = JavaModuleGraphUtil.findCycle((PsiJavaModule)target);
            if (cycle != null && cycle.contains(container)) {
                Stream<String> stream = cycle.stream().map(PsiJavaModule::getName);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    stream = stream.sorted();
                }
                String message = JavaErrorMessages.message("module.cyclic.dependence", stream.collect(Collectors.joining(", ")));
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).descriptionAndTooltip(message).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkHostModuleStrength(@NotNull PsiPackageAccessibilityStatement statement) {
        PsiElement parent;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(14);
        }
        if (statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS && (parent = statement.getParent()) instanceof PsiJavaModule && ((PsiJavaModule)parent).hasModifierProperty("open")) {
            String message = JavaErrorMessages.message("module.opens.in.weak.module", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createModifierListFix((PsiModifierListOwner)parent, "open", false, false));
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createDeleteFix(statement));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPackageReference(@NotNull PsiPackageAccessibilityStatement statement) {
        Module module;
        PsiJavaCodeReferenceElement refElement;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(15);
        }
        if ((refElement = statement.getPackageReference()) != null && (module = ModuleHighlightUtil.findModule(refElement)) != null) {
            HighlightInfoType type;
            PsiElement target = refElement.resolve();
            PsiDirectory[] directories = target instanceof PsiPackage ? ((PsiPackage)target).getDirectories(module.getModuleScope(false)) : null;
            String packageName = ModuleHighlightUtil.refText(refElement);
            HighlightInfoType highlightInfoType = type = statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            if (directories == null || directories.length == 0) {
                String message = JavaErrorMessages.message("package.not.found", packageName);
                return HighlightInfo.newHighlightInfo(type).range(refElement).descriptionAndTooltip(message).create();
            }
            if (PsiUtil.isPackageEmpty(directories, packageName)) {
                String message = JavaErrorMessages.message("package.is.empty", packageName);
                return HighlightInfo.newHighlightInfo(type).range(refElement).descriptionAndTooltip(message).create();
            }
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkPackageAccessTargets(@NotNull PsiPackageAccessibilityStatement statement) {
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(16);
        }
        List<HighlightInfo> results = ContainerUtil.newSmartList();
        THashSet targets = ContainerUtil.newTroveSet();
        for (PsiJavaModuleReferenceElement refElement : statement.getModuleReferences()) {
            String refText = refElement.getReferenceText();
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : statement;
            if (!targets.add((String)refText)) {
                boolean exports = statement.getRole() == PsiPackageAccessibilityStatement.Role.EXPORTS;
                String message = JavaErrorMessages.message(exports ? "module.duplicate.exports.target" : "module.duplicate.opens.target", refText);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).descriptionAndTooltip(message).create();
                QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createDeleteFix(refElement, QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
                results.add(info);
                continue;
            }
            if (ref.multiResolve(true).length != 0) continue;
            String message = JavaErrorMessages.message("module.not.found", refElement.getReferenceText());
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(refElement).descriptionAndTooltip(message).create());
        }
        List<HighlightInfo> list = results;
        if (list == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    static HighlightInfo checkServiceReference(@Nullable PsiJavaCodeReferenceElement refElement) {
        if (refElement != null) {
            PsiElement target = refElement.resolve();
            if (!(target instanceof PsiClass)) {
                String message = JavaErrorMessages.message("cannot.resolve.symbol", refElement.getReferenceName());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).descriptionAndTooltip(message).create();
            }
            if (((PsiClass)target).isEnum()) {
                String message = JavaErrorMessages.message("module.service.enum", ((PsiClass)target).getName());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).descriptionAndTooltip(message).create();
            }
        }
        return null;
    }

    @Nullable
    static List<HighlightInfo> checkServiceImplementations(@NotNull PsiProvidesStatement statement) {
        PsiReferenceList implRefList;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(18);
        }
        if ((implRefList = statement.getImplementationList()) == null) {
            return null;
        }
        List<HighlightInfo> results = ContainerUtil.newSmartList();
        PsiJavaCodeReferenceElement intRef = statement.getInterfaceReference();
        PsiElement intTarget = intRef != null ? intRef.resolve() : null;
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiJavaCodeReferenceElement implRef : implRefList.getReferenceElements()) {
            String message;
            PsiMethod provider;
            PsiElement implTarget;
            String refText = implRef.getQualifiedName();
            if (!filter.add((String)refText)) {
                String message2 = JavaErrorMessages.message("module.duplicate.impl", refText);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(implRef).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createDeleteFix(implRef, QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
                results.add(info);
                continue;
            }
            if (!(intTarget instanceof PsiClass) || !((implTarget = implRef.resolve()) instanceof PsiClass)) continue;
            PsiClass implClass = (PsiClass)implTarget;
            if (ModuleHighlightUtil.findModule(statement) != ModuleHighlightUtil.findModule(implClass)) {
                String message3 = JavaErrorMessages.message("module.service.alien", new Object[0]);
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message3).create());
            }
            if ((provider = ContainerUtil.find(implClass.findMethodsByName("provider", false), m -> m.hasModifierProperty("public") && m.hasModifierProperty("static") && m.getParameterList().getParametersCount() == 0)) != null) {
                PsiClass typeClass;
                PsiType type = provider.getReturnType();
                PsiClass psiClass = typeClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
                if (InheritanceUtil.isInheritorOrSelf(typeClass, (PsiClass)intTarget, true)) continue;
                String message4 = JavaErrorMessages.message("module.service.provider.type", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message4).create());
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf(implClass, (PsiClass)intTarget, true)) {
                if (implClass.hasModifierProperty("abstract")) {
                    message = JavaErrorMessages.message("module.service.abstract", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message).create());
                    continue;
                }
                if (!ClassUtil.isTopLevelClass(implClass) && !implClass.hasModifierProperty("static")) {
                    message = JavaErrorMessages.message("module.service.inner", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message).create());
                    continue;
                }
                if (PsiUtil.hasDefaultConstructor(implClass)) continue;
                message = JavaErrorMessages.message("module.service.no.ctor", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message).create());
                continue;
            }
            message = JavaErrorMessages.message("module.service.impl", new Object[0]);
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message).create());
        }
        return results;
    }

    @Nullable
    static HighlightInfo checkClashingReads(@NotNull PsiJavaModule module) {
        Trinity<String, PsiJavaModule, PsiJavaModule> conflict;
        if (module == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(19);
        }
        if ((conflict = JavaModuleGraphUtil.findConflict(module)) != null) {
            String message = JavaErrorMessages.message("module.conflicting.reads", module.getName(), conflict.first, ((PsiJavaModule)conflict.second).getName(), ((PsiJavaModule)conflict.third).getName());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(module)).descriptionAndTooltip(message).create();
        }
        return null;
    }

    private static Module findModule(PsiElement element) {
        return Optional.ofNullable(element.getContainingFile()).map(PsiFile::getVirtualFile).map(f -> ModuleUtilCore.findModuleForFile(f, element.getProject())).orElse(null);
    }

    private static HighlightInfo moduleResolveError(PsiJavaModuleReferenceElement refElement, PsiPolyVariantReference ref) {
        if (ref.multiResolve(true).length == 0) {
            String message = JavaErrorMessages.message("module.not.found", refElement.getReferenceText());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refElement).descriptionAndTooltip(message).create();
        }
        if (ref.multiResolve(false).length > 1) {
            String message = JavaErrorMessages.message("module.ambiguous", refElement.getReferenceText());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(refElement).descriptionAndTooltip(message).create();
        }
        String message = JavaErrorMessages.message("module.not.on.path", refElement.getReferenceText());
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refElement).descriptionAndTooltip(message).create();
        ModuleHighlightUtil.factory().registerOrderEntryFixes(new QuickFixActionRegistrarImpl(info), ref);
        return info;
    }

    private static QuickFixFactory factory() {
        return QuickFixFactory.getInstance();
    }

    private static TextRange range(PsiJavaModule module) {
        PsiKeyword kw = PsiTreeUtil.getChildOfType(module, PsiKeyword.class);
        return new TextRange(kw != null ? kw.getTextOffset() : module.getTextOffset(), module.getNameIdentifier().getTextRange().getEndOffset());
    }

    private static PsiElement range(PsiJavaCodeReferenceElement refElement) {
        return ObjectUtils.notNull(refElement.getReferenceNameElement(), refElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDuplicateStatements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "checkUnusedServices";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPackageAccessTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageStatement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFileName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkFileDuplicates";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateStatements";
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkUnusedServices";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkFileLocation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkModuleReference";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkHostModuleStrength";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageReference";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageAccessTargets";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceImplementations";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkClashingReads";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkFileDuplicates$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

