/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ChangeToAppendUtil {
    @Nullable
    public static PsiExpression buildAppendExpression(PsiExpression appendable, PsiExpression concatenation) {
        if (concatenation == null) {
            return null;
        }
        PsiType type = appendable.getType();
        if (type == null) {
            return null;
        }
        boolean useStringValueOf = !type.equalsToText("java.lang.StringBuffer") && !type.equalsToText("java.lang.StringBuilder");
        StringBuilder result = ChangeToAppendUtil.buildAppendExpression(concatenation, useStringValueOf, new StringBuilder(appendable.getText()));
        if (result == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(appendable.getProject());
        return factory.createExpressionFromText(result.toString(), appendable);
    }

    @Nullable
    public static StringBuilder buildAppendExpression(@Nullable PsiExpression concatenation, boolean useStringValueOf, @NonNls StringBuilder out) {
        if (concatenation == null) {
            return null;
        }
        PsiType type = concatenation.getType();
        if (concatenation instanceof PsiPolyadicExpression && type != null && type.equalsToText("java.lang.String")) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)concatenation;
            PsiExpression[] operands = polyadicExpression.getOperands();
            boolean isConstant = true;
            boolean isString = false;
            StringBuilder builder = new StringBuilder();
            for (PsiExpression operand : operands) {
                if (isConstant && PsiUtil.isConstantExpression(operand)) {
                    PsiType operandType;
                    if (builder.length() != 0) {
                        builder.append('+');
                    }
                    if ((operandType = operand.getType()) != null && operandType.equalsToText("java.lang.String")) {
                        isString = true;
                    }
                    builder.append(CommentTracker.textWithSurroundingComments(operand));
                    continue;
                }
                if (operand.textMatches("\"\"")) continue;
                isConstant = false;
                if (builder.length() != 0) {
                    ChangeToAppendUtil.append(builder, useStringValueOf && !isString, out);
                    builder.setLength(0);
                }
                ChangeToAppendUtil.buildAppendExpression(operand, useStringValueOf, out);
            }
            if (builder.length() != 0) {
                ChangeToAppendUtil.append(builder, false, out);
            }
        } else if (concatenation instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)concatenation;
            PsiExpression expression = parenthesizedExpression.getExpression();
            if (expression != null) {
                return ChangeToAppendUtil.buildAppendExpression(expression, useStringValueOf, out);
            }
        } else {
            ChangeToAppendUtil.append(CommentTracker.textWithSurroundingComments(concatenation), useStringValueOf && (type == null || !type.equalsToText("java.lang.String")), out);
        }
        return out;
    }

    private static void append(CharSequence text2, boolean useStringValueOf, StringBuilder out) {
        out.append(".append(");
        if (useStringValueOf) {
            out.append("String.valueOf(").append(text2).append(')');
        } else {
            out.append(text2);
        }
        out.append(')');
    }
}

