/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetMapper;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFindUsagesHelper {
    private static final Logger LOG = Logger.getInstance("#com.intellij.find.findUsages.JavaFindUsagesHelper");

    @NotNull
    public static Set<String> getElementNames(@NotNull PsiElement element) {
        if (element == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiDirectory) {
            PsiPackage aPackage = ReadAction.compute(() -> {
                if (element == null) {
                    JavaFindUsagesHelper.$$$reportNull$$$0(84);
                }
                return JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
            });
            Set<Object> set = aPackage == null ? Collections.emptySet() : JavaFindUsagesHelper.getElementNames(aPackage);
            if (set == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(1);
            }
            return set;
        }
        HashSet<String> result = new HashSet<String>();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (element == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(83);
            }
            if (element instanceof PsiPackage) {
                ContainerUtil.addIfNotNull(result, ((PsiPackage)element).getQualifiedName());
            } else if (element instanceof PsiClass) {
                String qname = ((PsiClass)element).getQualifiedName();
                if (qname != null) {
                    result.add(qname);
                    PsiClass topLevelClass = PsiUtil.getTopLevelClass(element);
                    if (topLevelClass != null && !(topLevelClass instanceof PsiSyntheticClass)) {
                        String topName = topLevelClass.getQualifiedName();
                        assert (topName != null) : "topLevelClass : " + topLevelClass + "; element: " + element + " (" + qname + ") top level file: " + InjectedLanguageManager.getInstance(element.getProject()).getTopLevelFile(element);
                        if (qname.length() > topName.length()) {
                            result.add(topName + qname.substring(topName.length()).replace('.', '$'));
                        }
                    }
                }
            } else if (element instanceof PsiMethod) {
                ContainerUtil.addIfNotNull(result, ((PsiMethod)element).getName());
            } else if (element instanceof PsiVariable) {
                ContainerUtil.addIfNotNull(result, ((PsiVariable)element).getName());
            } else if (element instanceof PsiMetaOwner) {
                PsiMetaData metaData = ((PsiMetaOwner)((Object)element)).getMetaData();
                if (metaData != null) {
                    ContainerUtil.addIfNotNull(result, metaData.getName());
                }
            } else if (element instanceof PsiNamedElement) {
                ContainerUtil.addIfNotNull(result, ((PsiNamedElement)element).getName());
            } else if (element instanceof XmlAttributeValue) {
                ContainerUtil.addIfNotNull(result, ((XmlAttributeValue)element).getValue());
            } else {
                LOG.error("Unknown element type: " + element);
            }
        });
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public static boolean processElementUsages(@NotNull PsiElement element, @NotNull FindUsagesOptions options, @NotNull Processor<UsageInfo> processor) {
        Collection stringsToSearch;
        boolean success;
        if (element == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(3);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(5);
        }
        if (options instanceof JavaVariableFindUsagesOptions) {
            JavaVariableFindUsagesOptions varOptions = (JavaVariableFindUsagesOptions)options;
            if ((varOptions.isReadAccess || varOptions.isWriteAccess) && (varOptions.isReadAccess && varOptions.isWriteAccess ? !JavaFindUsagesHelper.addElementUsages(element, options, processor) : !JavaFindUsagesHelper.addElementUsages(element, varOptions, info -> {
                PsiElement element1;
                boolean isWrite;
                if (processor == null) {
                    JavaFindUsagesHelper.$$$reportNull$$$0(82);
                }
                boolean bl = isWrite = (element1 = info.getElement()) instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)element1);
                return isWrite != varOptions.isWriteAccess || processor.process((UsageInfo)info);
            }))) {
                return false;
            }
        } else if (options.isUsages && !JavaFindUsagesHelper.addElementUsages(element, options, processor)) {
            return false;
        }
        if (!(success = ReadAction.compute(() -> {
            if (element == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(79);
            }
            if (options == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(80);
            }
            if (processor == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(81);
            }
            if (ThrowSearchUtil.isSearchable(element) && options instanceof JavaThrowFindUsagesOptions && options.isUsages) {
                ThrowSearchUtil.Root[] roots;
                ThrowSearchUtil.Root root = ((JavaThrowFindUsagesOptions)options).getRoot();
                if (root == null && (roots = ThrowSearchUtil.getSearchRoots(element)) != null && roots.length > 0) {
                    root = roots[0];
                }
                if (root != null) {
                    return ThrowSearchUtil.addThrowUsages(processor, root, options);
                }
            }
            return true;
        }).booleanValue())) {
            return false;
        }
        if (options instanceof JavaPackageFindUsagesOptions && ((JavaPackageFindUsagesOptions)options).isClassesUsages && !JavaFindUsagesHelper.addClassesUsages((PsiPackage)element, (JavaPackageFindUsagesOptions)options, processor)) {
            return false;
        }
        if (options instanceof JavaClassFindUsagesOptions) {
            JavaClassFindUsagesOptions classOptions = (JavaClassFindUsagesOptions)options;
            PsiClass psiClass = (PsiClass)element;
            PsiManager manager = ReadAction.compute(psiClass::getManager);
            if (classOptions.isMethodsUsages && !JavaFindUsagesHelper.addMethodsUsages(psiClass, manager, classOptions, processor)) {
                return false;
            }
            if (classOptions.isFieldsUsages && !JavaFindUsagesHelper.addFieldsUsages(psiClass, manager, classOptions, processor)) {
                return false;
            }
            if (ReadAction.compute(() -> psiClass.isInterface()).booleanValue()) {
                if (classOptions.isDerivedInterfaces ? (classOptions.isImplementingClasses ? !JavaFindUsagesHelper.addInheritors(psiClass, classOptions, processor) : !JavaFindUsagesHelper.addDerivedInterfaces(psiClass, classOptions, processor)) : classOptions.isImplementingClasses && !JavaFindUsagesHelper.addImplementingClasses(psiClass, classOptions, processor)) {
                    return false;
                }
                if (classOptions.isImplementingClasses) {
                    FunctionalExpressionSearch.search(psiClass, classOptions.searchScope).forEach(new PsiElementProcessorAdapter<PsiFunctionalExpression>(expression -> {
                        if (options == null) {
                            JavaFindUsagesHelper.$$$reportNull$$$0(77);
                        }
                        if (processor == null) {
                            JavaFindUsagesHelper.$$$reportNull$$$0(78);
                        }
                        return JavaFindUsagesHelper.addResult(expression, options, processor);
                    }));
                }
            } else if (classOptions.isDerivedClasses && !JavaFindUsagesHelper.addInheritors(psiClass, classOptions, processor)) {
                return false;
            }
        }
        if (options instanceof JavaMethodFindUsagesOptions) {
            PsiMethod psiMethod = (PsiMethod)element;
            boolean isAbstract = ReadAction.compute(() -> psiMethod.hasModifierProperty("abstract"));
            JavaMethodFindUsagesOptions methodOptions = (JavaMethodFindUsagesOptions)options;
            if (isAbstract && methodOptions.isImplementingMethods || methodOptions.isOverridingMethods) {
                if (!JavaFindUsagesHelper.processOverridingMethods(psiMethod, processor, methodOptions)) {
                    return false;
                }
                FunctionalExpressionSearch.search(psiMethod, methodOptions.searchScope).forEach(new PsiElementProcessorAdapter<PsiFunctionalExpression>(expression -> {
                    if (options == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(75);
                    }
                    if (processor == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(76);
                    }
                    return JavaFindUsagesHelper.addResult(expression, options, processor);
                }));
            }
        }
        if (element instanceof PomTarget && !JavaFindUsagesHelper.addAliasingUsages((PomTarget)((Object)element), options, processor)) {
            return false;
        }
        Boolean isSearchable = ReadAction.compute(() -> {
            if (element == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(74);
            }
            return ThrowSearchUtil.isSearchable(element);
        });
        return isSearchable != false || !options.isSearchForTextOccurrences || !(options.searchScope instanceof GlobalSearchScope) || FindUsagesHelper.processUsagesInText(element, stringsToSearch = ApplicationManager.getApplication().runReadAction(() -> {
            if (element == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(73);
            }
            return JavaFindUsagesHelper.getElementNames(element);
        }), (GlobalSearchScope)options.searchScope, processor);
    }

    private static boolean addAliasingUsages(@NotNull PomTarget pomTarget, final @NotNull FindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        if (pomTarget == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(6);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(8);
        }
        for (AliasingPsiTargetMapper aliasingPsiTargetMapper : Extensions.getExtensions(AliasingPsiTargetMapper.EP_NAME)) {
            for (AliasingPsiTarget psiTarget : aliasingPsiTargetMapper.getTargets(pomTarget)) {
                boolean success = ReferencesSearch.search(new ReferencesSearch.SearchParameters(ReadAction.compute(() -> PomService.convertToPsi(psiTarget)), options.searchScope, false, options.fastTrack)).forEach((Processor<PsiReference>)new ReadActionProcessor<PsiReference>(){

                    @Override
                    public boolean processInReadAction(PsiReference reference) {
                        return JavaFindUsagesHelper.addResult(reference, options, (Processor<UsageInfo>)processor);
                    }
                });
                if (success) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processOverridingMethods(@NotNull PsiMethod psiMethod, @NotNull Processor<UsageInfo> processor, @NotNull JavaMethodFindUsagesOptions options) {
        if (psiMethod == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(10);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(11);
        }
        return OverridingMethodsSearch.search(psiMethod, options.searchScope, options.isCheckDeepInheritance).forEach(new PsiElementProcessorAdapter<PsiMethod>(element -> {
            if (options == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(71);
            }
            if (processor == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(72);
            }
            return JavaFindUsagesHelper.addResult(element.getNavigationElement(), (FindUsagesOptions)options, processor);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addClassesUsages(@NotNull PsiPackage aPackage, final @NotNull JavaPackageFindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        ProgressIndicator progress;
        if (aPackage == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(12);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(14);
        }
        if ((progress = ProgressManager.getInstance().getProgressIndicator()) != null) {
            progress.pushState();
        }
        try {
            ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
            JavaFindUsagesHelper.addClassesInPackage(aPackage, options.isIncludeSubpackages, classes);
            for (PsiClass aClass : classes) {
                if (progress != null) {
                    String name = ReadAction.compute(aClass::getName);
                    progress.setText(FindBundle.message("find.searching.for.references.to.class.progress", name));
                }
                ProgressManager.checkCanceled();
                boolean success = ReferencesSearch.search(new ReferencesSearch.SearchParameters(aClass, options.searchScope, false, options.fastTrack)).forEach((Processor<PsiReference>)new ReadActionProcessor<PsiReference>(){

                    @Override
                    public boolean processInReadAction(PsiReference psiReference) {
                        return JavaFindUsagesHelper.addResult(psiReference, options, (Processor<UsageInfo>)processor);
                    }
                });
                if (success) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
        return true;
    }

    private static void addClassesInPackage(@NotNull PsiPackage aPackage, boolean includeSubpackages, @NotNull List<PsiClass> array) {
        PsiDirectory[] dirs;
        if (aPackage == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(15);
        }
        if (array == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(16);
        }
        for (PsiDirectory dir : dirs = ReadAction.compute(aPackage::getDirectories)) {
            JavaFindUsagesHelper.addClassesInDirectory(dir, includeSubpackages, array);
        }
    }

    private static void addClassesInDirectory(@NotNull PsiDirectory dir, boolean includeSubdirs, @NotNull List<PsiClass> array) {
        if (dir == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(17);
        }
        if (array == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (dir == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(69);
            }
            if (array == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(70);
            }
            PsiClass[] classes = JavaDirectoryService.getInstance().getClasses(dir);
            ContainerUtil.addAll(array, classes);
            if (includeSubdirs) {
                PsiDirectory[] dirs;
                for (PsiDirectory directory : dirs = dir.getSubdirectories()) {
                    JavaFindUsagesHelper.addClassesInDirectory(directory, true, array);
                }
            }
        });
    }

    private static boolean addMethodsUsages(@NotNull PsiClass aClass, @NotNull PsiManager manager, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<UsageInfo> processor) {
        if (aClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(19);
        }
        if (manager == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(20);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(22);
        }
        if (options.isIncludeInherited) {
            PsiMethod[] methods = ReadAction.compute(aClass::getAllMethods);
            for (int i = 0; i < methods.length; ++i) {
                MethodReferencesSearch.SearchParameters parameters;
                boolean success;
                boolean equivalent;
                PsiMethod method = methods[i];
                int finalI = i;
                PsiClass methodClass = ReadAction.compute(() -> {
                    MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
                    for (int j = 0; j < finalI; ++j) {
                        if (!methodSignature.equals(methods[j].getSignature(PsiSubstitutor.EMPTY))) continue;
                        return null;
                    }
                    return method.getContainingClass();
                });
                if (methodClass == null || !((equivalent = ReadAction.compute(() -> {
                    if (manager == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(67);
                    }
                    if (aClass == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(68);
                    }
                    return manager.areElementsEquivalent(methodClass, aClass);
                }).booleanValue()) ? !JavaFindUsagesHelper.addElementUsages(method, options, processor) : !(success = MethodReferencesSearch.search(parameters = new MethodReferencesSearch.SearchParameters(method, options.searchScope, true, options.fastTrack)).forEach(new PsiReferenceProcessorAdapter(reference -> {
                    if (manager == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(63);
                    }
                    if (aClass == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(64);
                    }
                    if (options == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(65);
                    }
                    if (processor == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(66);
                    }
                    JavaFindUsagesHelper.addResultFromReference(reference, methodClass, manager, aClass, options, processor);
                    return true;
                }))))) continue;
                return false;
            }
        } else {
            PsiMethod[] methods;
            for (PsiMethod method : methods = ReadAction.compute(aClass::getMethods)) {
                if (JavaFindUsagesHelper.addElementUsages(method, options, processor)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean addFieldsUsages(final @NotNull PsiClass aClass, final @NotNull PsiManager manager, final @NotNull JavaClassFindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        if (aClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(23);
        }
        if (manager == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(24);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(25);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(26);
        }
        if (options.isIncludeInherited) {
            PsiField[] fields = ReadAction.compute(aClass::getAllFields);
            for (int i = 0; i < fields.length; ++i) {
                boolean success;
                boolean equivalent;
                int finalI = i;
                PsiField field = fields[i];
                final PsiClass fieldClass = ReadAction.compute(() -> {
                    for (int j = 0; j < finalI; ++j) {
                        if (!Comparing.strEqual(field.getName(), fields[j].getName())) continue;
                        return null;
                    }
                    return field.getContainingClass();
                });
                if (fieldClass == null || !((equivalent = ReadAction.compute(() -> {
                    if (manager == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(61);
                    }
                    if (aClass == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(62);
                    }
                    return manager.areElementsEquivalent(fieldClass, aClass);
                }).booleanValue()) ? !JavaFindUsagesHelper.addElementUsages(fields[i], options, processor) : !(success = ReferencesSearch.search(new ReferencesSearch.SearchParameters(field, options.searchScope, false, options.fastTrack)).forEach((Processor<PsiReference>)new ReadActionProcessor<PsiReference>(){

                    @Override
                    public boolean processInReadAction(PsiReference reference) {
                        return JavaFindUsagesHelper.addResultFromReference(reference, fieldClass, manager, aClass, options, processor);
                    }
                })))) continue;
                return false;
            }
        } else {
            PsiField[] fields;
            for (PsiField field : fields = ReadAction.compute(aClass::getFields)) {
                if (JavaFindUsagesHelper.addElementUsages(field, options, processor)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static PsiClass getFieldOrMethodAccessedClass(@NotNull PsiReferenceExpression ref, @NotNull PsiClass fieldOrMethodClass) {
        PsiElement[] children;
        if (ref == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(27);
        }
        if (fieldOrMethodClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(28);
        }
        if ((children = ref.getChildren()).length > 1 && children[0] instanceof PsiExpression) {
            PsiElement refElement;
            PsiExpression expr = (PsiExpression)children[0];
            PsiType type = expr.getType();
            if (type != null) {
                if (!(type instanceof PsiClassType)) {
                    return null;
                }
                return PsiUtil.resolveClassInType(type);
            }
            if (expr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)expr).resolve()) instanceof PsiClass) {
                return (PsiClass)refElement;
            }
            return null;
        }
        PsiManager manager = ref.getManager();
        for (PsiElement parent = ref; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PsiClass) || !manager.areElementsEquivalent(parent, fieldOrMethodClass) && !((PsiClass)parent).isInheritor(fieldOrMethodClass, true)) continue;
            return (PsiClass)parent;
        }
        return null;
    }

    private static boolean addInheritors(@NotNull PsiClass aClass, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<UsageInfo> processor) {
        if (aClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(29);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(30);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(31);
        }
        return ClassInheritorsSearch.search(aClass, options.searchScope, options.isCheckDeepInheritance).forEach(new PsiElementProcessorAdapter<PsiClass>(element -> {
            if (options == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(59);
            }
            if (processor == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(60);
            }
            return JavaFindUsagesHelper.addResult(element, (FindUsagesOptions)options, processor);
        }));
    }

    private static boolean addDerivedInterfaces(@NotNull PsiClass anInterface, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<UsageInfo> processor) {
        if (anInterface == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(32);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(34);
        }
        return ClassInheritorsSearch.search(anInterface, options.searchScope, options.isCheckDeepInheritance).forEach(new PsiElementProcessorAdapter<PsiClass>(inheritor -> {
            if (options == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(57);
            }
            if (processor == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(58);
            }
            return !inheritor.isInterface() || JavaFindUsagesHelper.addResult(inheritor, (FindUsagesOptions)options, processor);
        }));
    }

    private static boolean addImplementingClasses(@NotNull PsiClass anInterface, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<UsageInfo> processor) {
        if (anInterface == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(35);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(36);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(37);
        }
        return ClassInheritorsSearch.search(anInterface, options.searchScope, options.isCheckDeepInheritance).forEach(new PsiElementProcessorAdapter<PsiClass>(inheritor -> {
            if (options == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(55);
            }
            if (processor == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(56);
            }
            return inheritor.isInterface() || JavaFindUsagesHelper.addResult(inheritor, (FindUsagesOptions)options, processor);
        }));
    }

    private static boolean addResultFromReference(@NotNull PsiReference reference, @NotNull PsiClass methodClass, @NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull FindUsagesOptions options, @NotNull Processor<UsageInfo> processor) {
        PsiClass usedClass;
        PsiElement refElement;
        if (reference == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(38);
        }
        if (methodClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(39);
        }
        if (manager == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(40);
        }
        if (aClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(41);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(43);
        }
        return !((refElement = reference.getElement()) instanceof PsiReferenceExpression) || (usedClass = JavaFindUsagesHelper.getFieldOrMethodAccessedClass((PsiReferenceExpression)refElement, methodClass)) == null || !manager.areElementsEquivalent(usedClass, aClass) && !usedClass.isInheritor(aClass, true) || JavaFindUsagesHelper.addResult(refElement, options, processor);
    }

    private static boolean addElementUsages(@NotNull PsiElement element, final @NotNull FindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        if (element == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(44);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(45);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(46);
        }
        SearchScope searchScope = options.searchScope;
        PsiClass[] parentClass = new PsiClass[1];
        if (element instanceof PsiMethod && ReadAction.compute(() -> {
            if (element == null) {
                JavaFindUsagesHelper.$$$reportNull$$$0(54);
            }
            PsiMethod method = (PsiMethod)element;
            parentClass[0] = method.getContainingClass();
            return method.isConstructor();
        }).booleanValue()) {
            PsiMethod method = (PsiMethod)element;
            if (parentClass[0] != null) {
                boolean strictSignatureSearch = !(options instanceof JavaMethodFindUsagesOptions) || !((JavaMethodFindUsagesOptions)options).isIncludeOverloadUsages;
                return MethodReferencesSearch.search(new MethodReferencesSearch.SearchParameters(method, searchScope, strictSignatureSearch, options.fastTrack)).forEach((Processor<PsiReference>)new ReadActionProcessor<PsiReference>(){

                    @Override
                    public boolean processInReadAction(PsiReference ref) {
                        return JavaFindUsagesHelper.addResult(ref, options, (Processor<UsageInfo>)processor);
                    }
                });
            }
            return true;
        }
        ReadActionProcessor<PsiReference> consumer = new ReadActionProcessor<PsiReference>(){

            @Override
            public boolean processInReadAction(PsiReference ref) {
                return JavaFindUsagesHelper.addResult(ref, options, (Processor<UsageInfo>)processor);
            }
        };
        if (element instanceof PsiMethod) {
            boolean strictSignatureSearch = !(options instanceof JavaMethodFindUsagesOptions) || !((JavaMethodFindUsagesOptions)options).isIncludeOverloadUsages;
            return MethodReferencesSearch.search(new MethodReferencesSearch.SearchParameters((PsiMethod)element, searchScope, strictSignatureSearch, options.fastTrack)).forEach((Processor<PsiReference>)consumer);
        }
        return ReferencesSearch.search(new ReferencesSearch.SearchParameters(element, searchScope, false, options.fastTrack)).forEach((Processor<PsiReference>)consumer);
    }

    private static boolean addResult(@NotNull PsiElement element, @NotNull FindUsagesOptions options, @NotNull Processor<UsageInfo> processor) {
        if (element == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(47);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(48);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(49);
        }
        return !JavaFindUsagesHelper.filterUsage(element, options) || processor.process(new UsageInfo(element));
    }

    private static boolean addResult(@NotNull PsiReference ref, @NotNull FindUsagesOptions options, @NotNull Processor<UsageInfo> processor) {
        if (ref == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(50);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(51);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(52);
        }
        if (JavaFindUsagesHelper.filterUsage(ref.getElement(), options)) {
            TextRange rangeInElement = ref.getRangeInElement();
            return processor.process(new UsageInfo(ref.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false));
        }
        return true;
    }

    private static boolean filterUsage(PsiElement usage, @NotNull FindUsagesOptions options) {
        PsiElement parent;
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(53);
        }
        if (!(usage instanceof PsiJavaCodeReferenceElement)) {
            return true;
        }
        if (options instanceof JavaPackageFindUsagesOptions && !((JavaPackageFindUsagesOptions)options).isIncludeSubpackages && ((PsiReference)((Object)usage)).resolve() instanceof PsiPackage && (parent = usage.getParent()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)parent).resolve() instanceof PsiPackage) {
            return false;
        }
        if (!(usage instanceof PsiReferenceExpression)) {
            if (options instanceof JavaFindUsagesOptions && ((JavaFindUsagesOptions)options).isSkipImportStatements) {
                parent = usage.getParent();
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiImportStatement) {
                    return false;
                }
            }
            if (options instanceof JavaPackageFindUsagesOptions && ((JavaPackageFindUsagesOptions)options).isSkipPackageStatements) {
                parent = usage.getParent();
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiPackageStatement) {
                    return false;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/JavaFindUsagesHelper";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 13: 
            case 21: 
            case 25: 
            case 30: 
            case 33: 
            case 36: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 65: 
            case 71: 
            case 75: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 14: 
            case 22: 
            case 26: 
            case 31: 
            case 34: 
            case 37: 
            case 43: 
            case 46: 
            case 49: 
            case 52: 
            case 56: 
            case 58: 
            case 60: 
            case 66: 
            case 72: 
            case 76: 
            case 78: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomTarget";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 16: 
            case 18: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 17: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 19: 
            case 23: 
            case 29: 
            case 41: 
            case 62: 
            case 64: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 20: 
            case 24: 
            case 40: 
            case 61: 
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 27: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldOrMethodClass";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/JavaFindUsagesHelper";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementNames";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processElementUsages";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAliasingUsages";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processOverridingMethods";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addClassesUsages";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addClassesInPackage";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addClassesInDirectory";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addMethodsUsages";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addFieldsUsages";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFieldOrMethodAccessedClass";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addInheritors";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addDerivedInterfaces";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addImplementingClasses";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addResultFromReference";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addElementUsages";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addResult";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "filterUsage";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addElementUsages$21";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addImplementingClasses$20";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addDerivedInterfaces$19";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addInheritors$18";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addFieldsUsages$17";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMethodsUsages$15";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMethodsUsages$14";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addClassesInDirectory$12";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processOverridingMethods$11";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementUsages$9";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementUsages$8";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementUsages$7";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementUsages$5";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementUsages$3";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementUsages$2";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getElementNames$1";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getElementNames$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

