/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceUtil {
    private static final Logger LOG = Logger.getInstance(PsiMethodReferenceUtil.class);

    public static boolean isSecondSearchPossible(PsiType[] parameterTypes, QualifierResolveResult qualifierResolveResult, PsiMethodReferenceExpression methodRef) {
        return parameterTypes.length > 0 && !(parameterTypes[0] instanceof PsiPrimitiveType) && !methodRef.isConstructor() && PsiMethodReferenceUtil.isStaticallyReferenced(methodRef) && PsiMethodReferenceUtil.isReceiverType(parameterTypes[0], qualifierResolveResult.getContainingClass(), qualifierResolveResult.getSubstitutor());
    }

    public static boolean isResolvedBySecondSearch(@NotNull PsiMethodReferenceExpression methodRef, @Nullable MethodSignature signature, boolean varArgs, boolean isStatic, int parametersCount) {
        if (methodRef == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(0);
        }
        if (signature == null) {
            return false;
        }
        QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(methodRef);
        PsiType[] functionalMethodParameterTypes = signature.getParameterTypes();
        return (parametersCount + 1 == functionalMethodParameterTypes.length && !varArgs || varArgs && functionalMethodParameterTypes.length > 0 && !isStatic) && PsiMethodReferenceUtil.isSecondSearchPossible(functionalMethodParameterTypes, qualifierResolveResult, methodRef);
    }

    @Nullable
    public static PsiType getQualifierType(PsiMethodReferenceExpression expression) {
        PsiTypeElement typeElement = expression.getQualifierType();
        if (typeElement != null) {
            return typeElement.getType();
        }
        PsiType qualifierType = null;
        PsiElement qualifier = expression.getQualifier();
        if (qualifier instanceof PsiExpression) {
            qualifierType = ((PsiExpression)qualifier).getType();
        }
        if (qualifierType == null && qualifier instanceof PsiReferenceExpression) {
            return JavaPsiFacade.getElementFactory(expression.getProject()).createType((PsiReferenceExpression)qualifier);
        }
        return qualifierType;
    }

    public static boolean isReturnTypeCompatible(PsiMethodReferenceExpression expression, JavaResolveResult result, PsiType functionalInterfaceType) {
        return PsiMethodReferenceUtil.isReturnTypeCompatible(expression, result, functionalInterfaceType, null);
    }

    public static PsiType getMethodReferenceReturnType(PsiMethodReferenceExpression expression) {
        return PsiMethodReferenceUtil.getMethodReferenceReturnType(expression, expression.advancedResolve(false));
    }

    private static PsiType getMethodReferenceReturnType(PsiMethodReferenceExpression expression, JavaResolveResult result) {
        PsiSubstitutor subst = result.getSubstitutor();
        PsiType methodReturnType = null;
        PsiClass containingClass = null;
        PsiElement resolve = result.getElement();
        if (resolve instanceof PsiMethod) {
            containingClass = ((PsiMethod)resolve).getContainingClass();
            methodReturnType = PsiTypesUtil.patchMethodGetClassReturnType(expression, (PsiMethod)resolve);
            if (methodReturnType == null) {
                methodReturnType = ((PsiMethod)resolve).getReturnType();
                if (PsiType.VOID.equals(methodReturnType)) {
                    return methodReturnType;
                }
                methodReturnType = subst.substitute(methodReturnType);
            }
        } else if (resolve instanceof PsiClass) {
            PsiTypeParameter[] typeParameters;
            if (PsiEquivalenceUtil.areElementsEquivalent(resolve, JavaPsiFacade.getElementFactory(expression.getProject()).getArrayClass(PsiUtil.getLanguageLevel(expression))) && (typeParameters = ((PsiClass)resolve).getTypeParameters()).length == 1) {
                PsiType arrayComponentType = subst.substitute(typeParameters[0]);
                if (arrayComponentType == null) {
                    return null;
                }
                methodReturnType = arrayComponentType.createArrayType();
            }
            containingClass = (PsiClass)resolve;
        }
        if (methodReturnType == null) {
            if (containingClass == null) {
                return null;
            }
            methodReturnType = JavaPsiFacade.getElementFactory(expression.getProject()).createType(containingClass, subst);
        }
        return PsiUtil.captureToplevelWildcards(methodReturnType, expression);
    }

    private static boolean isReturnTypeCompatible(PsiMethodReferenceExpression expression, JavaResolveResult result, PsiType functionalInterfaceType, Ref<String> errorMessage) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (interfaceMethod != null) {
            PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
            if (PsiType.VOID.equals(interfaceReturnType) || interfaceReturnType == null) {
                return true;
            }
            PsiType methodReturnType = PsiMethodReferenceUtil.getMethodReferenceReturnType(expression, result);
            if (methodReturnType == null || PsiType.VOID.equals(methodReturnType)) {
                return false;
            }
            if (TypeConversionUtil.isAssignable(interfaceReturnType, methodReturnType)) {
                return true;
            }
            if (errorMessage != null) {
                errorMessage.set("Bad return type in method reference: cannot convert " + methodReturnType.getCanonicalText() + " to " + interfaceReturnType.getCanonicalText());
            }
        }
        return false;
    }

    public static boolean isValidQualifier(PsiMethodReferenceExpression expression) {
        PsiElement referenceNameElement = expression.getReferenceNameElement();
        if (referenceNameElement instanceof PsiKeyword) {
            PsiElement qualifier = expression.getQualifier();
            if (qualifier instanceof PsiTypeElement) {
                return true;
            }
            if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static QualifierResolveResult getQualifierResolveResult(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        if (methodReferenceExpression == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(1);
        }
        PsiClass containingClass = null;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiExpression expression = methodReferenceExpression.getQualifierExpression();
        if (expression != null) {
            JavaResolveResult resolveResult;
            PsiElement resolve;
            PsiType expressionType = expression.getType();
            expressionType = expressionType instanceof PsiCapturedWildcardType ? ((PsiCapturedWildcardType)expressionType).getUpperBound() : PsiMethodReferenceUtil.replaceArrayType(expressionType, expression);
            PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType(expressionType);
            containingClass = result.getElement();
            if (containingClass != null) {
                substitutor = result.getSubstitutor();
            }
            if (containingClass == null && expression instanceof PsiReferenceExpression && (resolve = (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement()) instanceof PsiClass) {
                containingClass = (PsiClass)resolve;
                substitutor = resolveResult.getSubstitutor();
                QualifierResolveResult qualifierResolveResult = new QualifierResolveResult(containingClass, substitutor, true);
                if (qualifierResolveResult == null) {
                    PsiMethodReferenceUtil.$$$reportNull$$$0(2);
                }
                return qualifierResolveResult;
            }
        } else {
            PsiType type;
            PsiClassType.ClassResolveResult result;
            PsiTypeElement typeElement = methodReferenceExpression.getQualifierType();
            if (typeElement != null && (containingClass = (result = PsiUtil.resolveGenericsClassInType(type = PsiMethodReferenceUtil.replaceArrayType(typeElement.getType(), typeElement))).getElement()) != null) {
                QualifierResolveResult qualifierResolveResult = new QualifierResolveResult(containingClass, result.getSubstitutor(), true);
                if (qualifierResolveResult == null) {
                    PsiMethodReferenceUtil.$$$reportNull$$$0(3);
                }
                return qualifierResolveResult;
            }
        }
        QualifierResolveResult qualifierResolveResult = new QualifierResolveResult(containingClass, substitutor, false);
        if (qualifierResolveResult == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(4);
        }
        return qualifierResolveResult;
    }

    public static boolean isStaticallyReferenced(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        PsiExpression qualifierExpression;
        if (methodReferenceExpression == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(5);
        }
        if ((qualifierExpression = methodReferenceExpression.getQualifierExpression()) != null) {
            return qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() instanceof PsiClass;
        }
        return true;
    }

    public static boolean isReceiverType(@Nullable PsiType receiverType, PsiClass containingClass, PsiSubstitutor psiSubstitutor) {
        if (receiverType == null) {
            return false;
        }
        return TypeConversionUtil.isAssignable(JavaPsiFacade.getElementFactory(containingClass.getProject()).createType(containingClass, psiSubstitutor), PsiMethodReferenceUtil.replaceArrayType(receiverType, containingClass));
    }

    public static PsiType getFirstParameterType(PsiType functionalInterfaceType, PsiElement context) {
        int interfaceMethodParamsLength;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        MethodSignature function = LambdaUtil.getFunction(resolveResult.getElement());
        if (function != null && (interfaceMethodParamsLength = function.getParameterTypes().length) > 0) {
            PsiType type = resolveResult.getSubstitutor().substitute(function.getParameterTypes()[0]);
            return type != null ? PsiUtil.captureToplevelWildcards(type, context) : null;
        }
        return null;
    }

    private static PsiType replaceArrayType(PsiType type, @NotNull PsiElement context) {
        if (context == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(6);
        }
        if (type instanceof PsiArrayType) {
            type = JavaPsiFacade.getElementFactory(context.getProject()).getArrayClassType(((PsiArrayType)type).getComponentType(), PsiUtil.getLanguageLevel(context));
        }
        return type;
    }

    public static String checkMethodReferenceContext(PsiMethodReferenceExpression methodRef) {
        PsiElement resolve = methodRef.resolve();
        if (resolve == null) {
            return null;
        }
        return PsiMethodReferenceUtil.checkMethodReferenceContext(methodRef, resolve, methodRef.getFunctionalInterfaceType());
    }

    public static String checkMethodReferenceContext(PsiMethodReferenceExpression methodRef, PsiElement resolve, PsiType functionalInterfaceType) {
        PsiClass outerClass;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement referenceElement;
        PsiClass containingClass = resolve instanceof PsiMethod ? ((PsiMethod)resolve).getContainingClass() : (PsiClass)resolve;
        boolean isStaticSelector = PsiMethodReferenceUtil.isStaticallyReferenced(methodRef);
        PsiElement qualifier = methodRef.getQualifier();
        boolean isMethodStatic = false;
        boolean receiverReferenced = false;
        boolean isConstructor = true;
        if (resolve instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolve;
            isMethodStatic = method.hasModifierProperty("static");
            isConstructor = method.isConstructor();
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            receiverReferenced = PsiMethodReferenceUtil.isResolvedBySecondSearch(methodRef, interfaceMethod != null ? interfaceMethod.getSignature(LambdaUtil.getSubstitutor(interfaceMethod, resolveResult)) : null, method.isVarArgs(), isMethodStatic, method.getParameterList().getParametersCount());
            if (method.hasModifierProperty("abstract") && qualifier instanceof PsiSuperExpression) {
                return "Abstract method '" + method.getName() + "' cannot be accessed directly";
            }
        }
        if (!receiverReferenced) {
            if (isStaticSelector && !isMethodStatic && !isConstructor) {
                return "Non-static method cannot be referenced from a static context";
            }
            if (!isStaticSelector && isMethodStatic) {
                return "Static method referenced through non-static qualifier";
            }
        } else if (isStaticSelector && isMethodStatic) {
            return "Static method referenced through receiver";
        }
        if (isMethodStatic && isStaticSelector && qualifier instanceof PsiTypeElement && (referenceElement = PsiTreeUtil.getChildOfType(qualifier, PsiJavaCodeReferenceElement.class)) != null && (parameterList = referenceElement.getParameterList()) != null && parameterList.getTypeArguments().length > 0) {
            return "Parameterized qualifier on static method reference";
        }
        if (isConstructor && containingClass != null && PsiUtil.isInnerClass(containingClass) && containingClass.isPhysical() && (outerClass = containingClass.getContainingClass()) != null && !InheritanceUtil.hasEnclosingInstanceInScope(outerClass, (PsiElement)methodRef, true, false)) {
            return "An enclosing instance of type " + PsiFormatUtil.formatClass(outerClass, 1) + " is not in scope";
        }
        return null;
    }

    public static String checkTypeArguments(PsiTypeElement qualifier, PsiType psiType) {
        PsiJavaCodeReferenceElement referenceElement;
        if (psiType instanceof PsiClassType && (referenceElement = qualifier.getInnermostComponentReferenceElement()) != null) {
            PsiType[] typeParameters;
            for (PsiType typeParameter : typeParameters = referenceElement.getTypeParameters()) {
                if (!(typeParameter instanceof PsiWildcardType)) continue;
                return "Unexpected wildcard";
            }
        }
        return null;
    }

    public static String checkReturnType(PsiMethodReferenceExpression expression, JavaResolveResult result, PsiType functionalInterfaceType) {
        Ref<String> errorMessage = Ref.create();
        if (!PsiMethodReferenceUtil.isReturnTypeCompatible(expression, result, functionalInterfaceType, errorMessage)) {
            return errorMessage.get();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiMethodReferenceUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiMethodReferenceUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierResolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedBySecondSearch";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierResolveResult";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStaticallyReferenced";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceArrayType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class QualifierResolveResult {
        private final PsiClass myContainingClass;
        private final PsiSubstitutor mySubstitutor;
        private final boolean myReferenceTypeQualified;

        public QualifierResolveResult(PsiClass containingClass, PsiSubstitutor substitutor, boolean referenceTypeQualified) {
            this.myContainingClass = containingClass;
            this.mySubstitutor = substitutor;
            this.myReferenceTypeQualified = referenceTypeQualified;
        }

        @Nullable
        public PsiClass getContainingClass() {
            return this.myContainingClass;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public boolean isReferenceTypeQualified() {
            return this.myReferenceTypeQualified;
        }
    }
}

