/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiParserFacadeImpl
implements PsiParserFacade {
    protected final PsiManagerEx myManager;

    public PsiParserFacadeImpl(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiElement createWhiteSpaceFromText(@NotNull @NonNls String text2) throws IncorrectOperationException {
        if (text2 == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(0);
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, null).getTreeElement();
        LeafElement newElement = ASTFactory.leaf(TokenType.WHITE_SPACE, holderElement.getCharTable().intern(text2));
        holderElement.rawAddChildren(newElement);
        GeneratedMarkerVisitor.markGenerated(newElement.getPsi());
        PsiElement psiElement = newElement.getPsi();
        if (psiElement == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiComment createLineCommentFromText(@NotNull LanguageFileType fileType, @NotNull String text2) throws IncorrectOperationException {
        if (fileType == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(3);
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(fileType.getLanguage());
        assert (commenter != null);
        String prefix = commenter.getLineCommentPrefix();
        if (prefix == null) {
            throw new IncorrectOperationException("No line comment prefix defined for language " + fileType.getLanguage().getID());
        }
        PsiFile aFile = this.createDummyFile(prefix + text2, fileType);
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(4);
        }
        return psiComment;
    }

    @Override
    @NotNull
    public PsiComment createBlockCommentFromText(@NotNull Language language, @NotNull String text2) throws IncorrectOperationException {
        if (language == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(6);
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        assert (commenter != null) : language;
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        PsiFile aFile = PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText("_Dummy_", language, (CharSequence)(blockCommentPrefix + text2 + blockCommentSuffix));
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(7);
        }
        return psiComment;
    }

    @Override
    @NotNull
    public PsiComment createLineOrBlockCommentFromText(@NotNull Language lang, @NotNull String text2) throws IncorrectOperationException {
        if (lang == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(9);
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(lang);
        assert (commenter != null) : lang;
        String prefix = commenter.getLineCommentPrefix();
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        assert (prefix != null || blockCommentPrefix != null && blockCommentSuffix != null);
        PsiFile aFile = PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText("_Dummy_", lang, (CharSequence)(prefix != null ? prefix + text2 : blockCommentPrefix + text2 + blockCommentSuffix));
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(10);
        }
        return psiComment;
    }

    private PsiComment findPsiCommentChild(PsiFile aFile) {
        PsiElement[] children;
        for (PsiElement aChildren : children = aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree(comment), null);
            return comment;
        }
        throw new IncorrectOperationException("Incorrect comment \"" + aFile.getText() + "\".");
    }

    protected PsiFile createDummyFile(String text2, LanguageFileType fileType) {
        String ext = fileType.getDefaultExtension();
        String fileName = "_Dummy_." + ext;
        return PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText(fileType, fileName, (CharSequence)text2, 0, text2.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiParserFacadeImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiParserFacadeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createWhiteSpaceFromText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineCommentFromText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockCommentFromText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineOrBlockCommentFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWhiteSpaceFromText";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLineCommentFromText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBlockCommentFromText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLineOrBlockCommentFromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

