/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlyStrongTypeCastInspection
extends BaseInspection {
    public boolean ignoreInMatchingInstanceof = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.strong.type.cast.display.name", new Object[0]);
        if (string == null) {
            OverlyStrongTypeCastInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType expectedType = (PsiType)infos[0];
        String typeText = expectedType.getPresentableText();
        String string = InspectionGadgetsBundle.message("overly.strong.type.cast.problem.descriptor", typeText);
        if (string == null) {
            OverlyStrongTypeCastInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("overly.strong.type.cast.ignore.in.matching.instanceof.option", new Object[0]), this, "ignoreInMatchingInstanceof");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new OverlyStrongCastFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyStrongTypeCastVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class OverlyStrongTypeCastVisitor
    extends BaseInspectionVisitor {
        private OverlyStrongTypeCastVisitor() {
        }

        @Override
        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            PsiArrayType arrayType;
            PsiType componentType;
            if (expression == null) {
                OverlyStrongTypeCastVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeCastExpression(expression);
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType operandType = operand.getType();
            if (operandType == null) {
                return;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, true);
            if (expectedType == null || expectedType.equals(type)) {
                return;
            }
            PsiClass resolved = PsiUtil.resolveClassInType(expectedType);
            if (resolved != null && !resolved.isPhysical()) {
                return;
            }
            if (expectedType.isAssignableFrom(operandType) && !MethodCallUtils.isNecessaryForSurroundingMethodCall(expression, operand)) {
                return;
            }
            if (TypeUtils.isTypeParameter(expectedType)) {
                return;
            }
            if (expectedType instanceof PsiArrayType && TypeUtils.isTypeParameter(componentType = (arrayType = (PsiArrayType)expectedType).getDeepComponentType())) {
                return;
            }
            if (type instanceof PsiPrimitiveType || expectedType instanceof PsiPrimitiveType) {
                return;
            }
            if (PsiPrimitiveType.getUnboxedType(type) != null || PsiPrimitiveType.getUnboxedType(expectedType) != null) {
                return;
            }
            if (expectedType instanceof PsiClassType) {
                PsiClassType classType;
                PsiClassType rawType;
                PsiClassType expectedClassType = (PsiClassType)expectedType;
                PsiClassType expectedRawType = expectedClassType.rawType();
                if (type.equals(expectedRawType)) {
                    return;
                }
                if (type instanceof PsiClassType && (rawType = (classType = (PsiClassType)type).rawType()).equals(expectedRawType)) {
                    return;
                }
                if (type instanceof PsiArrayType) {
                    return;
                }
            }
            if (OverlyStrongTypeCastInspection.this.ignoreInMatchingInstanceof && InstanceOfUtils.hasAgreeingInstanceof(expression)) {
                return;
            }
            PsiTypeElement castTypeElement = expression.getCastType();
            if (castTypeElement == null) {
                return;
            }
            if (operand instanceof PsiFunctionalExpression && !LambdaUtil.isFunctionalType(expectedType)) {
                return;
            }
            this.registerError((PsiElement)castTypeElement, expectedType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection$OverlyStrongTypeCastVisitor", "visitTypeCastExpression"));
        }
    }

    private static class OverlyStrongCastFix
    extends InspectionGadgetsFix {
        private OverlyStrongCastFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("overly.strong.type.cast.weaken.quickfix", new Object[0]);
            if (string == null) {
                OverlyStrongCastFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement castTypeElement = descriptor.getPsiElement();
            PsiTypeCastExpression expression = (PsiTypeCastExpression)castTypeElement.getParent();
            if (expression == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, true);
            if (expectedType == null) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            String newExpression = '(' + expectedType.getCanonicalText() + ')' + operand.getText();
            PsiReplacementUtil.replaceExpressionAndShorten(expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection$OverlyStrongCastFix", "getFamilyName"));
        }
    }
}

